/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDataRecord
implements DataRecord {
    private static Logger log = LoggerFactory.getLogger(InMemoryDataRecord.class);
    private static final String PREFIX = "0x";
    private final byte[] data;
    private DataIdentifier identifier;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final InMemoryDataRecord EMPTY = new InMemoryDataRecord(EMPTY_BYTE_ARRAY);

    private InMemoryDataRecord(byte[] data) {
        this.data = data;
    }

    static InMemoryDataRecord getInstance(byte[] data) {
        if (data.length == 0) {
            return EMPTY;
        }
        return new InMemoryDataRecord(data);
    }

    public static boolean isInstance(String id) {
        return id.startsWith(PREFIX);
    }

    public static InMemoryDataRecord getInstance(String id) throws IllegalArgumentException {
        assert (id.startsWith(PREFIX));
        int len = (id = id.substring(PREFIX.length())).length();
        if (len % 2 != 0) {
            String msg = "unable to deserialize byte array " + id + " , length=" + id.length();
            log.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        byte[] data = new byte[len /= 2];
        try {
            for (int i = 0; i < len; ++i) {
                data[i] = (byte)(Character.digit(id.charAt(2 * i), 16) << 4 | Character.digit(id.charAt(2 * i + 1), 16));
            }
        }
        catch (NumberFormatException e) {
            String msg = "unable to deserialize byte array " + id;
            log.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        return InMemoryDataRecord.getInstance(data);
    }

    @Override
    public DataIdentifier getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new DataIdentifier(this.toString());
        }
        return this.identifier;
    }

    @Override
    public String getReference() {
        return null;
    }

    @Override
    public long getLength() throws DataStoreException {
        return this.data.length;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(PREFIX.length() + 2 * this.data.length);
        buff.append(PREFIX);
        for (byte aData : this.data) {
            int c = aData & 0xFF;
            buff.append(Integer.toHexString(c >> 4));
            buff.append(Integer.toHexString(c & 0xF));
        }
        return buff.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InMemoryDataRecord) {
            InMemoryDataRecord other = (InMemoryDataRecord)obj;
            return Arrays.equals(this.data, other.data);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

