/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class MapUtils {
    private MapUtils() {
    }

    @NotNull
    public static <K, V> Map<K, V> newHashMap(int capacity) {
        return new HashMap(CollectionUtils.ensureCapacity(capacity));
    }

    @NotNull
    public static Map<String, String> fromProperties(@NotNull Properties properties) {
        Objects.requireNonNull(properties);
        return properties.entrySet().stream().collect(Collectors.toUnmodifiableMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
    }

    @NotNull
    public static <K, V> Map<K, V> filterKeys(@NotNull Map<K, V> map, @NotNull Predicate<? super K> predicate) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(predicate);
        return map.entrySet().stream().filter(e -> predicate.test((Object)e.getKey())).collect(LinkedHashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), HashMap::putAll);
    }

    @NotNull
    public static <K, V> Map<K, V> filterValues(@NotNull Map<K, V> map, @NotNull Predicate<? super V> predicate) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(predicate);
        return map.entrySet().stream().filter(e -> predicate.test((Object)e.getValue())).collect(LinkedHashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), HashMap::putAll);
    }

    @NotNull
    public static <K, V> Map<K, V> filterEntries(@NotNull Map<K, V> map, @NotNull Predicate<? super Map.Entry<K, V>> predicate) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(predicate);
        return map.entrySet().stream().filter(predicate).collect(LinkedHashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), HashMap::putAll);
    }
}

