/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.sync.content.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.apache.sling.ide.sync.content.WorkspaceDirectory;
import org.apache.sling.ide.sync.content.WorkspaceFile;
import org.apache.sling.ide.sync.content.WorkspacePath;
import org.apache.sling.ide.sync.content.WorkspacePaths;
import org.apache.sling.ide.sync.content.WorkspaceProject;

public class NonExistingFile
implements WorkspaceFile {
    private final WorkspacePath path;
    private final WorkspaceDirectory parent;

    public NonExistingFile(WorkspacePath path, WorkspaceDirectory parent) {
        this.path = path;
        this.parent = parent;
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    public WorkspacePath getLocalPath() {
        return this.path;
    }

    @Override
    public Path getOSPath() {
        return WorkspacePaths.toOsPath(this.path);
    }

    @Override
    public WorkspaceProject getProject() {
        return this.parent.getProject();
    }

    @Override
    public long getLastModified() {
        throw new IllegalArgumentException("File at " + String.valueOf(this.path) + " does not exist");
    }

    @Override
    public Object getTransientProperty(String propertyName) {
        throw new IllegalArgumentException("File at " + String.valueOf(this.path) + " does not exist");
    }

    @Override
    public InputStream getContents() throws IOException {
        throw new IllegalArgumentException("File at " + String.valueOf(this.path) + " does not exist");
    }

    @Override
    public WorkspaceDirectory getParent() {
        return this.parent;
    }
}

