/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.security.authorization;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.jcr2spi.config.RepositoryConfig;
import org.apache.jackrabbit.jcr2spi.security.authorization.AccessControlProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlProviderStub {
    private static Logger log = LoggerFactory.getLogger(AccessControlProviderStub.class);
    private static final String ACCESS_CONTROL_PROVIDER_PROPERTIES = "accessControlProvider.properties";
    private static final String PROPERTY_ACCESSCONTROL_PROVIDER_CLASS = "org.apache.jackrabbit.jcr2spi.AccessControlProvider.class";

    private AccessControlProviderStub() {
    }

    public static AccessControlProvider newInstance(RepositoryConfig config) throws RepositoryException {
        String className = AccessControlProviderStub.getProviderClass(config);
        if (className != null) {
            try {
                Class<?> acProviderClass = Class.forName(className);
                if (AccessControlProvider.class.isAssignableFrom(acProviderClass)) {
                    AccessControlProvider acProvider = (AccessControlProvider)acProviderClass.newInstance();
                    acProvider.init(config);
                    return acProvider;
                }
                throw new RepositoryException("Fail to create AccessControlProvider from configuration.");
            }
            catch (Exception e) {
                throw new RepositoryException("Fail to create AccessControlProvider from configuration.");
            }
        }
        throw new UnsupportedRepositoryOperationException("Access control is not supported");
    }

    private static String getProviderClass(RepositoryConfig config) throws RepositoryException {
        String implClass = config.getConfiguration(PROPERTY_ACCESSCONTROL_PROVIDER_CLASS, null);
        if (implClass != null) {
            return implClass;
        }
        try {
            Properties prop = new Properties();
            InputStream is = AccessControlProviderStub.class.getClassLoader().getResourceAsStream(ACCESS_CONTROL_PROVIDER_PROPERTIES);
            if (is != null) {
                prop.load(is);
                if (prop.containsKey(PROPERTY_ACCESSCONTROL_PROVIDER_CLASS)) {
                    return prop.getProperty(PROPERTY_ACCESSCONTROL_PROVIDER_CLASS);
                }
                log.debug("Missing AccessControlProvider configuration.");
            } else {
                log.debug("Fail to locate the access control provider properties file.");
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Fail to load AccessControlProvider configuration.");
        }
        return null;
    }
}

