/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jetty.v9.client;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jetty.v9.client.CompleteListenerWrapper;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;

public class AsyncHttpRequestSendInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        HttpRequest request = (HttpRequest)objInst;
        ContextCarrier contextCarrier = new ContextCarrier();
        AbstractSpan span = ContextManager.createExitSpan((String)request.getURI().getPath(), (ContextCarrier)contextCarrier, (String)(request.getHost() + ":" + request.getPort()));
        span.setComponent((Component)ComponentsDefine.JETTY_CLIENT);
        Tags.HTTP.METHOD.set(span, this.getHttpMethod(request));
        Tags.URL.set(span, request.getURI().toString());
        SpanLayer.asHttp((AbstractSpan)span);
        CarrierItem next = contextCarrier.items();
        HttpFields field = request.getHeaders();
        while (next.hasNext()) {
            next = next.next();
            field.add(next.getHeadKey(), next.getHeadValue());
        }
        span.prepareForAsync();
        request.attribute("SW_JETTY_EXIT_SPAN", (Object)span);
        Response.CompleteListener callback = (Response.CompleteListener)allArguments[0];
        allArguments[0] = new CompleteListenerWrapper(callback, ContextManager.capture());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    public String getHttpMethod(HttpRequest request) {
        String method = request.getMethod();
        if (method == null || method.length() == 0) {
            method = "GET";
        }
        return method;
    }
}

