/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticsearch.v6.interceptor;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.elasticsearch.v6.ElasticsearchPluginConfig;
import org.apache.skywalking.apm.plugin.elasticsearch.v6.interceptor.Constants;
import org.apache.skywalking.apm.util.StringUtil;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateResponse;

public class AdapterActionFutureActionGetMethodsInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (this.isTrace(objInst)) {
            AbstractSpan span = ContextManager.createLocalSpan((String)"Elasticsearch/actionGet");
            span.setComponent((Component)ComponentsDefine.TRANSPORT_CLIENT);
            Tags.DB_TYPE.set(span, "Elasticsearch");
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (this.isTrace(objInst)) {
            AbstractSpan span = ContextManager.activeSpan();
            this.parseResponseInfo((ActionResponse)ret, span);
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (this.isTrace(objInst)) {
            ContextManager.activeSpan().log(t);
        }
    }

    private boolean isTrace(EnhancedInstance objInst) {
        return objInst.getSkyWalkingDynamicField() != null && (Boolean)objInst.getSkyWalkingDynamicField() != false;
    }

    private void parseResponseInfo(ActionResponse response, AbstractSpan span) {
        if (response instanceof SearchResponse) {
            this.parseSearchResponse((SearchResponse)response, span);
            return;
        }
        if (response instanceof BulkResponse) {
            this.parseBulkResponse((BulkResponse)response, span);
            return;
        }
        if (response instanceof GetResponse) {
            this.parseGetResponse((GetResponse)response, span);
            return;
        }
        if (response instanceof IndexResponse) {
            this.parseIndexResponse((IndexResponse)response, span);
            return;
        }
        if (response instanceof UpdateResponse) {
            this.parseUpdateResponse((UpdateResponse)response, span);
            return;
        }
        if (response instanceof DeleteResponse) {
            this.parseDeleteResponse((DeleteResponse)response, span);
            return;
        }
    }

    private void parseSearchResponse(SearchResponse searchResponse, AbstractSpan span) {
        span.tag(Constants.ES_TOOK_MILLIS, Long.toString(searchResponse.getTook().getMillis()));
        span.tag(Constants.ES_TOTAL_HITS, Long.toString(searchResponse.getHits().getTotalHits()));
        if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
            String tagValue = searchResponse.toString();
            tagValue = ElasticsearchPluginConfig.Plugin.Elasticsearch.ELASTICSEARCH_DSL_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)ElasticsearchPluginConfig.Plugin.Elasticsearch.ELASTICSEARCH_DSL_LENGTH_THRESHOLD) : tagValue;
            Tags.DB_STATEMENT.set(span, tagValue);
        }
    }

    private void parseBulkResponse(BulkResponse bulkResponse, AbstractSpan span) {
        span.tag(Constants.ES_TOOK_MILLIS, Long.toString(bulkResponse.getTook().getMillis()));
        span.tag(Constants.ES_INGEST_TOOK_MILLIS, Long.toString(bulkResponse.getIngestTookInMillis()));
        if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
            String tagValue = bulkResponse.toString();
            tagValue = ElasticsearchPluginConfig.Plugin.Elasticsearch.ELASTICSEARCH_DSL_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)ElasticsearchPluginConfig.Plugin.Elasticsearch.ELASTICSEARCH_DSL_LENGTH_THRESHOLD) : tagValue;
            Tags.DB_STATEMENT.set(span, tagValue);
        }
    }

    private void parseGetResponse(GetResponse getResponse, AbstractSpan span) {
        if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
            String tagValue = getResponse.toString();
            tagValue = ElasticsearchPluginConfig.Plugin.Elasticsearch.ELASTICSEARCH_DSL_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)ElasticsearchPluginConfig.Plugin.Elasticsearch.ELASTICSEARCH_DSL_LENGTH_THRESHOLD) : tagValue;
            Tags.DB_STATEMENT.set(span, tagValue);
        }
    }

    private void parseIndexResponse(IndexResponse indexResponse, AbstractSpan span) {
        if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
            String tagValue = indexResponse.toString();
            tagValue = ElasticsearchPluginConfig.Plugin.Elasticsearch.ELASTICSEARCH_DSL_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)ElasticsearchPluginConfig.Plugin.Elasticsearch.ELASTICSEARCH_DSL_LENGTH_THRESHOLD) : tagValue;
            Tags.DB_STATEMENT.set(span, tagValue);
        }
    }

    private void parseUpdateResponse(UpdateResponse updateResponse, AbstractSpan span) {
        if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
            String tagValue = updateResponse.toString();
            tagValue = ElasticsearchPluginConfig.Plugin.Elasticsearch.ELASTICSEARCH_DSL_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)ElasticsearchPluginConfig.Plugin.Elasticsearch.ELASTICSEARCH_DSL_LENGTH_THRESHOLD) : tagValue;
            Tags.DB_STATEMENT.set(span, tagValue);
        }
    }

    private void parseDeleteResponse(DeleteResponse deleteResponse, AbstractSpan span) {
        if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
            String tagValue = deleteResponse.toString();
            tagValue = ElasticsearchPluginConfig.Plugin.Elasticsearch.ELASTICSEARCH_DSL_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)ElasticsearchPluginConfig.Plugin.Elasticsearch.ELASTICSEARCH_DSL_LENGTH_THRESHOLD) : tagValue;
            Tags.DB_STATEMENT.set(span, tagValue);
        }
    }
}

