/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.avro;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Transceiver;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.plugin.avro.AvroInstance;
import org.apache.skywalking.apm.plugin.avro.GenericRequestorInterceptor;
import org.apache.skywalking.apm.plugin.avro.SWClientRPCPlugin;

public abstract class AbstractRequestInterceptor
implements InstanceConstructorInterceptor,
InstanceMethodsAroundInterceptor {
    private static final ILog LOGGER = LogManager.getLogger(GenericRequestorInterceptor.class);

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        if (objInst.getSkyWalkingDynamicField() == null) {
            Requestor requestor = (Requestor)objInst;
            requestor.addRPCPlugin((RPCPlugin)new SWClientRPCPlugin());
            Protocol protocol = (Protocol)allArguments[0];
            Transceiver transceiver = (Transceiver)allArguments[1];
            try {
                objInst.setSkyWalkingDynamicField((Object)new AvroInstance(protocol.getNamespace() + "." + protocol.getName() + ".", transceiver.getRemoteName()));
            }
            catch (IOException e) {
                objInst.setSkyWalkingDynamicField((Object)new AvroInstance("Undefined", "Undefined"));
                LOGGER.error("Failed to get Avro Remote Client Information.", (Throwable)e);
            }
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }
}

