/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.jdk9module;

import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.ByteBuddyCoreClasses;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.agent.builder.AgentBuilder;

public class JDK9ModuleExporter {
    private static final ILog LOGGER = LogManager.getLogger(JDK9ModuleExporter.class);
    private static final String[] HIGH_PRIORITY_CLASSES = new String[]{"org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.OverrideCallable", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.ConstructorInter", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstMethodsInter", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstMethodsInterWithOverrideArgs", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.StaticMethodsInter", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.StaticMethodsInterWithOverrideArgs"};

    public static AgentBuilder openReadEdge(Instrumentation instrumentation, AgentBuilder agentBuilder, EdgeClasses classes) {
        for (String className : classes.classes) {
            try {
                agentBuilder = agentBuilder.assureReadEdgeFromAndTo(instrumentation, Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Fail to open read edge for class " + className + " to public access in JDK9+", e);
            }
        }
        for (String className : HIGH_PRIORITY_CLASSES) {
            try {
                agentBuilder = agentBuilder.assureReadEdgeFromAndTo(instrumentation, Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Fail to open read edge for class " + className + " to public access in JDK9+", e);
            }
        }
        return agentBuilder;
    }

    public static class EdgeClasses {
        private List<String> classes = new ArrayList<String>();

        public EdgeClasses() {
            for (String className : ByteBuddyCoreClasses.CLASSES) {
                this.add(className);
            }
        }

        public void add(String className) {
            if (!this.classes.contains(className)) {
                this.classes.add(className);
            }
        }
    }
}

