/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.status;

import java.util.Arrays;
import lombok.Generated;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.status.StatusChecker;
import org.apache.skywalking.apm.util.StringUtil;

@DefaultImplementor
public class StatusCheckService
implements BootService {
    private String[] ignoredExceptionNames;
    private StatusChecker statusChecker;

    @Override
    public void prepare() throws Throwable {
        this.ignoredExceptionNames = (String[])Arrays.stream(Config.StatusCheck.IGNORED_EXCEPTIONS.split(",")).filter(StringUtil::isNotEmpty).toArray(String[]::new);
        this.statusChecker = Config.StatusCheck.MAX_RECURSIVE_DEPTH > 0 ? StatusChecker.HIERARCHY_MATCH : StatusChecker.OFF;
    }

    @Override
    public void boot() throws Throwable {
    }

    @Override
    public void onComplete() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
    }

    public boolean isError(Throwable e) {
        return this.statusChecker.checkStatus(e);
    }

    @Generated
    public String[] getIgnoredExceptionNames() {
        return this.ignoredExceptionNames;
    }
}

