/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.armeria;

import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.netty.util.AsciiString;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public abstract class AbstractArmeriaClientInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String KEY_SAFE_CLOSEABLE = "SAFE_CLOSEABLE";

    protected abstract URI getUri(EnhancedInstance var1);

    protected abstract HttpMethod getHttpMethod(Object[] var1);

    protected abstract String getPath(Object[] var1);

    protected abstract HttpRequest getHttpRequest(Object[] var1);

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) {
        URI uri = this.getUri(objInst);
        HttpMethod httpMethod = this.getHttpMethod(allArguments);
        String path = this.getPath(allArguments);
        ContextCarrier contextCarrier = new ContextCarrier();
        String remotePeer = uri.getPort() > 0 ? uri.getHost() + ":" + uri.getPort() : uri.getHost();
        AbstractSpan exitSpan = ContextManager.createExitSpan((String)path, (ContextCarrier)contextCarrier, (String)remotePeer);
        exitSpan.setComponent((Component)ComponentsDefine.ARMERIA);
        exitSpan.setLayer(SpanLayer.HTTP);
        Tags.HTTP.METHOD.set(exitSpan, httpMethod.name());
        ContextManager.getRuntimeContext().put((Object)KEY_SAFE_CLOSEABLE, (Object)Clients.withHeaders(builder -> {
            CarrierItem item = contextCarrier.items();
            while (item.hasNext()) {
                item = item.next();
                builder.add((CharSequence)AsciiString.of((CharSequence)item.getHeadKey()), item.getHeadValue());
            }
        }));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        SafeCloseable safeCloseable;
        HttpRequest req = this.getHttpRequest(allArguments);
        if (req != null && ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        if ((safeCloseable = (SafeCloseable)ContextManager.getRuntimeContext().get((Object)KEY_SAFE_CLOSEABLE, SafeCloseable.class)) != null) {
            safeCloseable.close();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }
}

