/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.JacksonUtil;
import com.linecorp.armeria.internal.server.annotation.AnnotatedDocServicePlugin;
import com.linecorp.armeria.internal.server.annotation.AnnotatedValueResolver;
import com.linecorp.armeria.internal.server.annotation.AnnotationUtil;
import com.linecorp.armeria.internal.server.annotation.KotlinUtil;
import com.linecorp.armeria.internal.server.annotation.ReflectiveDescriptiveTypeInfoProvider;
import com.linecorp.armeria.internal.shaded.guava.base.CaseFormat;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.annotation.Description;
import com.linecorp.armeria.server.docs.ContainerTypeSignature;
import com.linecorp.armeria.server.docs.DescriptionInfo;
import com.linecorp.armeria.server.docs.DescriptiveTypeInfo;
import com.linecorp.armeria.server.docs.DescriptiveTypeInfoProvider;
import com.linecorp.armeria.server.docs.DescriptiveTypeSignature;
import com.linecorp.armeria.server.docs.EnumInfo;
import com.linecorp.armeria.server.docs.EnumValueInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.FieldRequirement;
import com.linecorp.armeria.server.docs.StructInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import com.linecorp.armeria.server.docs.TypeSignatureType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public final class DefaultDescriptiveTypeInfoProvider
implements DescriptiveTypeInfoProvider {
    private static final ObjectMapper mapper = JacksonUtil.newDefaultObjectMapper();
    private static final StructInfo HTTP_RESPONSE_INFO = new StructInfo(HttpResponse.class.getName(), ImmutableList.of());
    private final boolean request;

    DefaultDescriptiveTypeInfoProvider(boolean request) {
        this.request = request;
    }

    @Override
    @Nullable
    public DescriptiveTypeInfo newDescriptiveTypeInfo(Object typeDescriptor) {
        Objects.requireNonNull(typeDescriptor, "typeDescriptor");
        if (!(typeDescriptor instanceof Class)) {
            return null;
        }
        Class clazz = (Class)typeDescriptor;
        if (clazz.isEnum()) {
            return DefaultDescriptiveTypeInfoProvider.newEnumInfo(clazz);
        }
        if (HttpResponse.class.isAssignableFrom(clazz)) {
            return HTTP_RESPONSE_INFO;
        }
        if (this.request) {
            return this.requestStructInfo(clazz);
        }
        return this.responseStructInfo(clazz);
    }

    private static EnumInfo newEnumInfo(Class<?> enumClass) {
        String name = enumClass.getName();
        Field[] declaredFields = enumClass.getDeclaredFields();
        List values = Stream.of(declaredFields).filter(Field::isEnumConstant).map(f -> {
            Description valueDescription = AnnotationUtil.findFirst(f, Description.class);
            if (valueDescription != null) {
                return new EnumValueInfo(f.getName(), null, DescriptionInfo.from(valueDescription));
            }
            return new EnumValueInfo(f.getName(), null);
        }).collect(ImmutableList.toImmutableList());
        return new EnumInfo(name, values, DefaultDescriptiveTypeInfoProvider.classDescriptionInfo(enumClass));
    }

    private StructInfo requestStructInfo(Class<?> type) {
        JavaType javaType = mapper.constructType(type);
        if (!mapper.canDeserialize(javaType)) {
            return DefaultDescriptiveTypeInfoProvider.newReflectiveStructInfo(type);
        }
        return new StructInfo(type.getName(), this.requestFieldInfos(javaType), DefaultDescriptiveTypeInfoProvider.classDescriptionInfo(javaType.getRawClass()));
    }

    private List<FieldInfo> requestFieldInfos(JavaType javaType) {
        if (!mapper.canDeserialize(javaType)) {
            return ImmutableList.of();
        }
        BeanDescription description = mapper.getDeserializationConfig().introspect(javaType);
        List properties = description.findProperties();
        if (properties.isEmpty()) {
            return DefaultDescriptiveTypeInfoProvider.newReflectiveStructInfo(javaType.getRawClass()).fields();
        }
        return properties.stream().map(property -> this.fieldInfos(javaType, property.getName(), property.getInternalName(), property.getPrimaryType())).collect(ImmutableList.toImmutableList());
    }

    private StructInfo responseStructInfo(Class<?> type) {
        if (!mapper.canSerialize(type)) {
            return DefaultDescriptiveTypeInfoProvider.newReflectiveStructInfo(type);
        }
        JavaType javaType = mapper.constructType(type);
        return new StructInfo(type.getName(), this.responseFieldInfos(javaType), DefaultDescriptiveTypeInfoProvider.classDescriptionInfo(type));
    }

    private List<FieldInfo> responseFieldInfos(JavaType javaType) {
        if (!mapper.canSerialize(javaType.getRawClass())) {
            return ImmutableList.of();
        }
        BeanDescription description = mapper.getSerializationConfig().introspect(javaType);
        List properties = description.findProperties();
        if (properties.isEmpty()) {
            return DefaultDescriptiveTypeInfoProvider.newReflectiveStructInfo(javaType.getRawClass()).fields();
        }
        return properties.stream().map(property -> this.fieldInfos(javaType, property.getName(), property.getInternalName(), property.getPrimaryType())).collect(ImmutableList.toImmutableList());
    }

    private FieldInfo fieldInfos(JavaType javaType, String name, String internalName, JavaType fieldType) {
        FieldRequirement fieldRequirement;
        TypeSignature typeSignature = AnnotatedDocServicePlugin.toTypeSignature(fieldType);
        if (typeSignature.type() == TypeSignatureType.OPTIONAL) {
            Object descriptor;
            if ((typeSignature = ((ContainerTypeSignature)typeSignature).typeParameters().get(0)).type().hasTypeDescriptor() && (descriptor = ((DescriptiveTypeSignature)typeSignature).descriptor()) instanceof Class) {
                fieldType = mapper.constructType((Type)((Class)descriptor));
            }
            fieldRequirement = FieldRequirement.OPTIONAL;
        } else {
            fieldRequirement = this.fieldRequirement(javaType, fieldType, internalName);
        }
        DescriptionInfo descriptionInfo = this.fieldDescriptionInfo(javaType, fieldType, internalName);
        return FieldInfo.builder(name, typeSignature).requirement(fieldRequirement).descriptionInfo(descriptionInfo).build();
    }

    private FieldRequirement fieldRequirement(JavaType classType, JavaType fieldType, String fieldName) {
        FieldRequirement requirement;
        if (fieldType.isPrimitive()) {
            return FieldRequirement.REQUIRED;
        }
        if (KotlinUtil.isData(classType.getRawClass()) && (requirement = DefaultDescriptiveTypeInfoProvider.extractFromConstructor(classType, fieldType, fieldName, parameter -> {
            if (DefaultDescriptiveTypeInfoProvider.isNullable(parameter)) {
                return FieldRequirement.OPTIONAL;
            }
            return FieldRequirement.REQUIRED;
        })) != null) {
            return requirement;
        }
        requirement = this.extractFieldMeta(classType, fieldType, fieldName, element -> {
            if (this.request && element instanceof Method) {
                element = ((Method)element).getParameters()[0];
            }
            if (DefaultDescriptiveTypeInfoProvider.isNullable(element)) {
                return FieldRequirement.OPTIONAL;
            }
            return FieldRequirement.REQUIRED;
        });
        return MoreObjects.firstNonNull(requirement, FieldRequirement.UNSPECIFIED);
    }

    static boolean isNullable(AnnotatedElement element) {
        return AnnotatedValueResolver.isAnnotatedNullable(element) || KotlinUtil.isMarkedNullable(element);
    }

    private static DescriptionInfo classDescriptionInfo(Class<?> clazz) {
        Description description = AnnotationUtil.findFirst(clazz, Description.class);
        if (description != null) {
            return DescriptionInfo.from(description);
        }
        return DescriptionInfo.empty();
    }

    private DescriptionInfo fieldDescriptionInfo(JavaType classType, JavaType fieldType, String fieldName) {
        Description description = this.extractFieldMeta(classType, fieldType, fieldName, element -> AnnotationUtil.findFirst(element, Description.class));
        if (description != null) {
            return DescriptionInfo.from(description);
        }
        return DescriptionInfo.empty();
    }

    @Nullable
    private <T> T extractFieldMeta(JavaType classType, JavaType fieldType, String fieldName, Function<AnnotatedElement, @Nullable T> extractor) {
        if (this.request) {
            return DefaultDescriptiveTypeInfoProvider.extractRequestFieldMeta(classType, fieldType, fieldName, extractor);
        }
        return DefaultDescriptiveTypeInfoProvider.extractResponseFieldMeta(classType, fieldType, fieldName, extractor);
    }

    @Nullable
    private static <T> T extractRequestFieldMeta(JavaType classType, JavaType fieldType, String fieldName, Function<AnnotatedElement, @Nullable T> extractor) {
        String setter = "set" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
        T result = DefaultDescriptiveTypeInfoProvider.extractFromSetter(classType, fieldType, setter, extractor);
        if (result == null) {
            result = DefaultDescriptiveTypeInfoProvider.extractFromSetter(classType, fieldType, fieldName, extractor);
        }
        if (result == null) {
            result = DefaultDescriptiveTypeInfoProvider.extractFromConstructor(classType, fieldType, fieldName, extractor);
        }
        if (result == null) {
            result = DefaultDescriptiveTypeInfoProvider.extractFromField(classType, fieldType, fieldName, extractor);
        }
        return result;
    }

    @Nullable
    private static <T> T extractResponseFieldMeta(JavaType classType, JavaType fieldType, String fieldName, Function<AnnotatedElement, @Nullable T> extractor) {
        String getter = "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
        T result = DefaultDescriptiveTypeInfoProvider.extractFromGetter(classType, fieldType, getter, extractor);
        if (result == null) {
            result = DefaultDescriptiveTypeInfoProvider.extractFromGetter(classType, fieldType, fieldName, extractor);
        }
        if (result == null) {
            result = DefaultDescriptiveTypeInfoProvider.extractFromField(classType, fieldType, fieldName, extractor);
        }
        if (result == null) {
            result = DefaultDescriptiveTypeInfoProvider.extractFromConstructor(classType, fieldType, fieldName, extractor);
        }
        return result;
    }

    @Nullable
    private static <T> T extractFromField(JavaType classType, JavaType fieldType, String fieldName, Function<AnnotatedElement, @Nullable T> extractor) {
        try {
            Field field = classType.getRawClass().getDeclaredField(fieldName);
            if (field.getType() == fieldType.getRawClass()) {
                return extractor.apply(field);
            }
        }
        catch (NoSuchFieldException ignored) {
            for (Field field : classType.getRawClass().getDeclaredFields()) {
                JsonProperty renameAnnotation = AnnotationUtil.findFirst(field, JsonProperty.class);
                if (renameAnnotation == null || !renameAnnotation.value().equals(fieldName) || field.getType() != fieldType.getRawClass()) continue;
                return extractor.apply(field);
            }
        }
        return null;
    }

    @Nullable
    private static <T> T extractFromConstructor(JavaType classType, JavaType fieldType, String fieldName, Function<AnnotatedElement, @Nullable T> extractor) {
        Parameter[] parameters;
        Constructor<?>[] ctors = classType.getRawClass().getDeclaredConstructors();
        if (ctors.length == 0) {
            return null;
        }
        Constructor<?> constructor = null;
        for (Constructor<?> ctor : ctors) {
            Parameter[] parameters2 = ctor.getParameters();
            int length = parameters2.length;
            if (length == 0 || "kotlin.jvm.internal.DefaultConstructorMarker".equals(parameters2[length - 1].getType().getName()) || constructor != null && constructor.getParameters().length >= length) continue;
            constructor = ctor;
        }
        if (constructor == null) {
            return null;
        }
        for (Parameter parameter : parameters = constructor.getParameters()) {
            if (parameter.isNamePresent() && parameter.getName().equals(fieldName) && parameter.getType() == fieldType.getRawClass()) {
                return extractor.apply(parameter);
            }
            JsonProperty renameAnnotation = AnnotationUtil.findFirst(parameter, JsonProperty.class);
            if (renameAnnotation == null || !renameAnnotation.value().equals(fieldName) || parameter.getType() != fieldType.getRawClass()) continue;
            return extractor.apply(parameter);
        }
        return null;
    }

    @Nullable
    private static <T> T extractFromSetter(JavaType classType, JavaType fieldType, String methodName, Function<AnnotatedElement, @Nullable T> extractor) {
        try {
            Method method = classType.getRawClass().getDeclaredMethod(methodName, fieldType.getRawClass());
            return extractor.apply(method);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }

    @Nullable
    private static <T> T extractFromGetter(JavaType classType, JavaType fieldType, String methodName, Function<AnnotatedElement, @Nullable T> extractor) {
        try {
            Method method = classType.getRawClass().getDeclaredMethod(methodName, new Class[0]);
            if (method.getReturnType() == fieldType.getRawClass()) {
                return extractor.apply(method);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static StructInfo newReflectiveStructInfo(Class<?> clazz) {
        return (StructInfo)ReflectiveDescriptiveTypeInfoProvider.INSTANCE.newDescriptiveTypeInfo(clazz);
    }
}

