/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.jfr.type;

import java.util.HashMap;
import lombok.Generated;

public class Frame
extends HashMap<Integer, Frame> {
    public static final byte TYPE_INTERPRETED = 0;
    public static final byte TYPE_JIT_COMPILED = 1;
    public static final byte TYPE_INLINED = 2;
    public static final byte TYPE_NATIVE = 3;
    public static final byte TYPE_CPP = 4;
    public static final byte TYPE_KERNEL = 5;
    public static final byte TYPE_C1_COMPILED = 6;
    private static final int TYPE_SHIFT = 28;
    final int key;
    long total;
    long self;
    long inlined;
    long c1;
    long interpreted;

    private Frame(int key) {
        this.key = key;
    }

    public Frame(int titleIndex, byte type) {
        this(titleIndex | type << 28);
    }

    public Frame getChild(int titleIndex, byte type) {
        return super.computeIfAbsent(titleIndex | type << 28, Frame::new);
    }

    public int getTitleIndex() {
        return this.key & 0xFFFFFFF;
    }

    public byte getType() {
        if (this.inlined * 3L >= this.total) {
            return 2;
        }
        if (this.c1 * 2L >= this.total) {
            return 6;
        }
        if (this.interpreted * 2L >= this.total) {
            return 0;
        }
        return (byte)(this.key >>> 28);
    }

    public int depth(long cutoff) {
        int depth = 0;
        if (this.size() > 0) {
            for (Frame child : this.values()) {
                if (child.total < cutoff) continue;
                depth = Math.max(depth, child.depth(cutoff));
            }
        }
        return depth + 1;
    }

    @Generated
    public int getKey() {
        return this.key;
    }

    @Generated
    public long getTotal() {
        return this.total;
    }

    @Generated
    public long getSelf() {
        return this.self;
    }

    @Generated
    public long getInlined() {
        return this.inlined;
    }

    @Generated
    public long getC1() {
        return this.c1;
    }

    @Generated
    public long getInterpreted() {
        return this.interpreted;
    }

    @Generated
    public void setTotal(long total) {
        this.total = total;
    }

    @Generated
    public void setSelf(long self) {
        this.self = self;
    }

    @Generated
    public void setInlined(long inlined) {
        this.inlined = inlined;
    }

    @Generated
    public void setC1(long c1) {
        this.c1 = c1;
    }

    @Generated
    public void setInterpreted(long interpreted) {
        this.interpreted = interpreted;
    }
}

