/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf.storage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingTargetType;

public enum EBPFProfilingTargetType {
    UNKNOWN(0, null),
    ON_CPU(1, ContinuousProfilingTargetType.ON_CPU),
    OFF_CPU(2, ContinuousProfilingTargetType.OFF_CPU),
    NETWORK(3, ContinuousProfilingTargetType.NETWORK);

    private final int value;
    private final ContinuousProfilingTargetType continuousProfilingTargetType;
    private static final Map<Integer, EBPFProfilingTargetType> DICTIONARY;
    private static final Map<ContinuousProfilingTargetType, EBPFProfilingTargetType> CONTINUOUS_PROFILING_TARGET_DICTIONARY;

    private EBPFProfilingTargetType(int value, ContinuousProfilingTargetType continuousProfilingTargetType) {
        this.value = value;
        this.continuousProfilingTargetType = continuousProfilingTargetType;
    }

    public int value() {
        return this.value;
    }

    public ContinuousProfilingTargetType getContinuousProfilingTargetType() {
        return this.continuousProfilingTargetType;
    }

    public static EBPFProfilingTargetType valueOf(int value) {
        EBPFProfilingTargetType type = DICTIONARY.get(value);
        if (type == null) {
            throw new UnexpectedException("Unknown EBPFProfilingTargetType value");
        }
        return type;
    }

    public static EBPFProfilingTargetType valueOf(ContinuousProfilingTargetType value) {
        EBPFProfilingTargetType type = CONTINUOUS_PROFILING_TARGET_DICTIONARY.get((Object)value);
        if (type == null) {
            throw new UnexpectedException("Unknown ContinuousProfilingTargetType value: " + String.valueOf((Object)value));
        }
        return type;
    }

    static {
        DICTIONARY = new HashMap<Integer, EBPFProfilingTargetType>();
        CONTINUOUS_PROFILING_TARGET_DICTIONARY = new HashMap<ContinuousProfilingTargetType, EBPFProfilingTargetType>();
        Arrays.stream(EBPFProfilingTargetType.values()).collect(Collectors.toMap(EBPFProfilingTargetType::value, type -> type)).forEach(DICTIONARY::put);
        Arrays.stream(EBPFProfilingTargetType.values()).filter(s -> Objects.nonNull((Object)s.getContinuousProfilingTargetType())).collect(Collectors.toMap(EBPFProfilingTargetType::getContinuousProfilingTargetType, type -> type)).forEach(CONTINUOUS_PROFILING_TARGET_DICTIONARY::put);
    }
}

