/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.record;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@ScopeDeclaration(id=43, name="Event")
@Stream(name="event", scopeId=43, builder=Builder.class, processor=RecordStreamProcessor.class)
@BanyanDB.TimestampColumn(value="timestamp")
@BanyanDB.Group(streamGroup=BanyanDB.StreamGroup.RECORDS)
public class Event
extends Record {
    public static final String INDEX_NAME = "event";
    public static final String UUID = "uuid";
    public static final String SERVICE = "service";
    public static final String SERVICE_INSTANCE = "service_instance";
    public static final String ENDPOINT = "endpoint";
    public static final String NAME = "event_name";
    public static final String TYPE = "type";
    public static final String MESSAGE = "message";
    public static final String PARAMETERS = "parameters";
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";
    public static final String LAYER = "layer";
    private static final int PARAMETER_MAX_LENGTH = 4000;
    public static final String TIMESTAMP = "timestamp";
    @Column(name="uuid")
    @BanyanDB.SeriesID(index=0)
    private String uuid;
    @Column(name="service")
    private String service;
    @Column(name="service_instance")
    private String serviceInstance;
    @Column(name="endpoint")
    private String endpoint;
    @Column(name="event_name")
    private String name;
    @Column(name="type")
    private String type;
    @Column(name="message", storageOnly=true, length=2000)
    private String message;
    @Column(name="parameters", storageOnly=true, length=4000)
    private String parameters;
    @ElasticSearch.EnableDocValues
    @Column(name="start_time")
    private long startTime;
    @Column(name="end_time")
    private long endTime;
    @Column(name="layer")
    private Layer layer;
    @ElasticSearch.EnableDocValues
    @Column(name="timestamp")
    private long timestamp;

    @Override
    public StorageID id() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append(UUID, this.uuid);
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getService() {
        return this.service;
    }

    @Generated
    public String getServiceInstance() {
        return this.serviceInstance;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getParameters() {
        return this.parameters;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public Layer getLayer() {
        return this.layer;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setService(String service) {
        this.service = service;
    }

    @Generated
    public void setServiceInstance(String serviceInstance) {
        this.serviceInstance = serviceInstance;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    public static class Builder
    implements StorageBuilder<Event> {
        @Override
        public Event storage2Entity(Convert2Entity converter) {
            Event record = new Event();
            record.setUuid((String)converter.get(Event.UUID));
            record.setService((String)converter.get(Event.SERVICE));
            record.setServiceInstance((String)converter.get(Event.SERVICE_INSTANCE));
            record.setEndpoint((String)converter.get(Event.ENDPOINT));
            record.setName((String)converter.get(Event.NAME));
            record.setType((String)converter.get(Event.TYPE));
            record.setMessage((String)converter.get(Event.MESSAGE));
            record.setParameters((String)converter.get(Event.PARAMETERS));
            record.setStartTime(((Number)converter.get(Event.START_TIME)).longValue());
            record.setEndTime(((Number)converter.get(Event.END_TIME)).longValue());
            record.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            record.setTimestamp(((Number)converter.get(Event.TIMESTAMP)).longValue());
            if (converter.get(Event.LAYER) != null) {
                record.setLayer(Layer.valueOf(((Number)converter.get(Event.LAYER)).intValue()));
            }
            return record;
        }

        @Override
        public void entity2Storage(Event storageData, Convert2Storage converter) {
            converter.accept(Event.UUID, storageData.getUuid());
            converter.accept(Event.SERVICE, storageData.getService());
            converter.accept(Event.SERVICE_INSTANCE, storageData.getServiceInstance());
            converter.accept(Event.ENDPOINT, storageData.getEndpoint());
            converter.accept(Event.NAME, storageData.getName());
            converter.accept(Event.TYPE, storageData.getType());
            converter.accept(Event.MESSAGE, storageData.getMessage());
            converter.accept(Event.PARAMETERS, storageData.getParameters());
            converter.accept(Event.START_TIME, storageData.getStartTime());
            converter.accept(Event.END_TIME, storageData.getEndTime());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept(Event.TIMESTAMP, storageData.getTimestamp());
            Layer layer = storageData.getLayer();
            converter.accept(Event.LAYER, layer != null ? layer.value() : Layer.UNDEFINED.value());
        }
    }
}

