/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientPreprocessorsBuilder;
import com.linecorp.armeria.client.HttpPreClient;
import com.linecorp.armeria.client.HttpPreprocessor;
import com.linecorp.armeria.client.RpcPreClient;
import com.linecorp.armeria.client.RpcPreprocessor;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

@UnstableApi
public final class ClientPreprocessors {
    private static final ClientPreprocessors NONE = new ClientPreprocessors(ImmutableList.of(), ImmutableList.of());
    private final List<HttpPreprocessor> preprocessors;
    private final List<RpcPreprocessor> rpcPreprocessors;

    public static ClientPreprocessors of() {
        return NONE;
    }

    public static ClientPreprocessors of(HttpPreprocessor preprocessor) {
        return ClientPreprocessors.builder().add(preprocessor).build();
    }

    public static ClientPreprocessors ofRpc(RpcPreprocessor preprocessor) {
        return ClientPreprocessors.builder().addRpc(preprocessor).build();
    }

    public static ClientPreprocessorsBuilder builder() {
        return new ClientPreprocessorsBuilder();
    }

    ClientPreprocessors(List<HttpPreprocessor> preprocessors, List<RpcPreprocessor> rpcPreprocessors) {
        this.preprocessors = ImmutableList.copyOf(preprocessors);
        this.rpcPreprocessors = ImmutableList.copyOf(rpcPreprocessors);
    }

    public List<HttpPreprocessor> preprocessors() {
        return this.preprocessors;
    }

    public List<RpcPreprocessor> rpcPreprocessors() {
        return this.rpcPreprocessors;
    }

    public HttpPreClient decorate(HttpPreClient execution) {
        for (HttpPreprocessor preprocessor : this.preprocessors) {
            HttpPreClient execution0 = execution;
            execution = (ctx, req) -> preprocessor.execute(execution0, ctx, req);
        }
        return execution;
    }

    public RpcPreClient rpcDecorate(RpcPreClient execution) {
        for (RpcPreprocessor rpcPreprocessor : this.rpcPreprocessors) {
            RpcPreClient execution0 = execution;
            execution = (ctx, req) -> rpcPreprocessor.execute(execution0, ctx, req);
        }
        return execution;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClientPreprocessors that = (ClientPreprocessors)object;
        return Objects.equals(this.preprocessors, that.preprocessors) && Objects.equals(this.rpcPreprocessors, that.rpcPreprocessors);
    }

    public int hashCode() {
        return Objects.hash(this.preprocessors, this.rpcPreprocessors);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("preprocessors", this.preprocessors).add("rpcPreprocessors", this.rpcPreprocessors).toString();
    }
}

