/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.datacarrier.DataCarrier;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.BatchSQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCBatchDAO
implements IBatchDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCBatchDAO.class);
    private final JDBCClient jdbcClient;
    private final DataCarrier<PrepareRequest> dataCarrier;
    private final int maxBatchSqlSize;

    public JDBCBatchDAO(JDBCClient jdbcClient, int maxBatchSqlSize, int asyncBatchPersistentPoolSize) {
        this.jdbcClient = jdbcClient;
        String name = "H2_ASYNCHRONOUS_BATCH_PERSISTENT";
        if (log.isDebugEnabled()) {
            log.debug("H2_ASYNCHRONOUS_BATCH_PERSISTENT poolSize: {}, maxBatchSqlSize:{}", (Object)asyncBatchPersistentPoolSize, (Object)maxBatchSqlSize);
        }
        this.maxBatchSqlSize = maxBatchSqlSize;
        this.dataCarrier = new DataCarrier(name, asyncBatchPersistentPoolSize, 10000);
        this.dataCarrier.consume((IConsumer)new H2BatchConsumer(this), asyncBatchPersistentPoolSize, 20L);
    }

    public CompletableFuture<Void> flush(List<PrepareRequest> prepareRequests) {
        if (CollectionUtils.isEmpty(prepareRequests)) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList sqls = new ArrayList();
        prepareRequests.forEach(prepareRequest -> {
            sqls.add(prepareRequest);
            SQLExecutor sqlExecutor = (SQLExecutor)prepareRequest;
            if (!CollectionUtils.isEmpty(sqlExecutor.getAdditionalSQLs())) {
                sqls.addAll(sqlExecutor.getAdditionalSQLs());
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("to execute sql statements execute, data size: {}, maxBatchSqlSize: {}", (Object)sqls.size(), (Object)this.maxBatchSqlSize);
        }
        Map batchRequestsOfSql = sqls.stream().collect(Collectors.groupingBy(Function.identity()));
        batchRequestsOfSql.forEach((sql, requests) -> {
            try {
                BatchSQLExecutor batchSQLExecutor = new BatchSQLExecutor(this.jdbcClient, (List<PrepareRequest>)requests);
                batchSQLExecutor.invoke(this.maxBatchSqlSize);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("execute sql statements done, data size: {}, maxBatchSqlSize: {}", (Object)prepareRequests.size(), (Object)this.maxBatchSqlSize);
        }
        return CompletableFuture.completedFuture(null);
    }

    public void insert(InsertRequest insertRequest) {
        this.dataCarrier.produce((Object)insertRequest);
    }

    private static class H2BatchConsumer
    implements IConsumer<PrepareRequest> {
        private final JDBCBatchDAO h2BatchDAO;

        private H2BatchConsumer(JDBCBatchDAO h2BatchDAO) {
            this.h2BatchDAO = h2BatchDAO;
        }

        public void consume(List<PrepareRequest> prepareRequests) {
            this.h2BatchDAO.flush(prepareRequests);
        }

        public void onError(List<PrepareRequest> prepareRequests, Throwable t) {
            log.error(t.getMessage(), t);
        }
    }
}

