/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.DerivedScalar;
import org.apache.sis.measure.Scalar;
import org.apache.sis.measure.ScalarFactory;
import org.apache.sis.measure.ScalarFallback;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;

public final class Quantities {
    private Quantities() {
    }

    public static Quantity<?> create(double value, String unit) {
        return Quantities.create(value, Units.valueOf(unit));
    }

    public static <Q extends Quantity<Q>> Q create(double value, Unit<Q> unit) {
        Unit system = unit.getSystemUnit();
        if (system instanceof SystemUnit) {
            Object quantity;
            UnitConverter c = unit.getConverterTo(system);
            ScalarFactory<Q> factory = ((SystemUnit)system).factory;
            if (c.isLinear()) {
                if (factory != null) {
                    return factory.create(value, unit);
                }
                Class type = ((SystemUnit)system).quantity;
                if (type != null) {
                    return ScalarFallback.factory(value, unit, type);
                }
                Scalar<Q> quantity2 = new Scalar<Q>(value, unit);
                return (Q)quantity2;
            }
            if (factory != null && (quantity = factory.createDerived(value, unit, system, c)) != null) {
                return quantity;
            }
            Class type = ((SystemUnit)system).quantity;
            if (type != null) {
                return DerivedScalar.Fallback.factory(value, unit, system, c, type);
            }
            DerivedScalar<Q> quantity3 = new DerivedScalar<Q>(value, unit, system, c);
            return (Q)quantity3;
        }
        throw new IllegalArgumentException(Errors.format((short)197, unit.getClass()));
    }

    public static <Q extends Quantity<Q>> Q castOrCopy(Quantity<Q> quantity) {
        if (quantity != null) {
            Unit unit = quantity.getUnit();
            Unit system = unit.getSystemUnit();
            if (!(system instanceof SystemUnit)) {
                throw new IllegalArgumentException(Errors.format((short)197, unit.getClass()));
            }
            Class type = ((SystemUnit)system).quantity;
            if (!type.isInstance(quantity)) {
                ScalarFactory factory = ((SystemUnit)system).factory;
                double value = AbstractConverter.doubleValue(quantity.getValue());
                if (factory != null) {
                    return factory.create(value, unit);
                }
                return ScalarFallback.factory(value, unit, type);
            }
        }
        return (Q)quantity;
    }

    public static <Q extends Quantity<Q>> Quantity<Q> min(Quantity<Q> q1, Quantity<Q> q2) {
        return Quantities.minOrMax(q1, q2, false);
    }

    public static <Q extends Quantity<Q>> Quantity<Q> max(Quantity<Q> q1, Quantity<Q> q2) {
        return Quantities.minOrMax(q1, q2, true);
    }

    private static <Q extends Quantity<Q>> Quantity<Q> minOrMax(Quantity<Q> q1, Quantity<Q> q2, boolean max) {
        Unit s2;
        if (q1 == null) {
            return q2;
        }
        if (q2 == null) {
            return q1;
        }
        Unit u1 = q1.getUnit();
        Unit u2 = q2.getUnit();
        Unit s1 = u1.getSystemUnit();
        if (!Objects.equals(s1, s2 = u2.getSystemUnit())) {
            throw new UnconvertibleException((String)null);
        }
        Number v1 = u1.getConverterTo(s1).convert(q1.getValue());
        Number v2 = u2.getConverterTo(s2).convert(q2.getValue());
        if (Numbers.isNaN(v2)) {
            return q1;
        }
        if (Numbers.isNaN(v1)) {
            return q2;
        }
        int c = Quantities.compare(v1, v2);
        return (max ? c >= 0 : c <= 0) ? q1 : q2;
    }

    private static int compare(Number v1, Number v2) {
        if (v1 instanceof Comparable) {
            if (v1.getClass().isInstance(v2)) {
                return ((Comparable)((Object)v1)).compareTo(v2);
            }
            if (v2 instanceof Comparable && v2.getClass().isInstance(v1)) {
                return -((Comparable)((Object)v2)).compareTo(v1);
            }
        }
        return Double.compare(v1.doubleValue(), v2.doubleValue());
    }
}

