/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.service;

import io.grpc.health.v1.DubboHealthTriple;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.TriRpcStatus;

public class TriHealthImpl
extends DubboHealthTriple.HealthImplBase {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(TriHealthImpl.class);
    private final Map<String, HealthCheckResponse.ServingStatus> statusMap = new ConcurrentHashMap<String, HealthCheckResponse.ServingStatus>();
    private final Object watchLock = new Object();
    private final HashMap<String, IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean>> watchers = new HashMap();
    private boolean terminal;

    public TriHealthImpl() {
        this.statusMap.put("", HealthCheckResponse.ServingStatus.SERVING);
    }

    private static HealthCheckResponse getResponseForWatch(HealthCheckResponse.ServingStatus recordedStatus) {
        return HealthCheckResponse.newBuilder().setStatus(recordedStatus == null ? HealthCheckResponse.ServingStatus.SERVICE_UNKNOWN : recordedStatus).build();
    }

    @Override
    public HealthCheckResponse check(HealthCheckRequest request) {
        HealthCheckResponse.ServingStatus status = this.statusMap.get(request.getService());
        if (status != null) {
            return HealthCheckResponse.newBuilder().setStatus(status).build();
        }
        throw TriRpcStatus.NOT_FOUND.withDescription("unknown service " + request.getService()).asException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watch(HealthCheckRequest request, StreamObserver<HealthCheckResponse> responseObserver) {
        String service = request.getService();
        Object object = this.watchLock;
        synchronized (object) {
            HealthCheckResponse.ServingStatus status = this.statusMap.get(service);
            responseObserver.onNext(TriHealthImpl.getResponseForWatch(status));
            IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean> serviceWatchers = this.watchers.get(service);
            if (serviceWatchers == null) {
                serviceWatchers = new IdentityHashMap();
                this.watchers.put(service, serviceWatchers);
            }
            serviceWatchers.put(responseObserver, Boolean.TRUE);
        }
        RpcContext.getCancellationContext().addListener(context -> {
            Object object = this.watchLock;
            synchronized (object) {
                IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean> serviceWatchers = this.watchers.get(service);
                if (serviceWatchers != null) {
                    serviceWatchers.remove(responseObserver);
                    if (serviceWatchers.isEmpty()) {
                        this.watchers.remove(service);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatus(String service, HealthCheckResponse.ServingStatus status) {
        Object object = this.watchLock;
        synchronized (object) {
            if (this.terminal) {
                logger.info("Ignoring status " + (Object)((Object)status) + " for " + service);
                return;
            }
            this.setStatusInternal(service, status);
        }
    }

    private void setStatusInternal(String service, HealthCheckResponse.ServingStatus status) {
        HealthCheckResponse.ServingStatus prevStatus = this.statusMap.put(service, status);
        if (prevStatus != status) {
            this.notifyWatchers(service, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearStatus(String service) {
        Object object = this.watchLock;
        synchronized (object) {
            if (this.terminal) {
                logger.info("Ignoring status clearing for " + service);
                return;
            }
            HealthCheckResponse.ServingStatus prevStatus = this.statusMap.remove(service);
            if (prevStatus != null) {
                this.notifyWatchers(service, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterTerminalState() {
        Object object = this.watchLock;
        synchronized (object) {
            if (this.terminal) {
                logger.warn("4-16", "", "", "Already terminating", new RuntimeException());
                return;
            }
            this.terminal = true;
            for (String service : this.statusMap.keySet()) {
                this.setStatusInternal(service, HealthCheckResponse.ServingStatus.NOT_SERVING);
            }
        }
    }

    private void notifyWatchers(String service, HealthCheckResponse.ServingStatus status) {
        HealthCheckResponse response = TriHealthImpl.getResponseForWatch(status);
        IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean> serviceWatchers = this.watchers.get(service);
        if (serviceWatchers != null) {
            for (StreamObserver<HealthCheckResponse> responseObserver : serviceWatchers.keySet()) {
                responseObserver.onNext(response);
            }
        }
    }
}

