/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.ratelimiter.common.slide;

import java.util.concurrent.atomic.AtomicLong;

public class Window {
    private final AtomicLong windowStartMs;
    private final AtomicLong passedValue;
    private final AtomicLong limitedValue;

    public Window(long windStartMs, long passed, long limited) {
        this.windowStartMs = new AtomicLong(windStartMs);
        this.passedValue = new AtomicLong(passed);
        this.limitedValue = new AtomicLong(limited);
    }

    public Window() {
        this(0L, 0L, 0L);
    }

    public Window reset(long oldWindowStartMs, long curWindowStartMs) {
        if (this.windowStartMs.compareAndSet(oldWindowStartMs, curWindowStartMs)) {
            long passed = this.swapPassed();
            long limited = this.swapLimited();
            return new Window(oldWindowStartMs, passed, limited);
        }
        return null;
    }

    public long getCurrentWindowStartMs() {
        return this.windowStartMs.get();
    }

    public long addAndGetPassed(long value) {
        return this.passedValue.addAndGet(value);
    }

    public long addAndGetLimited(long value) {
        return this.limitedValue.addAndGet(value);
    }

    public long swapPassed() {
        return this.passedValue.getAndSet(0L);
    }

    public long swapLimited() {
        return this.limitedValue.getAndSet(0L);
    }

    public long getPassedValue() {
        return this.passedValue.get();
    }
}

