/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ReflectUtil {
    public static final String PARAM_CLASS_SPLIT = ",";
    public static final String EMPTY_PARAM = "void";
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final ConcurrentMap<String, Class<?>> name2ClassCache = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, String> class2NameCache = new ConcurrentHashMap();
    private static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    private static final Class<?>[] PRIMITIVE_CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    private static final int PRIMITIVE_CLASS_NAME_MAX_LENGTH = 7;

    public static String getMethodParamDesc(Method method) {
        Class<?>[] clzs;
        if (method.getParameterTypes() == null || method.getParameterTypes().length == 0) {
            return EMPTY_PARAM;
        }
        StringBuilder builder = new StringBuilder();
        for (Class<?> clz : clzs = method.getParameterTypes()) {
            String className = ReflectUtil.getName(clz);
            builder.append(className).append(PARAM_CLASS_SPLIT);
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static String getMethodDesc(Method method) {
        String methodParamDesc = ReflectUtil.getMethodParamDesc(method);
        return ReflectUtil.getMethodDesc(method.getName(), methodParamDesc);
    }

    public static String getMethodDesc(String methodName, String paramDesc) {
        if (paramDesc == null) {
            return methodName + "()";
        }
        return methodName + "(" + paramDesc + ")";
    }

    public static Class<?>[] forNames(String classList) throws ClassNotFoundException {
        if (classList == null || "".equals(classList) || EMPTY_PARAM.equals(classList)) {
            return EMPTY_CLASS_ARRAY;
        }
        String[] classNames = classList.split(PARAM_CLASS_SPLIT);
        Class[] classTypes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            String className = classNames[i];
            classTypes[i] = ReflectUtil.forName(className);
        }
        return classTypes;
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        if (null == className || "".equals(className)) {
            return null;
        }
        Class<?> clz = (Class<?>)name2ClassCache.get(className);
        if (clz != null) {
            return clz;
        }
        clz = ReflectUtil.forNameWithoutCache(className);
        name2ClassCache.putIfAbsent(className, clz);
        return clz;
    }

    private static Class<?> forNameWithoutCache(String className) throws ClassNotFoundException {
        if (!className.endsWith("[]")) {
            Class<?> clz = ReflectUtil.getPrimitiveClass(className);
            clz = clz != null ? clz : Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            return clz;
        }
        int dimensionSiz = 0;
        while (className.endsWith("[]")) {
            ++dimensionSiz;
            className = className.substring(0, className.length() - 2);
        }
        int[] dimensions = new int[dimensionSiz];
        Class<?> clz = ReflectUtil.getPrimitiveClass(className);
        if (clz == null) {
            clz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        return Array.newInstance(clz, dimensions).getClass();
    }

    public static String getName(Class<?> clz) {
        if (clz == null) {
            return null;
        }
        String className = (String)class2NameCache.get(clz);
        if (className != null) {
            return className;
        }
        className = ReflectUtil.getNameWithoutCache(clz);
        class2NameCache.putIfAbsent(clz, className);
        return className;
    }

    private static String getNameWithoutCache(Class<?> clz) {
        if (!clz.isArray()) {
            return clz.getName();
        }
        StringBuilder sb = new StringBuilder();
        while (clz.isArray()) {
            sb.append("[]");
            clz = clz.getComponentType();
        }
        return clz.getName() + sb.toString();
    }

    public static Class<?> getPrimitiveClass(String name) {
        int index;
        if (name.length() <= 7 && (index = Arrays.binarySearch(PRIMITIVE_NAMES, name)) >= 0) {
            return PRIMITIVE_CLASSES[index];
        }
        return null;
    }

    public static List<Method> getPublicMethod(Class<?> clz) {
        Method[] methods = clz.getMethods();
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method method : methods) {
            boolean isNotObjectClass;
            boolean isPublic = Modifier.isPublic(method.getModifiers());
            boolean bl = isNotObjectClass = method.getDeclaringClass() != Object.class;
            if (!isPublic || !isNotObjectClass) continue;
            ret.add(method);
        }
        return ret;
    }

    public static Object getEmptyObject(Class<?> returnType) {
        return ReflectUtil.getEmptyObject(returnType, new HashMap(), 0);
    }

    private static Object getEmptyObject(Class<?> returnType, Map<Class<?>, Object> emptyInstances, int level) {
        if (level > 2) {
            return null;
        }
        if (returnType == null) {
            return null;
        }
        if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            return false;
        }
        if (returnType == Character.TYPE || returnType == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (returnType == Byte.TYPE || returnType == Byte.class) {
            return (byte)0;
        }
        if (returnType == Short.TYPE || returnType == Short.class) {
            return (short)0;
        }
        if (returnType == Integer.TYPE || returnType == Integer.class) {
            return 0;
        }
        if (returnType == Long.TYPE || returnType == Long.class) {
            return 0L;
        }
        if (returnType == Float.TYPE || returnType == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (returnType == Double.TYPE || returnType == Double.class) {
            return 0.0;
        }
        if (returnType.isArray()) {
            return Array.newInstance(returnType.getComponentType(), 0);
        }
        if (returnType.isAssignableFrom(ArrayList.class)) {
            return new ArrayList(0);
        }
        if (returnType.isAssignableFrom(HashSet.class)) {
            return new HashSet(0);
        }
        if (returnType.isAssignableFrom(HashMap.class)) {
            return new HashMap(0);
        }
        if (String.class.equals(returnType)) {
            return "";
        }
        if (!returnType.isInterface()) {
            try {
                Object value = emptyInstances.get(returnType);
                if (value == null) {
                    value = returnType.newInstance();
                    emptyInstances.put(returnType, value);
                }
                for (Class<?> cls = value.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                    Field[] fields;
                    for (Field field : fields = cls.getDeclaredFields()) {
                        Object property = ReflectUtil.getEmptyObject(field.getType(), emptyInstances, level + 1);
                        if (property == null) continue;
                        try {
                            if (!field.isAccessible()) {
                                field.setAccessible(true);
                            }
                            field.set(value, property);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                return value;
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }
}

