/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.DefaultThreadFactory;
import com.weibo.api.motan.core.StandardThreadExecutor;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.AbstractClient;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public abstract class AbstractPoolClient
extends AbstractClient {
    private static ThreadPoolExecutor executor = new StandardThreadExecutor(1, 300, 20000, new DefaultThreadFactory("AbstractPoolClient-initPool-", true));
    protected static long defaultMinEvictableIdleTimeMillis = 3600000L;
    protected static long defaultSoftMinEvictableIdleTimeMillis = 600000L;
    protected static long defaultTimeBetweenEvictionRunsMillis = 600000L;
    protected GenericObjectPool pool;
    protected GenericObjectPool.Config poolConfig;
    protected PoolableObjectFactory factory;

    public AbstractPoolClient(URL url) {
        super(url);
    }

    protected void initPool() {
        this.poolConfig = new GenericObjectPool.Config();
        this.poolConfig.minIdle = this.url.getIntParameter(URLParamType.minClientConnection.getName(), URLParamType.minClientConnection.getIntValue());
        this.poolConfig.maxActive = this.poolConfig.maxIdle = this.url.getIntParameter(URLParamType.maxClientConnection.getName(), URLParamType.maxClientConnection.getIntValue()).intValue();
        this.poolConfig.maxWait = this.url.getIntParameter(URLParamType.requestTimeout.getName(), URLParamType.requestTimeout.getIntValue()).intValue();
        this.poolConfig.lifo = this.url.getBooleanParameter(URLParamType.poolLifo.getName(), URLParamType.poolLifo.getBooleanValue());
        this.poolConfig.minEvictableIdleTimeMillis = defaultMinEvictableIdleTimeMillis;
        this.poolConfig.softMinEvictableIdleTimeMillis = defaultSoftMinEvictableIdleTimeMillis;
        this.poolConfig.timeBetweenEvictionRunsMillis = defaultTimeBetweenEvictionRunsMillis;
        this.factory = this.createChannelFactory();
        this.pool = new GenericObjectPool(this.factory, this.poolConfig);
        boolean lazyInit = this.url.getBooleanParameter(URLParamType.lazyInit.getName(), URLParamType.lazyInit.getBooleanValue());
        if (!lazyInit) {
            this.initConnection(true);
        }
    }

    protected void initConnection(boolean async) {
        if (async) {
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractPoolClient.this.createConnections();
                        LoggerUtil.info("async initPool success!" + AbstractPoolClient.this.getUrl().getUri());
                    }
                });
                return;
            }
            catch (Exception e) {
                LoggerUtil.error("async initPool task execute fail!" + this.url.getUri(), e);
            }
        }
        this.createConnections();
    }

    private void createConnections() {
        for (int i = 0; i < this.poolConfig.minIdle; ++i) {
            try {
                this.pool.addObject();
                continue;
            }
            catch (Exception e) {
                LoggerUtil.error("NettyClient init pool create connect Error: url=" + this.url.getUri(), e);
            }
        }
    }

    protected abstract BasePoolableObjectFactory createChannelFactory();

    protected Channel borrowObject() throws Exception {
        Channel nettyChannel = (Channel)this.pool.borrowObject();
        if (nettyChannel != null && nettyChannel.isAvailable()) {
            return nettyChannel;
        }
        this.invalidateObject(nettyChannel);
        String errorMsg = this.getClass().getSimpleName() + " borrowObject Error: url=" + this.url.getUri();
        LoggerUtil.error(errorMsg);
        throw new MotanServiceException(errorMsg);
    }

    protected void invalidateObject(Channel nettyChannel) {
        if (nettyChannel == null) {
            return;
        }
        try {
            this.pool.invalidateObject((Object)nettyChannel);
        }
        catch (Exception ie) {
            LoggerUtil.error(this.getClass().getSimpleName() + " invalidate client Error: url=" + this.url.getUri(), ie);
        }
    }

    protected void returnObject(Channel channel) {
        if (channel == null) {
            return;
        }
        try {
            this.pool.returnObject((Object)channel);
        }
        catch (Exception ie) {
            LoggerUtil.error(this.getClass().getSimpleName() + " return client Error: url=" + this.url.getUri(), ie);
        }
    }
}

