/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import com.weibo.api.motan.util.StringTools;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class URL {
    private String protocol;
    private String host;
    private int port;
    private String path;
    private Map<String, String> parameters;
    private volatile transient Map<String, Number> numbers;

    public URL(String protocol, String host, int port, String path) {
        this(protocol, host, port, path, new HashMap<String, String>());
    }

    public URL(String protocol, String host, int port, String path, Map<String, String> parameters) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = this.removeAsyncPath(path);
        this.parameters = parameters;
    }

    public static URL valueOf(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new MotanServiceException("url is null");
        }
        String protocol = null;
        String host = null;
        int port = 0;
        String path = null;
        HashMap<String, String> parameters = new HashMap<String, String>();
        int i = url.indexOf("?");
        if (i >= 0) {
            String[] parts;
            for (String part : parts = url.substring(i + 1).split("\\&")) {
                if ((part = part.trim()).length() <= 0) continue;
                int j = part.indexOf(61);
                if (j >= 0) {
                    parameters.put(StringTools.urlDecode(part.substring(0, j)), StringTools.urlDecode(part.substring(j + 1)));
                    continue;
                }
                part = StringTools.urlDecode(part);
                parameters.put(part, part);
            }
            url = url.substring(0, i);
        }
        if ((i = url.indexOf("://")) >= 0) {
            if (i == 0) {
                throw new IllegalStateException("url missing protocol: \"" + url + "\"");
            }
            protocol = url.substring(0, i);
            url = url.substring(i + 3);
        } else {
            i = url.indexOf(":/");
            if (i >= 0) {
                if (i == 0) {
                    throw new IllegalStateException("url missing protocol: \"" + url + "\"");
                }
                protocol = url.substring(0, i);
                url = url.substring(i + 1);
            }
        }
        i = url.indexOf("/");
        if (i >= 0) {
            path = url.substring(i + 1);
            url = url.substring(0, i);
        }
        if ((i = url.indexOf(":")) >= 0 && i < url.length() - 1) {
            port = Integer.parseInt(url.substring(i + 1));
            url = url.substring(0, i);
        }
        if (url.length() > 0) {
            host = url;
        }
        return new URL(protocol, host, port, path, parameters);
    }

    private static String buildHostPortStr(String host, int defaultPort) {
        if (defaultPort <= 0) {
            return host;
        }
        int idx = host.indexOf(":");
        if (idx < 0) {
            return host + ":" + defaultPort;
        }
        int port = Integer.parseInt(host.substring(idx + 1));
        if (port <= 0) {
            return host.substring(0, idx + 1) + defaultPort;
        }
        return host;
    }

    public URL createCopy() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.parameters != null) {
            params.putAll(this.parameters);
        }
        return new URL(this.protocol, this.host, this.port, this.path, params);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = this.removeAsyncPath(path);
    }

    public String getVersion() {
        return this.getParameter(URLParamType.version.getName(), URLParamType.version.getValue());
    }

    public String getGroup() {
        return this.getParameter(URLParamType.group.getName(), URLParamType.group.getValue());
    }

    public String getApplication() {
        return this.getParameter(URLParamType.application.getName(), URLParamType.application.getValue());
    }

    public String getModule() {
        return this.getParameter(URLParamType.module.getName(), URLParamType.module.getValue());
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public String getParameter(String name, String defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getMethodParameter(String methodName, String paramDesc, String name) {
        String value = this.getParameter("methodconfig." + methodName + "(" + paramDesc + ")." + name);
        if (value == null || value.length() == 0) {
            return this.getParameter(name);
        }
        return value;
    }

    public String getMethodParameter(String methodName, String paramDesc, String name, String defaultValue) {
        String value = this.getMethodParameter(methodName, paramDesc, name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public void addParameter(String name, String value) {
        if (StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        this.parameters.put(name, value);
    }

    public void removeParameter(String name) {
        if (name != null) {
            this.parameters.remove(name);
        }
    }

    public void addParameters(Map<String, String> params) {
        this.parameters.putAll(params);
    }

    public void addParameterIfAbsent(String name, String value) {
        if (this.hasParameter(name)) {
            return;
        }
        this.parameters.put(name, value);
    }

    public Boolean getBooleanParameter(String name, boolean defaultValue) {
        String value = this.getParameter(name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public Boolean getMethodParameter(String methodName, String paramDesc, String name, boolean defaultValue) {
        String value = this.getMethodParameter(methodName, paramDesc, name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public Integer getIntParameter(String name, int defaultValue) {
        Number n = this.getNumbers().get(name);
        if (n != null) {
            return n.intValue();
        }
        String value = this.parameters.get(name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.getNumbers().put(name, i);
        return i;
    }

    public Integer getMethodParameter(String methodName, String paramDesc, String name, int defaultValue) {
        String key = methodName + "(" + paramDesc + ")." + name;
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getMethodParameter(methodName, paramDesc, name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.getNumbers().put(key, i);
        return i;
    }

    public Long getLongParameter(String name, long defaultValue) {
        Number n = this.getNumbers().get(name);
        if (n != null) {
            return n.longValue();
        }
        String value = this.parameters.get(name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.getNumbers().put(name, l);
        return l;
    }

    public Long getMethodParameter(String methodName, String paramDesc, String name, long defaultValue) {
        String key = methodName + "(" + paramDesc + ")." + name;
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getMethodParameter(methodName, paramDesc, name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.getNumbers().put(key, l);
        return l;
    }

    public Float getFloatParameter(String name, float defaultValue) {
        Number n = this.getNumbers().get(name);
        if (n != null) {
            return Float.valueOf(n.floatValue());
        }
        String value = this.parameters.get(name);
        if (value == null || value.length() == 0) {
            return Float.valueOf(defaultValue);
        }
        float f = Float.parseFloat(value);
        this.getNumbers().put(name, Float.valueOf(f));
        return Float.valueOf(f);
    }

    public Float getMethodParameter(String methodName, String paramDesc, String name, float defaultValue) {
        String key = methodName + "(" + paramDesc + ")." + name;
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return Float.valueOf(n.floatValue());
        }
        String value = this.getMethodParameter(methodName, paramDesc, name);
        if (value == null || value.length() == 0) {
            return Float.valueOf(defaultValue);
        }
        float f = Float.parseFloat(value);
        this.getNumbers().put(key, Float.valueOf(f));
        return Float.valueOf(f);
    }

    public Boolean getBooleanParameter(String name) {
        String value = this.parameters.get(name);
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    public String getUri() {
        return this.protocol + "://" + this.host + ":" + this.port + "/" + this.path;
    }

    public String getIdentity() {
        return this.protocol + "://" + this.host + ":" + this.port + "/" + this.getParameter(URLParamType.group.getName(), URLParamType.group.getValue()) + "/" + this.getPath() + "/" + this.getParameter(URLParamType.version.getName(), URLParamType.version.getValue()) + "/" + this.getParameter(URLParamType.nodeType.getName(), URLParamType.nodeType.getValue());
    }

    public boolean canServe(URL refUrl) {
        String refSerialize;
        String refVersion;
        if (refUrl == null || !this.getPath().equals(refUrl.getPath())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.protocol, (Object)refUrl.protocol)) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.getParameter(URLParamType.nodeType.getName()), (CharSequence)"service")) {
            return false;
        }
        String version = this.getParameter(URLParamType.version.getName(), URLParamType.version.getValue());
        if (!version.equals(refVersion = refUrl.getParameter(URLParamType.version.getName(), URLParamType.version.getValue()))) {
            return false;
        }
        String serialize = this.getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue());
        return serialize.equals(refSerialize = refUrl.getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue()));
    }

    public String toFullStr() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getUri()).append("?");
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (URLParamType.refreshTimestamp.name().equals(name)) continue;
            builder.append(StringTools.urlEncode(name)).append("=").append(StringTools.urlEncode(value)).append("&");
        }
        return builder.toString();
    }

    public String toString() {
        return this.toSimpleString();
    }

    public String toSimpleString() {
        return this.getUri() + "?group=" + this.getGroup();
    }

    public boolean hasParameter(String key) {
        return StringUtils.isNotBlank((CharSequence)this.getParameter(key));
    }

    public String getServerPortStr() {
        return URL.buildHostPortStr(this.host, this.port);
    }

    public void clearCacheInfo() {
        this.getNumbers().clear();
    }

    public int hashCode() {
        int factor = 31;
        int rs = 1;
        rs = factor * rs + ObjectUtils.hashCode((Object)this.protocol);
        rs = factor * rs + ObjectUtils.hashCode((Object)this.host);
        rs = factor * rs + ObjectUtils.hashCode((Object)this.port);
        rs = factor * rs + ObjectUtils.hashCode((Object)this.path);
        rs = factor * rs + ObjectUtils.hashCode(this.parameters);
        return rs;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof URL)) {
            return false;
        }
        URL ou = (URL)obj;
        if (!ObjectUtils.equals((Object)this.protocol, (Object)ou.protocol)) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.host, (Object)ou.host)) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.port, (Object)ou.port)) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.path, (Object)ou.path)) {
            return false;
        }
        return ObjectUtils.equals(this.parameters, ou.parameters);
    }

    private Map<String, Number> getNumbers() {
        if (this.numbers == null) {
            this.numbers = new ConcurrentHashMap<String, Number>();
        }
        return this.numbers;
    }

    private String removeAsyncPath(String path) {
        return MotanFrameworkUtil.removeAsyncSuffix(path);
    }
}

