/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.AbstractConfig;
import com.weibo.api.motan.config.annotation.ConfigDesc;
import com.weibo.api.motan.registry.RegistryService;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.UrlUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RegistryConfig
extends AbstractConfig {
    private static final long serialVersionUID = 3236055928361714933L;
    private String name;
    private String regProtocol;
    private String address;
    private Integer port;
    private Integer requestTimeout;
    private Integer connectTimeout;
    private Integer registrySessionTimeout;
    private Integer registryRetryPeriod;
    private String check;
    private Boolean register;
    private Boolean subscribe;
    private Boolean isDefault;
    private String excise;
    private RegistryConfig proxyRegistry;
    private String meshRegistryName;
    private Boolean dynamic;

    @ConfigDesc(key="protocol")
    public String getRegProtocol() {
        return this.regProtocol;
    }

    public void setRegProtocol(String regProtocol) {
        this.regProtocol = regProtocol;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    @Deprecated
    public void setCheck(Boolean check) {
        this.check = String.valueOf(check);
    }

    public Boolean getRegister() {
        return this.register;
    }

    public void setRegister(Boolean register) {
        this.register = register;
    }

    public Boolean getSubscribe() {
        return this.subscribe;
    }

    public void setSubscribe(Boolean subscribe) {
        this.subscribe = subscribe;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Integer getRegistrySessionTimeout() {
        return this.registrySessionTimeout;
    }

    public void setRegistrySessionTimeout(Integer registrySessionTimeout) {
        this.registrySessionTimeout = registrySessionTimeout;
    }

    public Integer getRegistryRetryPeriod() {
        return this.registryRetryPeriod;
    }

    public void setRegistryRetryPeriod(Integer registryRetryPeriod) {
        this.registryRetryPeriod = registryRetryPeriod;
    }

    public String getExcise() {
        return this.excise;
    }

    public void setExcise(String excise) {
        this.excise = excise;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public RegistryConfig getProxyRegistry() {
        return this.proxyRegistry;
    }

    public void setProxyRegistry(RegistryConfig proxyRegistry) {
        this.proxyRegistry = proxyRegistry;
    }

    public String getMeshRegistryName() {
        return this.meshRegistryName;
    }

    public void setMeshRegistryName(String meshRegistryName) {
        this.meshRegistryName = meshRegistryName;
    }

    public Boolean getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
    }

    public List<URL> toURLs() {
        String address = this.getAddress();
        if (StringUtils.isBlank((CharSequence)address)) {
            address = "127.0.0.1:0";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.getAddressParams());
        this.appendConfigParams(map);
        map.put(URLParamType.path.getName(), RegistryService.class.getName());
        map.put(URLParamType.refreshTimestamp.getName(), String.valueOf(System.currentTimeMillis()));
        if (!map.containsKey(URLParamType.protocol.getName())) {
            if (address.contains("://")) {
                map.put(URLParamType.protocol.getName(), address.substring(0, address.indexOf("://")));
            } else {
                map.put(URLParamType.protocol.getName(), "local");
            }
        }
        if (this.proxyRegistry != null) {
            String proxyRegistryString = UrlUtils.urlsToString(this.proxyRegistry.toURLs());
            if (StringUtils.isNotBlank((CharSequence)proxyRegistryString)) {
                map.put(URLParamType.proxyRegistryUrlString.getName(), proxyRegistryString);
            } else {
                LoggerUtil.warn("parse proxyRegistryString is empty, proxy registry:" + this.proxyRegistry.getName());
            }
        }
        return UrlUtils.parseURLs(address, map);
    }

    public Map<String, String> getAddressParams() {
        int index;
        if (StringUtils.isNotBlank((CharSequence)this.address) && (index = this.address.indexOf("?")) > -1) {
            int end = this.address.length();
            if (this.address.contains(",")) {
                end = this.address.indexOf(",");
            }
            return UrlUtils.parseQueryParams(this.address.substring(index + 1, end));
        }
        return Collections.emptyMap();
    }

    public static enum Excise {
        excise_static("static"),
        excise_dynamic("dynamic"),
        excise_ratio("ratio");

        private String name;

        private Excise(String n2) {
            this.name = n2;
        }

        public String getName() {
            return this.name;
        }
    }
}

