/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog;

import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;

public class AccessLogConfig {
    public static final String SERVER_BASE = "servicecomb.accesslog.";
    public static final String CLIENT_BASE = "servicecomb.accesslog.request.";
    public static final String SERVER_LOG_ENABLED = "servicecomb.accesslog.enabled";
    public static final String SERVER_LOG_PATTERN = "servicecomb.accesslog.pattern";
    public static final String CLIENT_LOG_ENABLED = "servicecomb.accesslog.request.enabled";
    public static final String CLIENT_LOG_PATTERN = "servicecomb.accesslog.request.pattern";
    public static final String DEFAULT_SERVER_PATTERN = "%h - - %t %r %s %B %D";
    public static final String DEFAULT_CLIENT_PATTERN = "%h %SCB-transport - - %t %r %s %D";
    public static final AccessLogConfig INSTANCE = new AccessLogConfig();
    private boolean serverLogEnabled;
    private boolean clientLogEnabled;
    private String serverLogPattern;
    private String clientLogPattern;

    private AccessLogConfig() {
        this.init();
    }

    private void init() {
        this.clientLogEnabled = LegacyPropertyFactory.getBooleanProperty((String)CLIENT_LOG_ENABLED, (boolean)false);
        this.serverLogEnabled = LegacyPropertyFactory.getBooleanProperty((String)SERVER_LOG_ENABLED, (boolean)false);
        this.clientLogPattern = LegacyPropertyFactory.getStringProperty((String)CLIENT_LOG_PATTERN, (String)DEFAULT_CLIENT_PATTERN);
        this.serverLogPattern = LegacyPropertyFactory.getStringProperty((String)SERVER_LOG_PATTERN, (String)DEFAULT_SERVER_PATTERN);
    }

    public boolean isServerLogEnabled() {
        return this.serverLogEnabled;
    }

    public boolean isClientLogEnabled() {
        return this.clientLogEnabled;
    }

    public String getServerLogPattern() {
        return this.serverLogPattern;
    }

    public String getClientLogPattern() {
        return this.clientLogPattern;
    }
}

