/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;

public class InvocationStageTrace {
    public static final String STAGE_TOTAL = "total";
    public static final String STAGE_PREPARE = "prepare";
    public static final String STAGE_PROVIDER_QUEUE = "queue";
    public static final String STAGE_PROVIDER_DECODE_REQUEST = "provider-decode";
    public static final String STAGE_PROVIDER_ENCODE_RESPONSE = "provider-encode";
    public static final String STAGE_PROVIDER_SEND = "provider-send";
    public static final String STAGE_PROVIDER_BUSINESS = "execute";
    public static final String STAGE_CONSUMER_CONNECTION = "connection";
    public static final String STAGE_CONSUMER_ENCODE_REQUEST = "consumer-encode";
    public static final String STAGE_CONSUMER_DECODE_RESPONSE = "consumer-decode";
    public static final String STAGE_CONSUMER_SEND = "consumer-send";
    public static final String STAGE_CONSUMER_WAIT = "wait";
    private final Invocation invocation;
    private long startInMillis;
    private long start;
    private long finish;
    private long startCreateInvocation;
    private long finishCreateInvocation;
    private long startProviderQueue;
    private long finishProviderQueue;
    private long startConsumerConnection;
    private long finishConsumerConnection;
    private long startProviderDecodeRequest;
    private long finishProviderDecodeRequest;
    private long startProviderEncodeResponse;
    private long finishProviderEncodeResponse;
    private long startConsumerEncodeRequest;
    private long finishConsumerEncodeRequest;
    private long startConsumerDecodeResponse;
    private long finishConsumerDecodeResponse;
    private long startProviderSendResponse;
    private long finishProviderSendResponse;
    private long startConsumerSendRequest;
    private long finishConsumerSendRequest;
    private long startBusinessExecute;
    private long finishBusinessExecute;
    private long startWaitResponse;
    private long finishWaitResponse;
    private final Map<String, Stage> stages = new HashMap<String, Stage>();

    public InvocationStageTrace(Invocation invocation) {
        this.invocation = invocation;
    }

    public String recordStageBegin(String stageName) {
        Object realStageName = stageName;
        while (this.stages.get(realStageName) != null) {
            realStageName = (String)realStageName + "@";
        }
        Stage stage = new Stage();
        stage.beginTime = System.nanoTime();
        this.stages.put((String)realStageName, stage);
        return realStageName;
    }

    public void recordStageEnd(String realStageName) {
        Stage stage = this.stages.get(realStageName);
        stage.endTime = this.nanoTime();
    }

    public Map<String, Stage> getStages() {
        return this.stages;
    }

    public void finish() {
        this.finish = this.nanoTime();
    }

    public void startCreateInvocation(long nano) {
        this.startCreateInvocation = nano;
        this.startInMillis = this.millisTime();
        this.start = this.nanoTime();
    }

    public void finishCreateInvocation() {
        this.finishCreateInvocation = this.nanoTime();
    }

    public long calcPrepare() {
        return InvocationStageTrace.calc(this.finishCreateInvocation, this.startCreateInvocation);
    }

    public void startProviderQueue() {
        this.startProviderQueue = this.nanoTime();
    }

    public void finishProviderQueue() {
        this.finishProviderQueue = this.nanoTime();
    }

    public long calcQueue() {
        return InvocationStageTrace.calc(this.finishProviderQueue, this.startProviderQueue);
    }

    public void startProviderDecodeRequest() {
        this.startProviderDecodeRequest = this.nanoTime();
    }

    public void finishProviderDecodeRequest() {
        this.finishProviderDecodeRequest = this.nanoTime();
    }

    public long calcProviderDecodeRequest() {
        return InvocationStageTrace.calc(this.finishProviderDecodeRequest, this.startProviderDecodeRequest);
    }

    public void startProviderEncodeResponse() {
        this.startProviderEncodeResponse = this.nanoTime();
    }

    public void finishProviderEncodeResponse() {
        this.finishProviderEncodeResponse = this.nanoTime();
    }

    public long calcProviderEncodeResponse() {
        return InvocationStageTrace.calc(this.finishProviderEncodeResponse, this.startProviderEncodeResponse);
    }

    public void startConsumerEncodeRequest() {
        this.startConsumerEncodeRequest = this.nanoTime();
    }

    public void finishConsumerEncodeRequest() {
        this.finishConsumerEncodeRequest = this.nanoTime();
    }

    public long calcConsumerEncodeRequest() {
        return InvocationStageTrace.calc(this.finishConsumerEncodeRequest, this.startConsumerEncodeRequest);
    }

    public void startConsumerDecodeResponse() {
        this.startConsumerDecodeResponse = this.nanoTime();
    }

    public void finishConsumerDecodeResponse() {
        this.finishConsumerDecodeResponse = this.nanoTime();
    }

    public long calcConsumerDecodeResponse() {
        return InvocationStageTrace.calc(this.finishConsumerDecodeResponse, this.startConsumerDecodeResponse);
    }

    public void startProviderSendResponse() {
        this.startProviderSendResponse = this.nanoTime();
    }

    public void finishProviderSendResponse() {
        this.finishProviderSendResponse = this.nanoTime();
    }

    public long calcProviderSendResponse() {
        return InvocationStageTrace.calc(this.finishProviderSendResponse, this.startProviderSendResponse);
    }

    public void startBusinessExecute() {
        this.startBusinessExecute = this.nanoTime();
    }

    public void finishBusinessExecute() {
        this.finishBusinessExecute = this.nanoTime();
    }

    public long calcBusinessExecute() {
        return InvocationStageTrace.calc(this.finishBusinessExecute, this.startBusinessExecute);
    }

    public void startConsumerConnection() {
        this.startConsumerConnection = this.nanoTime();
    }

    public void finishConsumerConnection() {
        this.finishConsumerConnection = this.nanoTime();
    }

    public long calcConnection() {
        return InvocationStageTrace.calc(this.finishConsumerConnection, this.startConsumerConnection);
    }

    public void startConsumerSendRequest() {
        this.startConsumerSendRequest = this.nanoTime();
    }

    public void finishConsumerSendRequest() {
        this.finishConsumerSendRequest = this.nanoTime();
    }

    public long calcConsumerSendRequest() {
        return InvocationStageTrace.calc(this.finishConsumerSendRequest, this.startConsumerSendRequest);
    }

    public void startWaitResponse() {
        this.startWaitResponse = this.nanoTime();
    }

    public void finishWaitResponse() {
        this.finishWaitResponse = this.nanoTime();
    }

    public long calcWait() {
        return InvocationStageTrace.calc(this.finishWaitResponse, this.startWaitResponse);
    }

    public long calcTotal() {
        return InvocationStageTrace.calc(this.finish, this.startCreateInvocation);
    }

    public long getStartInMillis() {
        return this.startInMillis;
    }

    public long getStart() {
        return this.start;
    }

    public static long calc(long finish, long start) {
        if (finish == 0L || start == 0L) {
            return 0L;
        }
        return finish - start;
    }

    protected long nanoTime() {
        return System.nanoTime();
    }

    protected long millisTime() {
        return System.currentTimeMillis();
    }

    public static class Stage {
        private long beginTime;
        private long endTime;

        public long getBeginTime() {
            return this.beginTime;
        }

        public long getEndTime() {
            return this.endTime;
        }
    }
}

