/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.handler.governance;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.decorators.Decorators;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.governance.MatchType;
import org.apache.servicecomb.governance.handler.InstanceBulkheadHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConsumerInstanceBulkheadFilter
extends AbstractFilter
implements ConsumerFilter,
EdgeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerInstanceBulkheadFilter.class);
    private final InstanceBulkheadHandler instanceBulkheadHandler;

    @Autowired
    public ConsumerInstanceBulkheadFilter(InstanceBulkheadHandler instanceBulkheadHandler) {
        this.instanceBulkheadHandler = instanceBulkheadHandler;
    }

    public int getOrder() {
        return 1060;
    }

    public String getName() {
        return "instance-bulkhead";
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        if (invocation.getEndpoint() == null) {
            return CompletableFuture.failedFuture((Throwable)new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, (Object)new CommonExceptionData("instance bulkhead should work after load balancer.")));
        }
        Supplier<CompletionStage<Response>> next = this.createBusinessCompletionStageSupplier(invocation, nextNode);
        Decorators.DecorateCompletionStage dcs = Decorators.ofCompletionStage(next);
        GovernanceRequestExtractor request = MatchType.createGovHttpRequest((Invocation)invocation);
        this.addBulkhead((Decorators.DecorateCompletionStage<Response>)dcs, request);
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        dcs.get().whenComplete((r, e) -> {
            if (e == null) {
                future.complete((Response)r);
                return;
            }
            if (e instanceof BulkheadFullException) {
                future.completeExceptionally((Throwable)new InvocationException(503, "bulkhead is full and does not permit further calls.", (Object)new CommonExceptionData("bulkhead is full and does not permit further calls.")));
                LOGGER.warn("bulkhead is full and does not permit further calls by policy : {}", (Object)e.getMessage());
            } else {
                future.completeExceptionally((Throwable)e);
            }
        });
        return future;
    }

    private void addBulkhead(Decorators.DecorateCompletionStage<Response> dcs, GovernanceRequestExtractor request) {
        Bulkhead bulkhead = (Bulkhead)this.instanceBulkheadHandler.getActuator(request);
        if (bulkhead != null) {
            dcs.withBulkhead(bulkhead);
        }
    }

    private Supplier<CompletionStage<Response>> createBusinessCompletionStageSupplier(Invocation invocation, FilterNode nextNode) {
        return () -> nextNode.onFilter(invocation);
    }
}

