/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.io.Serializable;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.primitives.Doubles;
import org.apache.sedona.shaded.s2.DistanceCollector;
import org.apache.sedona.shaded.s2.Platform;
import org.apache.sedona.shaded.s2.S1Angle;
import org.apache.sedona.shaded.s2.S1Distance;
import org.apache.sedona.shaded.s2.S2;
import org.apache.sedona.shaded.s2.S2Cell;
import org.apache.sedona.shaded.s2.S2EdgeUtil;
import org.apache.sedona.shaded.s2.S2Point;

@JsType
public final class S1ChordAngle
implements S1Distance<S1ChordAngle>,
Serializable {
    public static final double RELATIVE_SUM_ERROR = 4.485301019485632E-16;
    public static final double MAX_LENGTH2 = 4.0;
    public static final S1ChordAngle ZERO = new S1ChordAngle(0.0);
    public static final S1ChordAngle RIGHT = new S1ChordAngle(2.0);
    public static final S1ChordAngle STRAIGHT = new S1ChordAngle(4.0);
    public static final S1ChordAngle INFINITY = new S1ChordAngle(Double.POSITIVE_INFINITY);
    public static final S1ChordAngle NEGATIVE = new S1ChordAngle(-1.0);
    private final double length2;

    public static final DistanceCollector<S1ChordAngle> minCollector() {
        return new DistanceCollector<S1ChordAngle>(){
            private S1ChordAngle min = INFINITY;

            @Override
            public S1ChordAngle distance() {
                return this.min;
            }

            @Override
            public void reset() {
                this.min = INFINITY;
            }

            @Override
            public void set(S1ChordAngle value) {
                this.min = value;
            }

            @Override
            public boolean update(S1ChordAngle other) {
                if (other.lessThan(this.min)) {
                    this.min = other;
                    return true;
                }
                return false;
            }

            @Override
            public boolean update(S2Point p1, S2Point p2) {
                return this.update(new S1ChordAngle(p1, p2));
            }

            @Override
            public boolean update(S2Point p, S2Point v0, S2Point v1) {
                return this.update(S2EdgeUtil.updateMinDistance(p, v0, v1, this.min));
            }

            @Override
            public boolean update(S2Point v0, S2Point v1, S2Point w0, S2Point w1) {
                return this.update(S2EdgeUtil.getEdgePairMinDistance(v0, v1, w0, w1, this.min));
            }

            @Override
            public boolean update(S2Point p, S2Cell c) {
                return this.update(c.getDistance(p));
            }

            @Override
            public boolean update(S2Point v0, S2Point v1, S2Cell c) {
                return this.update(c.getDistanceToEdge(v0, v1));
            }

            @Override
            public boolean update(S2Cell c1, S2Cell c2) {
                return this.update(c1.getDistance(c2));
            }
        };
    }

    public static final DistanceCollector<S1ChordAngle> maxCollector() {
        return new DistanceCollector<S1ChordAngle>(){
            private S1ChordAngle max = NEGATIVE;

            @Override
            public S1ChordAngle distance() {
                return this.max;
            }

            @Override
            public void reset() {
                this.max = NEGATIVE;
            }

            @Override
            public void set(S1ChordAngle value) {
                this.max = value;
            }

            @Override
            public boolean update(S1ChordAngle other) {
                if (other.greaterThan(this.max)) {
                    this.max = other;
                    return true;
                }
                return false;
            }

            @Override
            public boolean update(S2Point p1, S2Point p2) {
                S1ChordAngle dist = new S1ChordAngle(p1, p2);
                if (dist.compareTo(RIGHT) > 0) {
                    dist = new S1ChordAngle(p1.neg(), p2);
                    dist = S1ChordAngle.sub(STRAIGHT, dist);
                }
                return this.update(dist);
            }

            @Override
            public boolean update(S2Point p, S2Point v0, S2Point v1) {
                return this.update(S2EdgeUtil.updateMaxDistance(p, v0, v1, this.max));
            }

            @Override
            public boolean update(S2Point v0, S2Point v1, S2Point w0, S2Point w1) {
                return this.update(S2EdgeUtil.getEdgePairMaxDistance(v0, v1, w0, w1, this.max));
            }

            @Override
            public boolean update(S2Point p, S2Cell c) {
                return this.update(c.getMaxDistance(p));
            }

            @Override
            public boolean update(S2Point v0, S2Point v1, S2Cell c) {
                return this.update(c.getMaxDistance(v0, v1));
            }

            @Override
            public boolean update(S2Cell c1, S2Cell c2) {
                return this.update(c1.getMaxDistance(c2));
            }
        };
    }

    @JsConstructor
    private S1ChordAngle(double length2) {
        this.length2 = length2;
        if (!this.isValid()) {
            throw new IllegalArgumentException("Invalid length2: " + length2);
        }
    }

    @JsIgnore
    public S1ChordAngle(S2Point x, S2Point y) {
        this(Math.min(4.0, x.getDistance2(y)));
        Preconditions.checkArgument(S2.isUnitLength(x));
        Preconditions.checkArgument(S2.isUnitLength(y));
        Preconditions.checkArgument(this.isValid());
    }

    public static S1ChordAngle fromS1Angle(S1Angle angle) {
        if (angle.radians() < 0.0) {
            return NEGATIVE;
        }
        if (angle.equals(S1Angle.INFINITY)) {
            return INFINITY;
        }
        double length = 2.0 * Math.sin(0.5 * Math.min(Math.PI, angle.radians()));
        return new S1ChordAngle(length * length);
    }

    public static S1ChordAngle fromRadians(double radians2) {
        return S1ChordAngle.fromS1Angle(S1Angle.radians(radians2));
    }

    public static S1ChordAngle fromDegrees(double degrees2) {
        return S1ChordAngle.fromS1Angle(S1Angle.degrees(degrees2));
    }

    public static S1ChordAngle fromE5(int e5) {
        return S1ChordAngle.fromS1Angle(S1Angle.e5(e5));
    }

    public static S1ChordAngle fromE6(int e6) {
        return S1ChordAngle.fromS1Angle(S1Angle.e6(e6));
    }

    public static S1ChordAngle fromE7(int e7) {
        return S1ChordAngle.fromS1Angle(S1Angle.e7(e7));
    }

    public double radians() {
        return this.toAngle().radians();
    }

    public double degrees() {
        return this.toAngle().degrees();
    }

    public int e5() {
        return this.toAngle().e5();
    }

    public int e6() {
        return this.toAngle().e6();
    }

    public int e7() {
        return this.toAngle().e7();
    }

    public static S1ChordAngle fromLength2(double length2) {
        return new S1ChordAngle(Math.min(4.0, length2));
    }

    @Override
    public boolean isZero() {
        return this.length2 == 0.0;
    }

    public boolean isNegative() {
        return this.length2 < 0.0;
    }

    public boolean isInfinity() {
        return this.length2 == Double.POSITIVE_INFINITY;
    }

    public boolean isSpecial() {
        return this.isNegative() || this.isInfinity();
    }

    public boolean isValid() {
        return this.length2 >= 0.0 && this.length2 <= 4.0 || this.isNegative() || this.isInfinity();
    }

    @Override
    public boolean lessThan(S1ChordAngle other) {
        return this.length2 < other.length2;
    }

    @Override
    public boolean greaterThan(S1ChordAngle other) {
        return this.length2 > other.length2;
    }

    @Override
    public boolean lessOrEquals(S1ChordAngle other) {
        return this.length2 <= other.length2;
    }

    @Override
    public boolean greaterOrEquals(S1ChordAngle other) {
        return this.length2 >= other.length2;
    }

    public S1Angle toAngle() {
        if (this.isNegative()) {
            return S1Angle.radians(-1.0);
        }
        if (this.isInfinity()) {
            return S1Angle.INFINITY;
        }
        return S1Angle.radians(2.0 * Math.asin(0.5 * Math.sqrt(this.length2)));
    }

    public double getLength2() {
        return this.length2;
    }

    public S1ChordAngle successor() {
        if (this.length2 >= 4.0) {
            return INFINITY;
        }
        if (this.length2 < 0.0) {
            return ZERO;
        }
        return new S1ChordAngle(Platform.nextAfter(this.length2, 10.0));
    }

    public S1ChordAngle predecessor() {
        if (this.length2 <= 0.0) {
            return NEGATIVE;
        }
        if (this.length2 > 4.0) {
            return STRAIGHT;
        }
        return new S1ChordAngle(Platform.nextAfter(this.length2, -10.0));
    }

    public static S1ChordAngle add(S1ChordAngle a, S1ChordAngle b) {
        Preconditions.checkArgument(!a.isSpecial());
        Preconditions.checkArgument(!b.isSpecial());
        double a2 = a.length2;
        double b2 = b.length2;
        if (b2 == 0.0) {
            return a;
        }
        if (a2 + b2 >= 4.0) {
            return STRAIGHT;
        }
        double x = a2 * (1.0 - 0.25 * b2);
        double y = b2 * (1.0 - 0.25 * a2);
        return new S1ChordAngle(Math.min(4.0, x + y + 2.0 * Math.sqrt(x * y)));
    }

    public static S1ChordAngle sub(S1ChordAngle a, S1ChordAngle b) {
        Preconditions.checkArgument(!a.isSpecial());
        Preconditions.checkArgument(!b.isSpecial());
        double a2 = a.length2;
        double b2 = b.length2;
        if (b2 == 0.0) {
            return a;
        }
        if (a2 <= b2) {
            return ZERO;
        }
        double x = a2 * (1.0 - 0.25 * b2);
        double y = b2 * (1.0 - 0.25 * a2);
        double c = Math.max(0.0, Math.sqrt(x) - Math.sqrt(y));
        return new S1ChordAngle(c * c);
    }

    public static S1ChordAngle min(S1ChordAngle a, S1ChordAngle b) {
        return a.length2 <= b.length2 ? a : b;
    }

    public static S1ChordAngle max(S1ChordAngle a, S1ChordAngle b) {
        return a.length2 > b.length2 ? a : b;
    }

    public static double sin2(S1ChordAngle a) {
        Preconditions.checkArgument(!a.isSpecial());
        return a.length2 * (1.0 - 0.25 * a.length2);
    }

    public static double sin(S1ChordAngle a) {
        return Math.sqrt(S1ChordAngle.sin2(a));
    }

    public static double cos(S1ChordAngle a) {
        Preconditions.checkArgument(!a.isSpecial());
        return 1.0 - 0.5 * a.length2;
    }

    public static double tan(S1ChordAngle a) {
        return S1ChordAngle.sin(a) / S1ChordAngle.cos(a);
    }

    public S1ChordAngle plusError(double error) {
        return this.isSpecial() ? this : S1ChordAngle.fromLength2(Math.max(0.0, Math.min(4.0, this.length2 + error)));
    }

    public double getS1AngleConstructorMaxError() {
        return (double)3.330669E-16f * this.length2;
    }

    public double getS2PointConstructorMaxError() {
        return 9.992007221626409E-16 * this.length2 + 7.888609052210118E-31;
    }

    public String toString() {
        if (this.length2 == S1ChordAngle.NEGATIVE.length2) {
            return "NEGATIVE";
        }
        if (this.length2 == S1ChordAngle.ZERO.length2) {
            return "ZERO";
        }
        if (this.length2 == S1ChordAngle.STRAIGHT.length2) {
            return "STRAIGHT";
        }
        if (this.length2 == S1ChordAngle.INFINITY.length2) {
            return "INFINITY";
        }
        return this.toAngle().toString();
    }

    @Override
    public int compareTo(S1ChordAngle that) {
        return Double.compare(this.length2, that.length2);
    }

    public boolean equals(Object other) {
        return other instanceof S1ChordAngle && this.length2 == ((S1ChordAngle)other).length2;
    }

    public int hashCode() {
        return this.length2 == 0.0 ? 0 : Doubles.hashCode(this.length2);
    }
}

