/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.metrics.Timekeeper;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.LeaderElectionManagementRequest;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientAsynchronousProtocol;
import org.apache.ratis.protocol.RaftClientProtocol;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.LeaderSteppingDownException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.ReadException;
import org.apache.ratis.protocol.exceptions.ReadIndexException;
import org.apache.ratis.protocol.exceptions.ReconfigurationInProgressException;
import org.apache.ratis.protocol.exceptions.ResourceUnavailableException;
import org.apache.ratis.protocol.exceptions.ServerNotReadyException;
import org.apache.ratis.protocol.exceptions.SetConfigurationException;
import org.apache.ratis.protocol.exceptions.StaleReadException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.protocol.exceptions.TransferLeadershipException;
import org.apache.ratis.server.DataStreamMap;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.DivisionProperties;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.CommitInfoCache;
import org.apache.ratis.server.impl.DataStreamMapImpl;
import org.apache.ratis.server.impl.DivisionPropertiesImpl;
import org.apache.ratis.server.impl.FollowerState;
import org.apache.ratis.server.impl.LeaderElection;
import org.apache.ratis.server.impl.LeaderStateImpl;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerJmxAdapter;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.ReadRequests;
import org.apache.ratis.server.impl.RetryCacheImpl;
import org.apache.ratis.server.impl.RoleInfo;
import org.apache.ratis.server.impl.ServerImplUtils;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.impl.SnapshotInstallationHandler;
import org.apache.ratis.server.impl.SnapshotManagementRequestHandler;
import org.apache.ratis.server.impl.TransactionManager;
import org.apache.ratis.server.impl.TransferLeadership;
import org.apache.ratis.server.impl.VoteContext;
import org.apache.ratis.server.impl.WriteIndexCache;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.server.metrics.LeaderElectionMetrics;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.apache.ratis.server.protocol.RaftServerAsynchronousProtocol;
import org.apache.ratis.server.protocol.RaftServerProtocol;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageDirectoryImpl;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.TransactionContextImpl;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.ConcurrentUtils;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedSupplier;

class RaftServerImpl
implements RaftServer.Division,
RaftServerProtocol,
RaftServerAsynchronousProtocol,
RaftClientProtocol,
RaftClientAsynchronousProtocol {
    private static final String CLASS_NAME = JavaUtils.getClassSimpleName(RaftServerImpl.class);
    static final String REQUEST_VOTE = CLASS_NAME + ".requestVote";
    static final String APPEND_ENTRIES = CLASS_NAME + ".appendEntries";
    static final String INSTALL_SNAPSHOT = CLASS_NAME + ".installSnapshot";
    static final String APPEND_TRANSACTION = CLASS_NAME + ".appendTransaction";
    static final String LOG_SYNC = APPEND_ENTRIES + ".logComplete";
    static final String START_LEADER_ELECTION = CLASS_NAME + ".startLeaderElection";
    static final String START_COMPLETE = CLASS_NAME + ".startComplete";
    private final RaftServerProxy proxy;
    private final StateMachine stateMachine;
    private final Info info = new Info();
    private final DivisionProperties divisionProperties;
    private final TimeDuration leaderStepDownWaitTime;
    private final boolean memberMajorityAddEnabled;
    private final TimeDuration sleepDeviationThreshold;
    private final LifeCycle lifeCycle;
    private final ServerState state;
    private final RoleInfo role;
    private final DataStreamMap dataStreamMap;
    private final RaftServerConfigKeys.Read.Option readOption;
    private final TransactionManager transactionManager;
    private final RetryCacheImpl retryCache;
    private final CommitInfoCache commitInfoCache = new CommitInfoCache();
    private final WriteIndexCache writeIndexCache;
    private final RaftServerJmxAdapter jmxAdapter = new RaftServerJmxAdapter(this);
    private final LeaderElectionMetrics leaderElectionMetrics;
    private final RaftServerMetricsImpl raftServerMetrics;
    private final CountDownLatch closeFinishedLatch = new CountDownLatch(1);
    private final AtomicBoolean startComplete;
    private final TransferLeadership transferLeadership;
    private final SnapshotManagementRequestHandler snapshotRequestHandler;
    private final SnapshotInstallationHandler snapshotInstallationHandler;
    private final ExecutorService serverExecutor;
    private final ExecutorService clientExecutor;
    private final AtomicBoolean firstElectionSinceStartup = new AtomicBoolean(true);
    private final ThreadGroup threadGroup;
    private final AtomicReference<CompletableFuture<Void>> appendLogFuture;
    private final ServerImplUtils.NavigableIndices appendLogTermIndices = new ServerImplUtils.NavigableIndices();

    RaftServerImpl(RaftGroup group, StateMachine stateMachine, RaftServerProxy proxy, RaftStorage.StartupOption option) throws IOException {
        RaftPeerId id = proxy.getId();
        LOG.info("{}: new RaftServerImpl for {} with {}", id, group, stateMachine);
        this.lifeCycle = new LifeCycle(id);
        this.stateMachine = stateMachine;
        this.role = new RoleInfo(id);
        RaftProperties properties = proxy.getProperties();
        this.divisionProperties = new DivisionPropertiesImpl(properties);
        this.leaderStepDownWaitTime = RaftServerConfigKeys.LeaderElection.leaderStepDownWaitTime(properties);
        this.memberMajorityAddEnabled = RaftServerConfigKeys.LeaderElection.memberMajorityAdd(properties);
        this.sleepDeviationThreshold = RaftServerConfigKeys.sleepDeviationThreshold(properties);
        this.proxy = proxy;
        this.state = new ServerState(id, group, stateMachine, this, option, properties);
        this.retryCache = new RetryCacheImpl(properties);
        this.dataStreamMap = new DataStreamMapImpl(id);
        this.readOption = RaftServerConfigKeys.Read.option(properties);
        this.writeIndexCache = new WriteIndexCache(properties);
        this.transactionManager = new TransactionManager(id);
        this.leaderElectionMetrics = LeaderElectionMetrics.getLeaderElectionMetrics(this.getMemberId(), this.state::getLastLeaderElapsedTimeMs);
        this.raftServerMetrics = RaftServerMetricsImpl.computeIfAbsentRaftServerMetrics(this.getMemberId(), this::getCommitIndex, this.retryCache::getStatistics);
        this.startComplete = new AtomicBoolean(false);
        this.threadGroup = new ThreadGroup(proxy.getThreadGroup(), this.getMemberId().toString());
        this.transferLeadership = new TransferLeadership(this, properties);
        this.snapshotRequestHandler = new SnapshotManagementRequestHandler(this);
        this.snapshotInstallationHandler = new SnapshotInstallationHandler(this, properties);
        this.appendLogFuture = new AtomicReference<CompletableFuture<Object>>(CompletableFuture.completedFuture(null));
        this.serverExecutor = ConcurrentUtils.newThreadPoolWithMax(RaftServerConfigKeys.ThreadPool.serverCached(properties), RaftServerConfigKeys.ThreadPool.serverSize(properties), id + "-server");
        this.clientExecutor = ConcurrentUtils.newThreadPoolWithMax(RaftServerConfigKeys.ThreadPool.clientCached(properties), RaftServerConfigKeys.ThreadPool.clientSize(properties), id + "-client");
    }

    private long getCommitIndex(RaftPeerId id) {
        return this.commitInfoCache.get(id).orElse(0L);
    }

    @Override
    public DivisionProperties properties() {
        return this.divisionProperties;
    }

    int getMaxTimeoutMs() {
        return this.properties().maxRpcTimeoutMs();
    }

    TimeDuration getRandomElectionTimeout() {
        if (this.firstElectionSinceStartup.get()) {
            return this.getFirstRandomElectionTimeout();
        }
        int min2 = this.properties().minRpcTimeoutMs();
        int millis = min2 + ThreadLocalRandom.current().nextInt(this.properties().maxRpcTimeoutMs() - min2 + 1);
        return TimeDuration.valueOf(millis, TimeUnit.MILLISECONDS);
    }

    private TimeDuration getFirstRandomElectionTimeout() {
        RaftProperties properties = this.proxy.getProperties();
        int min2 = RaftServerConfigKeys.Rpc.firstElectionTimeoutMin(properties).toIntExact(TimeUnit.MILLISECONDS);
        int max = RaftServerConfigKeys.Rpc.firstElectionTimeoutMax(properties).toIntExact(TimeUnit.MILLISECONDS);
        int mills = min2 + ThreadLocalRandom.current().nextInt(max - min2 + 1);
        return TimeDuration.valueOf(mills, TimeUnit.MILLISECONDS);
    }

    TimeDuration getLeaderStepDownWaitTime() {
        return this.leaderStepDownWaitTime;
    }

    TimeDuration getSleepDeviationThreshold() {
        return this.sleepDeviationThreshold;
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    @Override
    public RaftLog getRaftLog() {
        return this.getState().getLog();
    }

    @Override
    public RaftStorage getRaftStorage() {
        return this.getState().getStorage();
    }

    @Override
    public DataStreamMap getDataStreamMap() {
        return this.dataStreamMap;
    }

    @Override
    public RetryCacheImpl getRetryCache() {
        return this.retryCache;
    }

    @Override
    public RaftServerProxy getRaftServer() {
        return this.proxy;
    }

    TransferLeadership getTransferLeadership() {
        return this.transferLeadership;
    }

    RaftServerRpc getServerRpc() {
        return this.proxy.getServerRpc();
    }

    private void setRole(RaftProtos.RaftPeerRole newRole, Object reason) {
        LOG.info("{}: changes role from {} to {} at term {} for {}", this.getMemberId(), this.role, newRole, this.state.getCurrentTerm(), reason);
        this.role.transitionRole(newRole);
    }

    boolean start() throws IOException {
        if (!this.lifeCycle.compareAndTransition(LifeCycle.State.NEW, LifeCycle.State.STARTING)) {
            return false;
        }
        this.state.initialize(this.stateMachine);
        RaftConfigurationImpl conf = this.getRaftConf();
        if (conf != null && conf.containsInBothConfs(this.getId())) {
            LOG.info("{}: start as a follower, conf={}", (Object)this.getMemberId(), (Object)conf);
            this.startAsPeer(RaftProtos.RaftPeerRole.FOLLOWER);
        } else if (conf != null && conf.containsInConf(this.getId(), RaftProtos.RaftPeerRole.LISTENER)) {
            LOG.info("{}: start as a listener, conf={}", (Object)this.getMemberId(), (Object)conf);
            this.startAsPeer(RaftProtos.RaftPeerRole.LISTENER);
        } else {
            LOG.info("{}: start with initializing state, conf={}", (Object)this.getMemberId(), (Object)conf);
            this.setRole(RaftProtos.RaftPeerRole.FOLLOWER, (Object)LeaderElection.Result.NOT_IN_CONF);
        }
        this.jmxAdapter.registerMBean();
        this.state.start();
        CodeInjectionForTesting.execute(START_COMPLETE, this.getId(), null, this.role);
        if (this.startComplete.compareAndSet(false, true)) {
            LOG.info("{}: Successfully started.", (Object)this.getMemberId());
        }
        return true;
    }

    private void startAsPeer(RaftProtos.RaftPeerRole newRole) {
        String reason;
        if (newRole == RaftProtos.RaftPeerRole.FOLLOWER) {
            reason = "startAsFollower";
            this.setRole(RaftProtos.RaftPeerRole.FOLLOWER, reason);
        } else if (newRole == RaftProtos.RaftPeerRole.LISTENER) {
            reason = "startAsListener";
            this.setRole(RaftProtos.RaftPeerRole.LISTENER, reason);
        } else {
            throw new IllegalArgumentException("Unexpected role " + newRole);
        }
        this.role.startFollowerState(this, reason);
        this.lifeCycle.transition(LifeCycle.State.RUNNING);
    }

    ServerState getState() {
        return this.state;
    }

    @Override
    public RaftGroupMemberId getMemberId() {
        return this.getState().getMemberId();
    }

    @Override
    public RaftPeer getPeer() {
        return Optional.ofNullable(this.getState().getCurrentPeer()).orElseGet(() -> this.getRaftServer().getPeer());
    }

    @Override
    public DivisionInfo getInfo() {
        return this.info;
    }

    RoleInfo getRole() {
        return this.role;
    }

    @Override
    public RaftConfigurationImpl getRaftConf() {
        return this.getState().getRaftConf();
    }

    void groupRemove(boolean deleteDirectory, boolean renameDirectory) {
        block8: {
            RaftStorageDirectoryImpl dir;
            block9: {
                dir = this.state.getStorage().getStorageDir();
                this.state.getStateMachineUpdater().setRemoving();
                this.close();
                try {
                    this.closeFinishedLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.warn("{}: Waiting closing interrupted, will not continue to remove group locally", (Object)this.getMemberId());
                    return;
                }
                this.getStateMachine().event().notifyGroupRemove();
                if (!deleteDirectory) break block9;
                for (int i = 0; i < 5; ++i) {
                    try {
                        FileUtils.deleteFully(dir.getRoot());
                        LOG.info("{}: Succeed to remove RaftStorageDirectory {}", (Object)this.getMemberId(), (Object)dir);
                        break block8;
                    }
                    catch (NoSuchFileException e) {
                        LOG.warn("{}: Some file does not exist {}", this.getMemberId(), dir, e);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("{}: Failed to remove RaftStorageDirectory {}", this.getMemberId(), dir, e);
                        break block8;
                    }
                }
                break block8;
            }
            if (!renameDirectory) break block8;
            try {
                File toBeRemovedGroupFolder = new File(RaftServerConfigKeys.removedGroupsDir(this.proxy.getProperties()), dir.getRoot().getName());
                FileUtils.moveDirectory(dir.getRoot().toPath(), toBeRemovedGroupFolder.toPath());
                LOG.info("{}: Group {} is renamed successfully", (Object)this.getMemberId(), (Object)this.getGroup());
            }
            catch (IOException e) {
                LOG.warn("{}: Failed to remove group {}", this.getMemberId(), dir.getRoot().getName(), e);
            }
        }
    }

    @Override
    public void close() {
        this.lifeCycle.checkStateAndClose(() -> {
            LOG.info("{}: shutdown", (Object)this.getMemberId());
            try {
                this.jmxAdapter.unregister();
            }
            catch (Exception e) {
                LOG.warn("{}: Failed to un-register RaftServer JMX bean", (Object)this.getMemberId(), (Object)e);
            }
            try {
                this.role.shutdownFollowerState();
            }
            catch (Exception e) {
                LOG.warn("{}: Failed to shutdown FollowerState", (Object)this.getMemberId(), (Object)e);
            }
            try {
                this.role.shutdownLeaderElection();
            }
            catch (Exception e) {
                LOG.warn("{}: Failed to shutdown LeaderElection", (Object)this.getMemberId(), (Object)e);
            }
            try {
                this.role.shutdownLeaderState(true).join();
            }
            catch (Exception e) {
                LOG.warn("{}: Failed to shutdown LeaderState monitor", (Object)this.getMemberId(), (Object)e);
            }
            try {
                this.state.close();
            }
            catch (Exception e) {
                LOG.warn("{}: Failed to close state", (Object)this.getMemberId(), (Object)e);
            }
            try {
                this.leaderElectionMetrics.unregister();
                this.raftServerMetrics.unregister();
                RaftServerMetricsImpl.removeRaftServerMetrics(this.getMemberId());
            }
            catch (Exception e) {
                LOG.warn("{}: Failed to unregister metric", (Object)this.getMemberId(), (Object)e);
            }
            try {
                ConcurrentUtils.shutdownAndWait(this.clientExecutor);
            }
            catch (Exception e) {
                LOG.warn("{}: Failed to shutdown clientExecutor", (Object)this.getMemberId(), (Object)e);
            }
            try {
                ConcurrentUtils.shutdownAndWait(this.serverExecutor);
            }
            catch (Exception e) {
                LOG.warn("{}: Failed to shutdown serverExecutor", (Object)this.getMemberId(), (Object)e);
            }
            this.closeFinishedLatch.countDown();
        });
    }

    void setFirstElection(Object reason) {
        if (this.firstElectionSinceStartup.compareAndSet(true, false)) {
            LOG.info("{}: set firstElectionSinceStartup to false for {}", (Object)this.getMemberId(), reason);
        }
    }

    private synchronized CompletableFuture<Void> changeToFollower(long newTerm, boolean force, boolean allowListener, Object reason, AtomicBoolean metadataUpdated) {
        RaftProtos.RaftPeerRole old = this.role.getCurrentRole();
        if (old == RaftProtos.RaftPeerRole.LISTENER && !allowListener) {
            throw new IllegalStateException("Unexpected role " + old);
        }
        CompletionStage<Object> future = CompletableFuture.completedFuture(null);
        if ((old != RaftProtos.RaftPeerRole.FOLLOWER || force) && old != RaftProtos.RaftPeerRole.LISTENER) {
            this.setRole(RaftProtos.RaftPeerRole.FOLLOWER, reason);
            if (old == RaftProtos.RaftPeerRole.LEADER) {
                future = this.role.shutdownLeaderState(false).exceptionally(e -> {
                    if (e != null && !this.getInfo().isAlive()) {
                        LOG.info("Since server is not alive {}, safely ignore {}", (Object)this, (Object)e.toString());
                        return null;
                    }
                    throw new CompletionException("Failed to shutdownLeaderState: " + this, (Throwable)e);
                });
                this.state.setLeader(null, reason);
            } else if (old == RaftProtos.RaftPeerRole.CANDIDATE) {
                future = this.role.shutdownLeaderElection();
            } else if (old == RaftProtos.RaftPeerRole.FOLLOWER) {
                future = this.role.shutdownFollowerState();
            }
            metadataUpdated.set(this.state.updateCurrentTerm(newTerm));
            this.role.startFollowerState(this, reason);
            this.setFirstElection(reason);
        } else {
            metadataUpdated.set(this.state.updateCurrentTerm(newTerm));
        }
        return future;
    }

    synchronized CompletableFuture<Void> changeToFollowerAndPersistMetadata(long newTerm, boolean allowListener, Object reason) throws IOException {
        AtomicBoolean metadataUpdated = new AtomicBoolean();
        CompletableFuture<Void> future = this.changeToFollower(newTerm, false, allowListener, reason, metadataUpdated);
        if (metadataUpdated.get()) {
            this.state.persistMetadata();
        }
        return future;
    }

    synchronized void changeToLeader() {
        Preconditions.assertTrue(this.getInfo().isCandidate());
        this.role.shutdownLeaderElection();
        this.setRole(RaftProtos.RaftPeerRole.LEADER, "changeToLeader");
        LeaderStateImpl leader = this.role.updateLeaderState(this);
        this.state.becomeLeader();
        leader.start();
    }

    @Override
    public Collection<RaftProtos.CommitInfoProto> getCommitInfos() {
        ArrayList<RaftProtos.CommitInfoProto> infos = new ArrayList<RaftProtos.CommitInfoProto>();
        long commitIndex = this.updateCommitInfoCache();
        infos.add(ProtoUtils.toCommitInfoProto(this.getPeer(), commitIndex));
        if (this.getInfo().isLeader()) {
            this.role.getLeaderState().ifPresent(leader -> leader.updateFollowerCommitInfos(this.commitInfoCache, infos));
        } else {
            RaftConfigurationImpl raftConf = this.getRaftConf();
            Stream.concat(raftConf.getAllPeers(RaftProtos.RaftPeerRole.FOLLOWER).stream(), raftConf.getAllPeers(RaftProtos.RaftPeerRole.LISTENER).stream()).filter(peer -> !peer.getId().equals(this.getId())).map(peer -> this.commitInfoCache.get(peer.getId()).map(index -> ProtoUtils.toCommitInfoProto(peer, index)).orElse(null)).filter(Objects::nonNull).forEach(infos::add);
        }
        return infos;
    }

    GroupInfoReply getGroupInfo(GroupInfoRequest request) {
        RaftStorageDirectoryImpl dir = this.state.getStorage().getStorageDir();
        RaftProtos.RaftConfigurationProto conf = LogProtoUtils.toRaftConfigurationProtoBuilder(this.getRaftConf()).build();
        return new GroupInfoReply(request, this.getCommitInfos(), this.getGroup(), this.getRoleInfoProto(), dir.isHealthy(), conf, this.getLogInfo());
    }

    RaftProtos.LogInfoProto getLogInfo() {
        SnapshotInfo snapshot;
        TermIndex entry;
        TermIndex committed;
        RaftLog log = this.getRaftLog();
        RaftProtos.LogInfoProto.Builder logInfoBuilder = RaftProtos.LogInfoProto.newBuilder();
        TermIndex applied = this.getStateMachine().getLastAppliedTermIndex();
        if (applied != null) {
            logInfoBuilder.setApplied(applied.toProto());
        }
        if ((committed = log.getTermIndex(log.getLastCommittedIndex())) != null) {
            logInfoBuilder.setCommitted(committed.toProto());
        }
        if ((entry = log.getLastEntryTermIndex()) != null) {
            logInfoBuilder.setLastEntry(entry.toProto());
        }
        if ((snapshot = this.getStateMachine().getLatestSnapshot()) != null) {
            logInfoBuilder.setLastSnapshot(snapshot.getTermIndex().toProto());
        }
        return logInfoBuilder.build();
    }

    RaftProtos.RoleInfoProto getRoleInfoProto() {
        return this.role.buildRoleInfoProto(this);
    }

    synchronized void changeToCandidate(boolean forceStartLeaderElection) {
        Preconditions.assertTrue(this.getInfo().isFollower());
        this.role.shutdownFollowerState();
        this.setRole(RaftProtos.RaftPeerRole.CANDIDATE, "changeToCandidate");
        if (this.state.shouldNotifyExtendedNoLeader()) {
            this.stateMachine.followerEvent().notifyExtendedNoLeader(this.getRoleInfoProto());
        }
        this.role.startLeaderElection(this, forceStartLeaderElection);
    }

    public String toString() {
        return this.role + " (" + (Object)((Object)this.lifeCycle.getCurrentState()) + "): " + this.state;
    }

    RaftClientReply.Builder newReplyBuilder(RaftClientRequest request) {
        return RaftClientReply.newBuilder().setRequest(request).setCommitInfos(this.getCommitInfos());
    }

    private RaftClientReply.Builder newReplyBuilder(ClientInvocationId invocationId, long logIndex) {
        return RaftClientReply.newBuilder().setClientInvocationId(invocationId).setLogIndex(logIndex).setServerId(this.getMemberId()).setCommitInfos(this.getCommitInfos());
    }

    RaftClientReply newSuccessReply(RaftClientRequest request) {
        return this.newReplyBuilder(request).setSuccess().build();
    }

    RaftClientReply newSuccessReply(RaftClientRequest request, long logIndex) {
        return this.newReplyBuilder(request).setSuccess().setLogIndex(logIndex).build();
    }

    RaftClientReply newExceptionReply(RaftClientRequest request, RaftException exception) {
        return this.newReplyBuilder(request).setException(exception).build();
    }

    private CompletableFuture<RaftClientReply> checkLeaderState(RaftClientRequest request) {
        try {
            ServerImplUtils.assertGroup(this.getMemberId(), request);
        }
        catch (GroupMismatchException e) {
            return JavaUtils.completeExceptionally(e);
        }
        return this.checkLeaderState(request, null);
    }

    private CompletableFuture<RaftClientReply> checkLeaderState(RaftClientRequest request, RetryCacheImpl.CacheEntry entry) {
        if (!this.getInfo().isLeader()) {
            NotLeaderException exception = this.generateNotLeaderException();
            RaftClientReply reply = this.newExceptionReply(request, exception);
            return RetryCacheImpl.failWithReply(reply, entry);
        }
        if (!this.getInfo().isLeaderReady()) {
            RetryCacheImpl.CacheEntry cacheEntry = this.retryCache.getIfPresent(ClientInvocationId.valueOf(request));
            if (cacheEntry != null && cacheEntry.isCompletedNormally()) {
                return cacheEntry.getReplyFuture();
            }
            LeaderNotReadyException lnre = new LeaderNotReadyException(this.getMemberId());
            RaftClientReply reply = this.newExceptionReply(request, lnre);
            return RetryCacheImpl.failWithReply(reply, entry);
        }
        if (!request.isReadOnly() && this.isSteppingDown()) {
            LeaderSteppingDownException lsde = new LeaderSteppingDownException(this.getMemberId() + " is stepping down");
            RaftClientReply reply = this.newExceptionReply(request, lsde);
            return RetryCacheImpl.failWithReply(reply, entry);
        }
        return null;
    }

    NotLeaderException generateNotLeaderException() {
        if (!this.lifeCycle.getCurrentState().isRunning()) {
            return new NotLeaderException(this.getMemberId(), null, null);
        }
        RaftPeerId leaderId = this.state.getLeaderId();
        if (leaderId == null || leaderId.equals(this.getId())) {
            leaderId = null;
        }
        RaftConfigurationImpl conf = this.getRaftConf();
        Collection<RaftPeer> peers = conf.getAllPeers();
        return new NotLeaderException(this.getMemberId(), conf.getPeer(leaderId, new RaftProtos.RaftPeerRole[0]), peers);
    }

    void assertLifeCycleState(Set<LifeCycle.State> expected) throws ServerNotReadyException {
        this.lifeCycle.assertCurrentState((n, c) -> new ServerNotReadyException(this.getMemberId() + " is not in " + expected + ": current state is " + (Object)c), expected);
    }

    private CompletableFuture<RaftClientReply> getResourceUnavailableReply(RaftClientRequest request, RetryCacheImpl.CacheEntry entry) {
        return entry.failWithException(new ResourceUnavailableException(this.getMemberId() + ": Failed to acquire a pending write request for " + request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<RaftClientReply> appendTransaction(RaftClientRequest request, TransactionContextImpl context, RetryCacheImpl.CacheEntry cacheEntry) throws IOException {
        PendingRequest pending;
        LeaderStateImpl leaderState;
        CodeInjectionForTesting.execute(APPEND_TRANSACTION, this.getId(), request.getClientId(), request, context, cacheEntry);
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        LeaderStateImpl unsyncedLeaderState = this.role.getLeaderState().orElse(null);
        if (unsyncedLeaderState == null) {
            RaftClientReply reply = this.newExceptionReply(request, this.generateNotLeaderException());
            return RetryCacheImpl.failWithReply(reply, cacheEntry);
        }
        PendingRequests.Permit unsyncedPermit = unsyncedLeaderState.tryAcquirePendingRequest(request.getMessage());
        if (unsyncedPermit == null) {
            return this.getResourceUnavailableReply(request, cacheEntry);
        }
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            PendingRequests.Permit permit;
            CompletableFuture<RaftClientReply> reply = this.checkLeaderState(request, cacheEntry);
            if (reply != null) {
                return reply;
            }
            leaderState = this.role.getLeaderStateNonNull();
            PendingRequests.Permit permit2 = permit = leaderState == unsyncedLeaderState ? unsyncedPermit : leaderState.tryAcquirePendingRequest(request.getMessage());
            if (permit == null) {
                return this.getResourceUnavailableReply(request, cacheEntry);
            }
            this.writeIndexCache.add(request.getClientId(), context.getLogIndexFuture());
            try {
                this.state.appendLog(context);
            }
            catch (StateMachineException e) {
                RaftClientReply exceptionReply = this.newExceptionReply(request, e);
                cacheEntry.failWithReply(exceptionReply);
                if (e.leaderShouldStepDown() && this.getInfo().isLeader()) {
                    leaderState.submitStepDownEvent(LeaderState.StepDownReason.STATE_MACHINE_EXCEPTION);
                }
                return CompletableFuture.completedFuture(exceptionReply);
            }
            pending = leaderState.addPendingRequest(permit, request, context);
            if (pending == null) {
                return cacheEntry.failWithException(new ResourceUnavailableException(this.getMemberId() + ": Failed to add a pending write request for " + request));
            }
        }
        leaderState.notifySenders();
        return pending.getFuture();
    }

    private CompletableFuture<RaftClientReply> waitForReplication(RaftClientReply reply, RaftProtos.ReplicationLevel replication) {
        if (!reply.isSuccess()) {
            return CompletableFuture.completedFuture(reply);
        }
        RaftClientRequest.Type type = RaftClientRequest.watchRequestType(reply.getLogIndex(), replication);
        RaftClientRequest watch = RaftClientRequest.newBuilder().setServerId(reply.getServerId()).setClientId(reply.getClientId()).setGroupId(reply.getRaftGroupId()).setCallId(reply.getCallId()).setType(type).build();
        return this.watchAsync(watch).thenApply(watchReply -> this.combineReplies(reply, (RaftClientReply)watchReply));
    }

    private RaftClientReply combineReplies(RaftClientReply reply, RaftClientReply watchReply) {
        RaftClientReply combinedReply = RaftClientReply.newBuilder().setServerId(this.getMemberId()).setClientId(reply.getClientId()).setCallId(reply.getCallId()).setMessage(reply.getMessage()).setLogIndex(reply.getLogIndex()).setSuccess(watchReply.isSuccess()).setException(watchReply.getException()).setCommitInfos(watchReply.getCommitInfos()).build();
        LOG.debug("combinedReply={}", (Object)combinedReply);
        return combinedReply;
    }

    void stepDownOnJvmPause() {
        this.role.getLeaderState().ifPresent(leader -> leader.submitStepDownEvent(LeaderState.StepDownReason.JVM_PAUSE));
    }

    private RaftClientRequest filterDataStreamRaftClientRequest(RaftClientRequest request) throws InvalidProtocolBufferException {
        return !request.is(RaftProtos.RaftClientRequestProto.TypeCase.FORWARD) ? request : ClientProtoUtils.toRaftClientRequest(RaftProtos.RaftClientRequestProto.parseFrom(request.getMessage().getContent().asReadOnlyByteBuffer()));
    }

    <REPLY> CompletableFuture<REPLY> executeSubmitServerRequestAsync(CheckedSupplier<CompletableFuture<REPLY>, IOException> submitFunction) {
        return CompletableFuture.supplyAsync(() -> (CompletableFuture)JavaUtils.callAsUnchecked(submitFunction, CompletionException::new), this.serverExecutor).join();
    }

    CompletableFuture<RaftClientReply> executeSubmitClientRequestAsync(RaftClientRequest request) {
        return CompletableFuture.supplyAsync(() -> JavaUtils.callAsUnchecked(() -> this.submitClientRequestAsync(request), CompletionException::new), this.clientExecutor).join();
    }

    @Override
    public CompletableFuture<RaftClientReply> submitClientRequestAsync(RaftClientRequest request) throws IOException {
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        LOG.debug("{}: receive client request({})", (Object)this.getMemberId(), (Object)request);
        Timekeeper timer = this.raftServerMetrics.getClientRequestTimer(request.getType());
        Optional<Timekeeper.Context> timerContext = Optional.ofNullable(timer).map(Timekeeper::time);
        return this.replyFuture(request).whenComplete((clientReply, exception) -> {
            timerContext.ifPresent(Timekeeper.Context::stop);
            if (exception != null || clientReply.getException() != null) {
                this.raftServerMetrics.incFailedRequestCount(request.getType());
            }
        });
    }

    private CompletableFuture<RaftClientReply> replyFuture(RaftClientRequest request) throws IOException {
        this.retryCache.invalidateRepliedRequests(request);
        RaftProtos.RaftClientRequestProto.TypeCase type = request.getType().getTypeCase();
        switch (type) {
            case STALEREAD: {
                return this.staleReadAsync(request);
            }
            case READ: {
                return this.readAsync(request);
            }
            case WATCH: {
                return this.watchAsync(request);
            }
            case MESSAGESTREAM: {
                return this.messageStreamAsync(request);
            }
            case WRITE: 
            case FORWARD: {
                return this.writeAsync(request);
            }
        }
        throw new IllegalStateException("Unexpected request type: " + type + ", request=" + request);
    }

    private CompletableFuture<RaftClientReply> writeAsync(RaftClientRequest request) throws IOException {
        RaftProtos.ReplicationLevel replication;
        CompletableFuture<RaftClientReply> future = this.writeAsyncImpl(request);
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE) && (replication = request.getType().getWrite().getReplication()) != RaftProtos.ReplicationLevel.MAJORITY) {
            return future.thenCompose(r -> this.waitForReplication((RaftClientReply)r, replication));
        }
        return future;
    }

    private CompletableFuture<RaftClientReply> writeAsyncImpl(RaftClientRequest request) throws IOException {
        CompletableFuture<RaftClientReply> reply = this.checkLeaderState(request);
        if (reply != null) {
            return reply;
        }
        RetryCacheImpl.CacheQueryResult queryResult = this.retryCache.queryCache(request);
        RetryCacheImpl.CacheEntry cacheEntry = queryResult.getEntry();
        if (queryResult.isRetry()) {
            return cacheEntry.getReplyFuture();
        }
        TransactionContextImpl context = (TransactionContextImpl)this.stateMachine.startTransaction(this.filterDataStreamRaftClientRequest(request));
        if (context.getException() != null) {
            StateMachineException e = new StateMachineException(this.getMemberId(), (Throwable)context.getException());
            RaftClientReply exceptionReply = this.newExceptionReply(request, e);
            cacheEntry.failWithReply(exceptionReply);
            return CompletableFuture.completedFuture(exceptionReply);
        }
        return this.appendTransaction(request, context, cacheEntry);
    }

    private CompletableFuture<RaftClientReply> watchAsync(RaftClientRequest request) {
        CompletableFuture<RaftClientReply> reply = this.checkLeaderState(request);
        if (reply != null) {
            return reply;
        }
        return this.role.getLeaderState().map(ls -> ls.addWatchRequest(request)).orElseGet(() -> CompletableFuture.completedFuture(this.newExceptionReply(request, this.generateNotLeaderException())));
    }

    private CompletableFuture<RaftClientReply> staleReadAsync(RaftClientRequest request) {
        long minIndex = request.getType().getStaleRead().getMinIndex();
        long commitIndex = this.state.getLog().getLastCommittedIndex();
        LOG.debug("{}: minIndex={}, commitIndex={}", this.getMemberId(), minIndex, commitIndex);
        if (commitIndex < minIndex) {
            StaleReadException e = new StaleReadException("Unable to serve stale-read due to server commit index = " + commitIndex + " < min = " + minIndex);
            return CompletableFuture.completedFuture(this.newExceptionReply(request, new StateMachineException(this.getMemberId(), (Throwable)e)));
        }
        return this.processQueryFuture(this.stateMachine.queryStale(request.getMessage(), minIndex), request);
    }

    ReadRequests getReadRequests() {
        return this.getState().getReadRequests();
    }

    private CompletableFuture<RaftProtos.ReadIndexReplyProto> sendReadIndexAsync(RaftClientRequest clientRequest) {
        RaftPeerId leaderId = this.getInfo().getLeaderId();
        if (leaderId == null) {
            return JavaUtils.completeExceptionally(new ReadIndexException(this.getMemberId() + ": Leader is unknown."));
        }
        RaftProtos.ReadIndexRequestProto request = ServerProtoUtils.toReadIndexRequestProto(clientRequest, this.getMemberId(), leaderId);
        try {
            return this.getServerRpc().async().readIndexAsync(request);
        }
        catch (IOException e) {
            return JavaUtils.completeExceptionally(e);
        }
    }

    private CompletableFuture<Long> getReadIndex(RaftClientRequest request, LeaderStateImpl leader) {
        return this.writeIndexCache.getWriteIndexFuture(request).thenCompose(leader::getReadIndex);
    }

    private CompletableFuture<RaftClientReply> readAsync(RaftClientRequest request) {
        if (request.getType().getRead().getPreferNonLinearizable() || this.readOption == RaftServerConfigKeys.Read.Option.DEFAULT) {
            CompletableFuture<RaftClientReply> reply2 = this.checkLeaderState(request);
            if (reply2 != null) {
                return reply2;
            }
            return this.queryStateMachine(request);
        }
        if (this.readOption == RaftServerConfigKeys.Read.Option.LINEARIZABLE) {
            LeaderStateImpl leader = this.role.getLeaderState().orElse(null);
            CompletionStage<Long> replyFuture = leader != null ? this.getReadIndex(request, leader) : this.sendReadIndexAsync(request).thenApply(reply -> {
                if (reply.getServerReply().getSuccess()) {
                    return reply.getReadIndex();
                }
                throw new CompletionException(new ReadIndexException(this.getId() + ": Failed to get read index from the leader: " + reply));
            });
            return ((CompletableFuture)((CompletableFuture)replyFuture.thenCompose(readIndex -> this.getReadRequests().waitToAdvance((long)readIndex))).thenCompose(readIndex -> this.queryStateMachine(request))).exceptionally(e -> this.readException2Reply(request, (Throwable)e));
        }
        throw new IllegalStateException("Unexpected read option: " + (Object)((Object)this.readOption));
    }

    private RaftClientReply readException2Reply(RaftClientRequest request, Throwable e) {
        if ((e = JavaUtils.unwrapCompletionException(e)) instanceof StateMachineException) {
            return this.newExceptionReply(request, (StateMachineException)e);
        }
        if (e instanceof ReadException) {
            return this.newExceptionReply(request, (ReadException)e);
        }
        if (e instanceof ReadIndexException) {
            return this.newExceptionReply(request, (ReadIndexException)e);
        }
        throw new CompletionException(e);
    }

    private CompletableFuture<RaftClientReply> messageStreamAsync(RaftClientRequest request) throws IOException {
        CompletableFuture<RaftClientReply> reply = this.checkLeaderState(request);
        if (reply != null) {
            return reply;
        }
        if (request.getType().getMessageStream().getEndOfRequest()) {
            CompletableFuture<RaftClientRequest> f = this.streamEndOfRequestAsync(request);
            if (f.isCompletedExceptionally()) {
                return f.thenApply(r -> null);
            }
            return this.replyFuture(f.join());
        }
        return this.role.getLeaderState().map(ls -> ls.streamAsync(request)).orElseGet(() -> CompletableFuture.completedFuture(this.newExceptionReply(request, this.generateNotLeaderException())));
    }

    private CompletableFuture<RaftClientRequest> streamEndOfRequestAsync(RaftClientRequest request) {
        return this.role.getLeaderState().map(ls -> ls.streamEndOfRequestAsync(request)).orElse(null);
    }

    CompletableFuture<RaftClientReply> queryStateMachine(RaftClientRequest request) {
        return this.processQueryFuture(this.stateMachine.query(request.getMessage()), request);
    }

    CompletableFuture<RaftClientReply> processQueryFuture(CompletableFuture<Message> queryFuture, RaftClientRequest request) {
        return ((CompletableFuture)queryFuture.thenApply(r -> this.newReplyBuilder(request).setSuccess().setMessage((Message)r).build())).exceptionally(e -> {
            if ((e = JavaUtils.unwrapCompletionException(e)) instanceof StateMachineException) {
                return this.newExceptionReply(request, (StateMachineException)e);
            }
            throw new CompletionException((Throwable)e);
        });
    }

    @Override
    public RaftClientReply submitClientRequest(RaftClientRequest request) throws IOException {
        return this.waitForReply(request, this.submitClientRequestAsync(request));
    }

    RaftClientReply waitForReply(RaftClientRequest request, CompletableFuture<RaftClientReply> future) throws IOException {
        return RaftServerImpl.waitForReply(this.getMemberId(), request, future, e -> this.newExceptionReply(request, (RaftException)e));
    }

    static <REPLY extends RaftClientReply> REPLY waitForReply(Object id, RaftClientRequest request, CompletableFuture<REPLY> future, Function<RaftException, REPLY> exceptionReply) throws IOException {
        try {
            return (REPLY)((RaftClientReply)future.get());
        }
        catch (InterruptedException e) {
            String s2 = id + ": Interrupted when waiting for reply, request=" + request;
            LOG.info(s2, e);
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException(s2, e);
        }
        catch (ExecutionException e) {
            RaftClientReply reply;
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new IOException(e);
            }
            if ((cause instanceof NotLeaderException || cause instanceof StateMachineException) && (reply = (RaftClientReply)exceptionReply.apply((RaftException)cause)) != null) {
                return (REPLY)reply;
            }
            throw IOUtils.asIOException(cause);
        }
    }

    RaftClientReply transferLeadership(TransferLeadershipRequest request) throws IOException {
        return this.waitForReply(request, this.transferLeadershipAsync(request));
    }

    private CompletableFuture<RaftClientReply> logAndReturnTransferLeadershipFail(TransferLeadershipRequest request, String msg) {
        LOG.warn(msg);
        return CompletableFuture.completedFuture(this.newExceptionReply(request, new TransferLeadershipException(msg)));
    }

    boolean isSteppingDown() {
        return this.transferLeadership.isSteppingDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<RaftClientReply> transferLeadershipAsync(TransferLeadershipRequest request) throws IOException {
        if (request.getNewLeader() == null) {
            return this.stepDownLeaderAsync(request);
        }
        LOG.info("{}: receive transferLeadership {}", (Object)this.getMemberId(), (Object)request);
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        ServerImplUtils.assertGroup(this.getMemberId(), request);
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            CompletableFuture<RaftClientReply> reply = this.checkLeaderState(request);
            if (reply != null) {
                return reply;
            }
            if (this.getId().equals(request.getNewLeader())) {
                return CompletableFuture.completedFuture(this.newSuccessReply(request));
            }
            RaftConfigurationImpl conf = this.getRaftConf();
            LeaderStateImpl leaderState = this.role.getLeaderStateNonNull();
            if (!conf.isStable() || leaderState.inStagingState() || !this.state.isConfCommitted()) {
                String msg = this.getMemberId() + " refused to transfer leadership to peer " + request.getNewLeader() + " when raft reconfiguration in progress.";
                return this.logAndReturnTransferLeadershipFail(request, msg);
            }
            if (!conf.containsInConf(request.getNewLeader(), new RaftProtos.RaftPeerRole[0])) {
                String msg = this.getMemberId() + " refused to transfer leadership to peer " + request.getNewLeader() + " as it is not in " + conf;
                return this.logAndReturnTransferLeadershipFail(request, msg);
            }
            if (!conf.isHighestPriority(request.getNewLeader())) {
                String msg = this.getMemberId() + " refused to transfer leadership to peer " + request.getNewLeader() + " as it does not has highest priority in " + conf;
                return this.logAndReturnTransferLeadershipFail(request, msg);
            }
            return this.transferLeadership.start(leaderState, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<RaftClientReply> takeSnapshotAsync(SnapshotManagementRequest request) throws IOException {
        LOG.info("{}: takeSnapshotAsync {}", (Object)this.getMemberId(), (Object)request);
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        ServerImplUtils.assertGroup(this.getMemberId(), request);
        Objects.requireNonNull(request.getCreate(), "create == null");
        long creationGap = request.getCreate().getCreationGap();
        long minGapValue = creationGap > 0L ? creationGap : RaftServerConfigKeys.Snapshot.creationGap(this.proxy.getProperties());
        long lastSnapshotIndex = Optional.ofNullable(this.stateMachine.getLatestSnapshot()).map(SnapshotInfo::getIndex).orElse(0L);
        if (this.state.getLastAppliedIndex() - lastSnapshotIndex < minGapValue) {
            return CompletableFuture.completedFuture(this.newSuccessReply(request, lastSnapshotIndex));
        }
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            long installSnapshot = this.snapshotInstallationHandler.getInProgressInstallSnapshotIndex();
            if (installSnapshot != -1L) {
                String msg = String.format("%s: Failed do snapshot as snapshot (%s) installation is in progress", this.getMemberId(), installSnapshot);
                LOG.warn(msg);
                return CompletableFuture.completedFuture(this.newExceptionReply(request, new RaftException(msg)));
            }
            return this.snapshotRequestHandler.takingSnapshotAsync(request);
        }
    }

    SnapshotManagementRequestHandler getSnapshotRequestHandler() {
        return this.snapshotRequestHandler;
    }

    CompletableFuture<RaftClientReply> leaderElectionManagementAsync(LeaderElectionManagementRequest request) throws IOException {
        LOG.info("{} receive leaderElectionManagement request {}", (Object)this.getMemberId(), (Object)request);
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        ServerImplUtils.assertGroup(this.getMemberId(), request);
        LeaderElectionManagementRequest.Pause pause = request.getPause();
        if (pause != null) {
            this.getRole().setLeaderElectionPause(true);
            return CompletableFuture.completedFuture(this.newSuccessReply(request));
        }
        LeaderElectionManagementRequest.Resume resume = request.getResume();
        if (resume != null) {
            this.getRole().setLeaderElectionPause(false);
            return CompletableFuture.completedFuture(this.newSuccessReply(request));
        }
        return JavaUtils.completeExceptionally(new UnsupportedOperationException(this.getId() + ": Request not supported " + request));
    }

    CompletableFuture<RaftClientReply> stepDownLeaderAsync(TransferLeadershipRequest request) throws IOException {
        LOG.info("{} receive stepDown leader request {}", (Object)this.getMemberId(), (Object)request);
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        ServerImplUtils.assertGroup(this.getMemberId(), request);
        return this.role.getLeaderState().map(leader -> leader.submitStepDownRequestAsync(request)).orElseGet(() -> CompletableFuture.completedFuture(this.newExceptionReply(request, this.generateNotLeaderException())));
    }

    public RaftClientReply setConfiguration(SetConfigurationRequest request) throws IOException {
        return this.waitForReply(request, this.setConfigurationAsync(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompletableFuture<RaftClientReply> setConfigurationAsync(SetConfigurationRequest request) throws IOException {
        LOG.info("{}: receive setConfiguration {}", (Object)this.getMemberId(), (Object)request);
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        ServerImplUtils.assertGroup(this.getMemberId(), request);
        CompletableFuture<RaftClientReply> reply = this.checkLeaderState(request);
        if (reply != null) {
            return reply;
        }
        SetConfigurationRequest.Arguments arguments = request.getArguments();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            List<RaftPeer> listenersInNewConf;
            List<RaftPeer> serversInNewConf;
            reply = this.checkLeaderState(request);
            if (reply != null) {
                return reply;
            }
            RaftConfigurationImpl current = this.getRaftConf();
            LeaderStateImpl leaderState = this.role.getLeaderStateNonNull();
            if (!current.isStable() || leaderState.inStagingState() || !this.state.isConfCommitted()) {
                throw new ReconfigurationInProgressException("Reconfiguration is already in progress: " + current);
            }
            if (arguments.getMode() == SetConfigurationRequest.Mode.ADD) {
                serversInNewConf = RaftServerImpl.add(RaftProtos.RaftPeerRole.FOLLOWER, current, arguments);
                listenersInNewConf = RaftServerImpl.add(RaftProtos.RaftPeerRole.LISTENER, current, arguments);
            } else if (arguments.getMode() == SetConfigurationRequest.Mode.COMPARE_AND_SET) {
                Comparator<RaftPeer> comparator = Comparator.comparing(RaftPeer::getId, Comparator.comparing(RaftPeerId::toString));
                if (!CollectionUtils.equalsIgnoreOrder(arguments.getServersInCurrentConf(), current.getAllPeers(RaftProtos.RaftPeerRole.FOLLOWER), comparator) || !CollectionUtils.equalsIgnoreOrder(arguments.getListenersInCurrentConf(), current.getAllPeers(RaftProtos.RaftPeerRole.LISTENER), comparator)) throw new SetConfigurationException("Failed to set configuration: current configuration " + current + " is different than the request " + request);
                serversInNewConf = arguments.getPeersInNewConf(RaftProtos.RaftPeerRole.FOLLOWER);
                listenersInNewConf = arguments.getPeersInNewConf(RaftProtos.RaftPeerRole.LISTENER);
            } else {
                serversInNewConf = arguments.getPeersInNewConf(RaftProtos.RaftPeerRole.FOLLOWER);
                listenersInNewConf = arguments.getPeersInNewConf(RaftProtos.RaftPeerRole.LISTENER);
            }
            if (current.hasNoChange(serversInNewConf, listenersInNewConf)) {
                PendingRequest pending = new PendingRequest(request);
                pending.setReply(this.newSuccessReply(request));
                return pending.getFuture();
            }
            if (current.changeMajority(serversInNewConf)) {
                if (!this.memberMajorityAddEnabled) {
                    throw new SetConfigurationException("Failed to set configuration: request " + request + " changes a majority set of the current configuration " + current);
                }
                LOG.warn("Try to add/replace a majority of servers in a single setConf: {}", (Object)request);
            }
            this.getRaftServer().addRaftPeers(serversInNewConf);
            this.getRaftServer().addRaftPeers(listenersInNewConf);
            PendingRequest pending = leaderState.startSetConfiguration(request, serversInNewConf);
            return pending.getFuture();
        }
    }

    static List<RaftPeer> add(RaftProtos.RaftPeerRole role, RaftConfigurationImpl conf, SetConfigurationRequest.Arguments args) {
        Map inConfs = conf.getAllPeers(role).stream().collect(Collectors.toMap(RaftPeer::getId, Function.identity()));
        List<RaftPeer> toAdds = args.getPeersInNewConf(role);
        toAdds.stream().map(RaftPeer::getId).forEach(inConfs::remove);
        return Stream.concat(toAdds.stream(), inConfs.values().stream()).collect(Collectors.toList());
    }

    private boolean shouldSendShutdown(RaftPeerId candidateId, TermIndex candidateLastEntry) {
        return this.getInfo().isLeader() && this.getRaftConf().isStable() && this.getState().isConfCommitted() && !this.getRaftConf().containsInConf(candidateId, new RaftProtos.RaftPeerRole[0]) && candidateLastEntry.getIndex() < this.getRaftConf().getLogEntryIndex() && this.role.getLeaderState().map(ls -> !ls.isBootStrappingPeer(candidateId)).orElse(false) != false;
    }

    @Override
    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto r) throws IOException {
        RaftProtos.RaftRpcRequestProto request = r.getServerRequest();
        return this.requestVote(r.getPreVote() ? LeaderElection.Phase.PRE_VOTE : LeaderElection.Phase.ELECTION, RaftPeerId.valueOf(request.getRequestorId()), ProtoUtils.toRaftGroupId(request.getRaftGroupId()), r.getCandidateTerm(), TermIndex.valueOf(r.getCandidateLastEntry()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.RequestVoteReplyProto requestVote(LeaderElection.Phase phase, RaftPeerId candidateId, RaftGroupId candidateGroupId, long candidateTerm, TermIndex candidateLastEntry) throws IOException {
        RaftProtos.RequestVoteReplyProto reply;
        CodeInjectionForTesting.execute(REQUEST_VOTE, this.getId(), candidateId, candidateTerm, candidateLastEntry);
        LOG.info("{}: receive requestVote({}, {}, {}, {}, {})", new Object[]{this.getMemberId(), phase, candidateId, candidateGroupId, candidateTerm, candidateLastEntry});
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        ServerImplUtils.assertGroup(this.getMemberId(), candidateId, candidateGroupId);
        boolean shouldShutdown = false;
        CompletableFuture<Void> future = null;
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            this.assertLifeCycleState(LifeCycle.States.RUNNING);
            VoteContext context = new VoteContext(this, phase, candidateId);
            RaftPeer candidate = context.recognizeCandidate(candidateTerm);
            boolean voteGranted = context.decideVote(candidate, candidateLastEntry);
            if (candidate != null && phase == LeaderElection.Phase.ELECTION) {
                AtomicBoolean termUpdated = new AtomicBoolean();
                future = this.changeToFollower(candidateTerm, true, false, "candidate:" + candidateId, termUpdated);
                if (voteGranted) {
                    this.state.grantVote(candidate.getId());
                }
                if (termUpdated.get() || voteGranted) {
                    this.state.persistMetadata();
                }
            }
            if (voteGranted) {
                this.role.getFollowerState().ifPresent(fs -> fs.updateLastRpcTime(FollowerState.UpdateType.REQUEST_VOTE));
            } else if (this.shouldSendShutdown(candidateId, candidateLastEntry)) {
                shouldShutdown = true;
            }
            reply = ServerProtoUtils.toRequestVoteReplyProto(candidateId, this.getMemberId(), voteGranted, this.state.getCurrentTerm(), shouldShutdown, this.state.getLastEntry());
            if (LOG.isInfoEnabled()) {
                LOG.info("{} replies to {} vote request: {}. Peer's state: {}", new Object[]{this.getMemberId(), phase, ServerStringUtils.toRequestVoteReplyString(reply), this.state});
            }
        }
        if (future != null) {
            future.join();
        }
        return reply;
    }

    @Override
    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto r) throws IOException {
        try {
            return this.appendEntriesAsync(r).join();
        }
        catch (CompletionException e) {
            throw IOUtils.asIOException(JavaUtils.unwrapCompletionException(e));
        }
    }

    @Override
    public CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftProtos.AppendEntriesRequestProto r) throws IOException {
        RaftProtos.RaftRpcRequestProto request = r.getServerRequest();
        TermIndex previous = r.hasPreviousLog() ? TermIndex.valueOf(r.getPreviousLog()) : null;
        try {
            RaftPeerId leaderId = RaftPeerId.valueOf(request.getRequestorId());
            RaftGroupId leaderGroupId = ProtoUtils.toRaftGroupId(request.getRaftGroupId());
            CodeInjectionForTesting.execute(APPEND_ENTRIES, this.getId(), leaderId, previous, r);
            this.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
            if (!this.startComplete.get()) {
                throw new ServerNotReadyException(this.getMemberId() + ": The server role is not yet initialized.");
            }
            ServerImplUtils.assertGroup(this.getMemberId(), leaderId, leaderGroupId);
            ServerImplUtils.assertEntries(r, previous, this.state);
            return this.appendEntriesAsync(leaderId, request.getCallId(), previous, r);
        }
        catch (Exception t2) {
            Object[] objectArray = new Object[3];
            objectArray[0] = this.getMemberId();
            objectArray[1] = ServerStringUtils.toAppendEntriesRequestString(r, this.stateMachine::toStateMachineLogEntryString);
            objectArray[2] = t2;
            LOG.error("{}: Failed appendEntries* {}", objectArray);
            throw IOUtils.asIOException(t2);
        }
    }

    @Override
    public CompletableFuture<RaftProtos.ReadIndexReplyProto> readIndexAsync(RaftProtos.ReadIndexRequestProto request) throws IOException {
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        RaftPeerId peerId = RaftPeerId.valueOf(request.getServerRequest().getRequestorId());
        LeaderStateImpl leader = this.role.getLeaderState().orElse(null);
        if (leader == null) {
            return CompletableFuture.completedFuture(ServerProtoUtils.toReadIndexReplyProto(peerId, this.getMemberId()));
        }
        return ((CompletableFuture)this.getReadIndex(ClientProtoUtils.toRaftClientRequest(request.getClientRequest()), leader).thenApply(index -> ServerProtoUtils.toReadIndexReplyProto(peerId, this.getMemberId(), true, index))).exceptionally(throwable -> ServerProtoUtils.toReadIndexReplyProto(peerId, this.getMemberId()));
    }

    static void logAppendEntries(boolean isHeartbeat, Supplier<String> message) {
        if (isHeartbeat) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("HEARTBEAT: {}", (Object)message.get());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(message.get());
        }
    }

    Optional<FollowerState> updateLastRpcTime(FollowerState.UpdateType updateType) {
        Optional<FollowerState> fs = this.role.getFollowerState();
        if (fs.isPresent() && this.lifeCycle.getCurrentState().isRunning()) {
            fs.get().updateLastRpcTime(updateType);
            return fs;
        }
        return Optional.empty();
    }

    private long updateCommitInfoCache() {
        return this.commitInfoCache.update(this.getId(), this.state.getLog().getLastCommittedIndex());
    }

    ExecutorService getServerExecutor() {
        return this.serverExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftPeerId leaderId, long callId, TermIndex previous, RaftProtos.AppendEntriesRequestProto proto) throws IOException {
        long installedIndex;
        Optional<FollowerState> followerState;
        CompletableFuture<Void> future;
        long currentTerm;
        List<RaftProtos.LogEntryProto> entries = proto.getEntriesList();
        boolean isHeartbeat = entries.isEmpty();
        RaftServerImpl.logAppendEntries(isHeartbeat, () -> this.getMemberId() + ": appendEntries* " + ServerStringUtils.toAppendEntriesRequestString(proto, this.stateMachine::toStateMachineLogEntryString));
        long leaderTerm = proto.getLeaderTerm();
        long followerCommit = this.state.getLog().getLastCommittedIndex();
        Timekeeper.Context timer = this.raftServerMetrics.getFollowerAppendEntryTimer(isHeartbeat).time();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            this.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
            currentTerm = this.state.getCurrentTerm();
            boolean recognized = this.state.recognizeLeader((Object)RaftServerProtocol.Op.APPEND_ENTRIES, leaderId, leaderTerm);
            if (!recognized) {
                return CompletableFuture.completedFuture(ServerProtoUtils.toAppendEntriesReplyProto(leaderId, this.getMemberId(), currentTerm, followerCommit, this.state.getNextIndex(), RaftProtos.AppendEntriesReplyProto.AppendResult.NOT_LEADER, callId, -1L, isHeartbeat));
            }
            try {
                future = this.changeToFollowerAndPersistMetadata(leaderTerm, true, (Object)RaftServerProtocol.Op.APPEND_ENTRIES);
            }
            catch (IOException e) {
                return JavaUtils.completeExceptionally(e);
            }
            this.state.setLeader(leaderId, (Object)RaftServerProtocol.Op.APPEND_ENTRIES);
            if (!proto.getInitializing() && this.lifeCycle.compareAndTransition(LifeCycle.State.STARTING, LifeCycle.State.RUNNING)) {
                this.role.startFollowerState(this, (Object)RaftServerProtocol.Op.APPEND_ENTRIES);
            }
            followerState = this.updateLastRpcTime(FollowerState.UpdateType.APPEND_START);
            long inconsistencyReplyNextIndex = this.checkInconsistentAppendEntries(previous, entries);
            if (inconsistencyReplyNextIndex > -1L) {
                RaftProtos.AppendEntriesReplyProto reply = ServerProtoUtils.toAppendEntriesReplyProto(leaderId, this.getMemberId(), currentTerm, followerCommit, inconsistencyReplyNextIndex, RaftProtos.AppendEntriesReplyProto.AppendResult.INCONSISTENCY, callId, -1L, isHeartbeat);
                LOG.info("{}: appendEntries* reply {}", (Object)this.getMemberId(), (Object)ServerStringUtils.toAppendEntriesReplyString(reply));
                followerState.ifPresent(fs -> fs.updateLastRpcTime(FollowerState.UpdateType.APPEND_COMPLETE));
                return future.thenApply(dummy -> reply);
            }
            this.state.updateConfiguration(entries);
        }
        future.join();
        CompletableFuture<Object> appendLog = entries.isEmpty() ? CompletableFuture.completedFuture(null) : this.appendLog(entries);
        proto.getCommitInfosList().forEach(this.commitInfoCache::update);
        CodeInjectionForTesting.execute(LOG_SYNC, this.getId(), null, new Object[0]);
        if (!isHeartbeat && (installedIndex = this.snapshotInstallationHandler.getInstalledIndex()) >= 0L) {
            LOG.info("{}: Follower has completed install the snapshot {}.", (Object)this, (Object)installedIndex);
            this.stateMachine.event().notifySnapshotInstalled(RaftProtos.InstallSnapshotResult.SUCCESS, installedIndex, this.getPeer());
        }
        long commitIndex = ServerImplUtils.effectiveCommitIndex(proto.getLeaderCommit(), previous, entries.size());
        long matchIndex = isHeartbeat ? -1L : entries.get(entries.size() - 1).getIndex();
        return ((CompletableFuture)appendLog.whenCompleteAsync((r, t2) -> {
            followerState.ifPresent(fs -> fs.updateLastRpcTime(FollowerState.UpdateType.APPEND_COMPLETE));
            timer.stop();
        }, (Executor)this.getServerExecutor())).thenApply(v -> {
            boolean updated = this.state.updateCommitIndex(commitIndex, currentTerm, false);
            if (updated) {
                this.updateCommitInfoCache();
            }
            long nextIndex = isHeartbeat ? this.state.getNextIndex() : matchIndex + 1L;
            RaftProtos.AppendEntriesReplyProto reply = ServerProtoUtils.toAppendEntriesReplyProto(leaderId, this.getMemberId(), currentTerm, updated ? commitIndex : this.state.getLog().getLastCommittedIndex(), nextIndex, RaftProtos.AppendEntriesReplyProto.AppendResult.SUCCESS, callId, matchIndex, isHeartbeat);
            RaftServerImpl.logAppendEntries(isHeartbeat, () -> this.getMemberId() + ": appendEntries* reply " + ServerStringUtils.toAppendEntriesReplyString(reply));
            return reply;
        });
    }

    private CompletableFuture<Void> appendLog(List<RaftProtos.LogEntryProto> entries) {
        List<ServerImplUtils.ConsecutiveIndices> entriesTermIndices = ServerImplUtils.ConsecutiveIndices.convert(entries);
        if (!this.appendLogTermIndices.append(entriesTermIndices)) {
            return this.appendLogFuture.get();
        }
        return this.appendLogFuture.updateAndGet(f -> f.thenComposeAsync(ignored -> JavaUtils.allOf(this.state.getLog().append(entries)), (Executor)this.serverExecutor)).whenComplete((v, e) -> this.appendLogTermIndices.removeExisting(entriesTermIndices));
    }

    private long checkInconsistentAppendEntries(TermIndex previous, List<RaftProtos.LogEntryProto> entries) {
        long installSnapshot = this.snapshotInstallationHandler.getInProgressInstallSnapshotIndex();
        if (installSnapshot != -1L) {
            LOG.info("{}: Failed appendEntries as snapshot ({}) installation is in progress", (Object)this.getMemberId(), (Object)installSnapshot);
            return this.state.getNextIndex();
        }
        if (entries != null && !entries.isEmpty()) {
            long commitIndex;
            long firstEntryIndex = entries.get(0).getIndex();
            long snapshotIndex = this.state.getSnapshotIndex();
            long nextIndex = Math.max(snapshotIndex, commitIndex = this.state.getLog().getLastCommittedIndex());
            if (nextIndex > -1L && nextIndex >= firstEntryIndex) {
                LOG.info("{}: Failed appendEntries as the first entry (index {}) already exists (snapshotIndex: {}, commitIndex: {})", this.getMemberId(), firstEntryIndex, snapshotIndex, commitIndex);
                return nextIndex + 1L;
            }
        }
        if (previous != null && !this.appendLogTermIndices.contains(previous) && !this.state.containsTermIndex(previous)) {
            long replyNextIndex = Math.min(this.state.getNextIndex(), previous.getIndex());
            LOG.info("{}: Failed appendEntries as previous log entry ({}) is not found", (Object)this.getMemberId(), (Object)previous);
            return replyNextIndex;
        }
        return -1L;
    }

    @Override
    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        return this.snapshotInstallationHandler.installSnapshot(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pause() {
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            if (!this.lifeCycle.compareAndTransition(LifeCycle.State.RUNNING, LifeCycle.State.PAUSING)) {
                return false;
            }
            this.stateMachine.pause();
            this.lifeCycle.compareAndTransition(LifeCycle.State.PAUSING, LifeCycle.State.PAUSED);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resume() throws IOException {
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            if (!this.lifeCycle.compareAndTransition(LifeCycle.State.PAUSED, LifeCycle.State.STARTING)) {
                return false;
            }
            try {
                this.stateMachine.reinitialize();
            }
            catch (IOException e) {
                LOG.warn("Failed to reinitialize statemachine: {}", (Object)this.stateMachine);
                this.lifeCycle.compareAndTransition(LifeCycle.State.STARTING, LifeCycle.State.EXCEPTION);
                throw e;
            }
            this.lifeCycle.compareAndTransition(LifeCycle.State.STARTING, LifeCycle.State.RUNNING);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RaftProtos.StartLeaderElectionReplyProto startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request) throws IOException {
        RaftProtos.RaftRpcRequestProto r = request.getServerRequest();
        RaftPeerId leaderId = RaftPeerId.valueOf(r.getRequestorId());
        RaftGroupId leaderGroupId = ProtoUtils.toRaftGroupId(r.getRaftGroupId());
        CodeInjectionForTesting.execute(START_LEADER_ELECTION, this.getId(), leaderId, request);
        if (!request.hasLeaderLastEntry()) {
            LOG.warn("{}: leaderLastEntry is missing in {}", (Object)this.getMemberId(), (Object)request);
            return ServerProtoUtils.toStartLeaderElectionReplyProto(leaderId, this.getMemberId(), false);
        }
        TermIndex leaderLastEntry = TermIndex.valueOf(request.getLeaderLastEntry());
        LOG.debug("{}: receive startLeaderElection from {} with lastEntry {}", this.getMemberId(), leaderId, leaderLastEntry);
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        ServerImplUtils.assertGroup(this.getMemberId(), leaderId, leaderGroupId);
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            this.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
            boolean recognized = this.state.recognizeLeader("startLeaderElection", leaderId, leaderLastEntry.getTerm());
            if (!recognized) {
                return ServerProtoUtils.toStartLeaderElectionReplyProto(leaderId, this.getMemberId(), false);
            }
            if (!this.getInfo().isFollower()) {
                LOG.warn("{} refused StartLeaderElectionRequest from {}, because role is:{}", this.getMemberId(), leaderId, this.role.getCurrentRole());
                return ServerProtoUtils.toStartLeaderElectionReplyProto(leaderId, this.getMemberId(), false);
            }
            if (ServerState.compareLog(this.state.getLastEntry(), leaderLastEntry) < 0) {
                LOG.warn("{} refused StartLeaderElectionRequest from {}, because lastEntry:{} less than leaderEntry:{}", this.getMemberId(), leaderId, leaderLastEntry, this.state.getLastEntry());
                return ServerProtoUtils.toStartLeaderElectionReplyProto(leaderId, this.getMemberId(), false);
            }
            this.changeToCandidate(true);
            return ServerProtoUtils.toStartLeaderElectionReplyProto(leaderId, this.getMemberId(), true);
        }
    }

    void submitUpdateCommitEvent() {
        this.role.getLeaderState().ifPresent(LeaderStateImpl::submitUpdateCommitEvent);
    }

    private CompletableFuture<Message> replyPendingRequest(ClientInvocationId invocationId, TermIndex termIndex, CompletableFuture<Message> stateMachineFuture) {
        RetryCacheImpl.CacheEntry cacheEntry = this.retryCache.getOrCreateEntry(invocationId);
        Objects.requireNonNull(cacheEntry, "cacheEntry == null");
        if (this.getInfo().isLeader() && cacheEntry.isCompletedNormally()) {
            LOG.warn("{} retry cache entry of leader should be pending: {}", (Object)this, (Object)cacheEntry);
        }
        if (cacheEntry.isFailed()) {
            this.retryCache.refreshEntry(new RetryCacheImpl.CacheEntry(cacheEntry.getKey()));
        }
        return stateMachineFuture.whenComplete((reply, exception) -> {
            RaftClientReply r;
            this.getTransactionManager().remove(termIndex);
            RaftClientReply.Builder b = this.newReplyBuilder(invocationId, termIndex.getIndex());
            if (exception == null) {
                r = b.setSuccess().setMessage((Message)reply).build();
            } else {
                StateMachineException e = new StateMachineException(this.getMemberId(), (Throwable)exception);
                r = b.setException(e).build();
            }
            this.role.getLeaderState().ifPresent(leader -> leader.replyPendingRequest(termIndex, r));
            cacheEntry.updateResult(r);
        });
    }

    TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @VisibleForTesting
    Map<TermIndex, MemoizedSupplier<TransactionContext>> getTransactionContextMapForTesting() {
        return this.getTransactionManager().getMap();
    }

    TransactionContext getTransactionContext(RaftProtos.LogEntryProto entry, Boolean createNew) {
        TransactionContext context;
        if (!entry.hasStateMachineLogEntry()) {
            return null;
        }
        TermIndex termIndex = TermIndex.valueOf(entry);
        Optional<LeaderStateImpl> leader = this.getRole().getLeaderState();
        if (leader.isPresent() && (context = leader.get().getTransactionContext(termIndex)) != null) {
            return context;
        }
        if (!createNew.booleanValue()) {
            return this.getTransactionManager().get(termIndex);
        }
        return this.getTransactionManager().computeIfAbsent(termIndex, MemoizedSupplier.valueOf(() -> this.stateMachine.startTransaction(entry, this.getInfo().getCurrentRole())));
    }

    CompletableFuture<Message> applyLogToStateMachine(RaftProtos.LogEntryProto next) throws RaftLogIOException {
        CompletableFuture<Message> messageFuture = null;
        switch (next.getLogEntryBodyCase()) {
            case CONFIGURATIONENTRY: {
                this.state.writeRaftConfiguration(next);
                this.stateMachine.event().notifyConfigurationChanged(next.getTerm(), next.getIndex(), next.getConfigurationEntry());
                this.role.getLeaderState().ifPresent(leader -> leader.checkReady(next));
                break;
            }
            case STATEMACHINELOGENTRY: {
                TransactionContext trx = this.getTransactionContext(next, true);
                Objects.requireNonNull(trx, "trx == null");
                ClientInvocationId invocationId = ClientInvocationId.valueOf(next.getStateMachineLogEntry());
                this.writeIndexCache.add(invocationId.getClientId(), ((TransactionContextImpl)trx).getLogIndexFuture());
                try {
                    trx = this.stateMachine.applyTransactionSerial(trx);
                    CompletableFuture<Message> stateMachineFuture = this.stateMachine.applyTransaction(trx);
                    messageFuture = this.replyPendingRequest(invocationId, TermIndex.valueOf(next), stateMachineFuture);
                    break;
                }
                catch (Exception e) {
                    throw new RaftLogIOException(e);
                }
            }
            case METADATAENTRY: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected LogEntryBodyCase " + next.getLogEntryBodyCase() + ", next=" + next);
            }
        }
        if (next.getLogEntryBodyCase() != RaftProtos.LogEntryProto.LogEntryBodyCase.STATEMACHINELOGENTRY) {
            this.stateMachine.event().notifyTermIndexUpdated(next.getTerm(), next.getIndex());
        }
        return messageFuture;
    }

    void notifyTruncatedLogEntry(RaftProtos.LogEntryProto logEntry) {
        Optional.ofNullable(this.getState()).ifPresent(s2 -> s2.truncate(logEntry.getIndex()));
        if (logEntry.hasStateMachineLogEntry()) {
            this.getTransactionManager().remove(TermIndex.valueOf(logEntry));
            ClientInvocationId invocationId = ClientInvocationId.valueOf(logEntry.getStateMachineLogEntry());
            RetryCacheImpl.CacheEntry cacheEntry = this.getRetryCache().getIfPresent(invocationId);
            if (cacheEntry != null) {
                cacheEntry.failWithReply(this.newReplyBuilder(invocationId, logEntry.getIndex()).setException(this.generateNotLeaderException()).build());
            }
        }
    }

    LeaderElectionMetrics getLeaderElectionMetrics() {
        return this.leaderElectionMetrics;
    }

    @Override
    public RaftServerMetricsImpl getRaftServerMetrics() {
        return this.raftServerMetrics;
    }

    void onGroupLeaderElected() {
        this.transferLeadership.complete(TransferLeadership.Result.SUCCESS);
    }

    boolean isRunning() {
        return this.startComplete.get() && this.lifeCycle.getCurrentState() == LifeCycle.State.RUNNING;
    }

    class Info
    implements DivisionInfo {
        Info() {
        }

        @Override
        public RaftProtos.RaftPeerRole getCurrentRole() {
            return RaftServerImpl.this.getRole().getCurrentRole();
        }

        @Override
        public boolean isLeaderReady() {
            return RaftServerImpl.this.getRole().isLeaderReady();
        }

        @Override
        public RaftPeerId getLeaderId() {
            return RaftServerImpl.this.getState().getLeaderId();
        }

        @Override
        public LifeCycle.State getLifeCycleState() {
            return RaftServerImpl.this.lifeCycle.getCurrentState();
        }

        @Override
        public RaftProtos.RoleInfoProto getRoleInfoProto() {
            return RaftServerImpl.this.getRoleInfoProto();
        }

        @Override
        public long getCurrentTerm() {
            return RaftServerImpl.this.getState().getCurrentTerm();
        }

        @Override
        public long getLastAppliedIndex() {
            return RaftServerImpl.this.getState().getLastAppliedIndex();
        }

        @Override
        public long[] getFollowerNextIndices() {
            return RaftServerImpl.this.role.getLeaderState().filter(leader -> this.isLeader()).map(LeaderStateImpl::getFollowerNextIndices).orElse(null);
        }

        @Override
        public long[] getFollowerMatchIndices() {
            return RaftServerImpl.this.role.getLeaderState().filter(leader -> this.isLeader()).map(LeaderStateImpl::getFollowerMatchIndices).orElse(null);
        }
    }
}

