/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ratis.client.ClientFactory;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.grpc.client.GrpcClientRpc;
import org.apache.ratis.grpc.server.GrpcLogAppender;
import org.apache.ratis.grpc.server.GrpcServices;
import org.apache.ratis.grpc.server.GrpcServicesImpl;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.ServerFactory;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcFactory
implements ServerFactory,
ClientFactory {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcFactory.class);
    static final String USE_CACHE_FOR_ALL_THREADS_NAME = "useCacheForAllThreads";
    static final String USE_CACHE_FOR_ALL_THREADS_KEY = "org.apache.ratis.thirdparty.io.netty.allocator.useCacheForAllThreads";
    static final BiFunction<GrpcTlsConfig, SslContext, SslContext> BUILD_SSL_CONTEXT_FOR_SERVER;
    static final BiFunction<GrpcTlsConfig, SslContext, SslContext> BUILD_SSL_CONTEXT_FOR_CLIENT;
    private final GrpcServices.Customizer servicesCustomizer;
    private final Supplier<SslContexts> forServerSupplier;
    private final Supplier<SslContexts> forClientSupplier;

    static boolean checkPooledByteBufAllocatorUseCacheForAllThreads(Consumer<String> log) {
        boolean value = PooledByteBufAllocator.defaultUseCacheForAllThreads();
        if (value) {
            log.accept("PERFORMANCE WARNING: useCacheForAllThreads is true that may cause Netty to create a lot garbage objects and, as a result, trigger GC.\n\tIt is recommended to disable useCacheForAllThreads by setting -Dorg.apache.ratis.thirdparty.io.netty.allocator.useCacheForAllThreads=false in command line.");
        }
        return value;
    }

    public GrpcFactory(Parameters parameters) {
        this(GrpcConfigKeys.Server.servicesCustomizer(parameters), GrpcConfigKeys.TLS.conf(parameters), GrpcConfigKeys.Admin.tlsConf(parameters), GrpcConfigKeys.Client.tlsConf(parameters), GrpcConfigKeys.Server.tlsConf(parameters));
    }

    private GrpcFactory(GrpcServices.Customizer servicesCustomizer, GrpcTlsConfig tlsConfig, GrpcTlsConfig adminTlsConfig, GrpcTlsConfig clientTlsConfig, GrpcTlsConfig serverTlsConfig) {
        this.servicesCustomizer = servicesCustomizer;
        this.forServerSupplier = MemoizedSupplier.valueOf(() -> new SslContexts(tlsConfig, adminTlsConfig, clientTlsConfig, serverTlsConfig, BUILD_SSL_CONTEXT_FOR_SERVER));
        this.forClientSupplier = MemoizedSupplier.valueOf(() -> new SslContexts(tlsConfig, adminTlsConfig, clientTlsConfig, serverTlsConfig, BUILD_SSL_CONTEXT_FOR_CLIENT));
    }

    @Override
    public SupportedRpcType getRpcType() {
        return SupportedRpcType.GRPC;
    }

    @Override
    public LogAppender newLogAppender(RaftServer.Division server, LeaderState state, FollowerInfo f) {
        return new GrpcLogAppender(server, state, f);
    }

    @Override
    public GrpcServices newRaftServerRpc(RaftServer server) {
        GrpcFactory.checkPooledByteBufAllocatorUseCacheForAllThreads(LOG::info);
        SslContexts forServer = this.forServerSupplier.get();
        SslContexts forClient = this.forClientSupplier.get();
        return GrpcServicesImpl.newBuilder().setServer(server).setCustomizer(this.servicesCustomizer).setAdminSslContext(forServer.adminSslContext).setServerSslContextForServer(forServer.serverSslContext).setServerSslContextForClient(forClient.serverSslContext).setClientSslContext(forServer.clientSslContext).build();
    }

    @Override
    public GrpcClientRpc newRaftClientRpc(ClientId clientId, RaftProperties properties) {
        GrpcFactory.checkPooledByteBufAllocatorUseCacheForAllThreads(LOG::debug);
        SslContexts forClient = this.forClientSupplier.get();
        return new GrpcClientRpc(clientId, properties, forClient.adminSslContext, forClient.clientSslContext);
    }

    static {
        String value = JavaUtils.getSystemProperty(USE_CACHE_FOR_ALL_THREADS_KEY);
        if (value == null) {
            JavaUtils.setSystemProperty(USE_CACHE_FOR_ALL_THREADS_KEY, Boolean.FALSE.toString());
        }
        BUILD_SSL_CONTEXT_FOR_SERVER = (tlsConf, defaultContext) -> tlsConf == null ? defaultContext : GrpcUtil.buildSslContextForServer(tlsConf);
        BUILD_SSL_CONTEXT_FOR_CLIENT = (tlsConf, defaultContext) -> tlsConf == null ? defaultContext : GrpcUtil.buildSslContextForClient(tlsConf);
    }

    static final class SslContexts {
        private final SslContext adminSslContext;
        private final SslContext clientSslContext;
        private final SslContext serverSslContext;

        private SslContexts(GrpcTlsConfig tlsConfig, GrpcTlsConfig adminTlsConfig, GrpcTlsConfig clientTlsConfig, GrpcTlsConfig serverTlsConfig, BiFunction<GrpcTlsConfig, SslContext, SslContext> buildMethod) {
            SslContext defaultSslContext = buildMethod.apply(tlsConfig, null);
            this.adminSslContext = buildMethod.apply(adminTlsConfig, defaultSslContext);
            this.clientSslContext = buildMethod.apply(clientTlsConfig, defaultSslContext);
            this.serverSslContext = buildMethod.apply(serverTlsConfig, defaultSslContext);
        }
    }
}

