/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AtlasServerEnsemble {
    private final String[] urls;

    public AtlasServerEnsemble(String[] baseUrls) {
        Preconditions.checkArgument((baseUrls != null && baseUrls.length > 0 ? 1 : 0) != 0, (Object)"List of baseURLs cannot be null or empty.");
        for (String baseUrl : baseUrls) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)baseUrl), (Object)"Base URL cannot be null or empty.");
        }
        this.urls = baseUrls;
    }

    public boolean hasSingleInstance() {
        return this.urls.length == 1;
    }

    public String firstURL() {
        return this.urls[0];
    }

    public List<String> getMembers() {
        return Arrays.asList(this.urls);
    }
}

