/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlasrest;

import java.util.List;
import java.util.Map;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.apache.ranger.tagsync.source.atlas.EntityNotificationWrapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;

public class RangerAtlasEntityWithTags {
    private static final String DEFAULT_TAG_ATTRIBUTE_TYPE = "string";
    private final RangerAtlasEntity entity;
    private final List<EntityNotificationWrapper.RangerAtlasClassification> tags;
    private final AtlasTypeRegistry typeRegistry;

    public RangerAtlasEntityWithTags(EntityNotificationWrapper notification) {
        this.entity = notification.getRangerAtlasEntity();
        this.tags = notification.getClassifications();
        this.typeRegistry = null;
    }

    public RangerAtlasEntityWithTags(RangerAtlasEntity entity, List<EntityNotificationWrapper.RangerAtlasClassification> tags, AtlasTypeRegistry typeRegistry) {
        this.entity = entity;
        this.tags = tags;
        this.typeRegistry = typeRegistry;
    }

    public RangerAtlasEntity getEntity() {
        return this.entity;
    }

    public List<EntityNotificationWrapper.RangerAtlasClassification> getTags() {
        return this.tags;
    }

    public String getTagAttributeType(String tagTypeName, String tagAttributeName) {
        AtlasStructType.AtlasAttribute atlasAttribute;
        AtlasClassificationType classificationType;
        String ret = DEFAULT_TAG_ATTRIBUTE_TYPE;
        if (this.typeRegistry != null && (classificationType = this.typeRegistry.getClassificationTypeByName(tagTypeName)) != null && (atlasAttribute = classificationType.getAttribute(tagAttributeName)) != null) {
            ret = atlasAttribute.getTypeName();
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.entity != null) {
            sb.append("{entity=").append(this.entity).append(", ");
        }
        sb.append(", classifications={");
        if (CollectionUtils.isNotEmpty(this.tags)) {
            for (EntityNotificationWrapper.RangerAtlasClassification tag : this.tags) {
                sb.append("classificationName=").append(tag.getName());
                sb.append(", attributes={");
                for (Map.Entry<String, String> attribute : tag.getAttributes().entrySet()) {
                    sb.append("{attributeName=").append(attribute.getKey());
                    sb.append(",attributeValue=").append(attribute.getValue());
                    sb.append("}");
                }
                sb.append("}");
                sb.append(", validityPeriods={");
                if (CollectionUtils.isNotEmpty(tag.getValidityPeriods())) {
                    for (RangerValiditySchedule period : tag.getValidityPeriods()) {
                        sb.append("{").append(period).append("}");
                    }
                }
                sb.append("}");
            }
        }
        sb.append("}");
        sb.append("}");
        return sb.toString();
    }
}

