/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.BatchAIClusters;
import com.microsoft.azure.management.batchai.BatchAIExperiments;
import com.microsoft.azure.management.batchai.BatchAIFileServers;
import com.microsoft.azure.management.batchai.BatchAIWorkspace;
import com.microsoft.azure.management.batchai.ProvisioningState;
import com.microsoft.azure.management.batchai.WorkspaceCreateParameters;
import com.microsoft.azure.management.batchai.implementation.BatchAIClustersImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIExperimentsImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIFileServersImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.WorkspaceInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import org.joda.time.DateTime;
import rx.Observable;

@LangDefinition
class BatchAIWorkspaceImpl
extends GroupableResourceImpl<BatchAIWorkspace, WorkspaceInner, BatchAIWorkspaceImpl, BatchAIManager>
implements BatchAIWorkspace,
BatchAIWorkspace.Definition,
BatchAIWorkspace.Update {
    private BatchAIClusters clusters;
    private BatchAIFileServers fileServers;
    private BatchAIExperiments experiments;

    BatchAIWorkspaceImpl(String name, WorkspaceInner innerObject, BatchAIManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
    }

    @Override
    public DateTime creationTime() {
        return ((WorkspaceInner)((Object)this.inner())).creationTime();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((WorkspaceInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public DateTime provisioningStateTransitionTime() {
        return ((WorkspaceInner)((Object)this.inner())).provisioningStateTransitionTime();
    }

    @Override
    public BatchAIClusters clusters() {
        if (this.clusters == null) {
            this.clusters = new BatchAIClustersImpl(this);
        }
        return this.clusters;
    }

    @Override
    public BatchAIExperiments experiments() {
        if (this.experiments == null) {
            this.experiments = new BatchAIExperimentsImpl(this);
        }
        return this.experiments;
    }

    @Override
    public BatchAIFileServers fileServers() {
        if (this.fileServers == null) {
            this.fileServers = new BatchAIFileServersImpl(this);
        }
        return this.fileServers;
    }

    protected Observable<WorkspaceInner> getInnerAsync() {
        return ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.manager()).inner())).workspaces().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<BatchAIWorkspace> createResourceAsync() {
        WorkspaceCreateParameters createParameters = new WorkspaceCreateParameters();
        createParameters.withLocation(this.regionName());
        createParameters.withTags(((WorkspaceInner)((Object)this.inner())).getTags());
        return ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.manager()).inner())).workspaces().createAsync(this.resourceGroupName(), this.name(), createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Observable<BatchAIWorkspace> updateResourceAsync() {
        return ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.manager()).inner())).workspaces().updateAsync(this.resourceGroupName(), this.name(), ((WorkspaceInner)((Object)this.inner())).getTags()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }
}

