/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.MXRecordSet;
import com.microsoft.azure.management.dns.MxRecord;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@LangDefinition
class MXRecordSetImpl
extends DnsRecordSetImpl
implements MXRecordSet {
    MXRecordSetImpl(String name, DnsZoneImpl parent, RecordSetInner innerModel) {
        super(name, RecordType.MX.toString(), parent, innerModel);
    }

    static MXRecordSetImpl newRecordSet(String name, DnsZoneImpl parent) {
        return new MXRecordSetImpl(name, parent, new RecordSetInner().withMxRecords(new ArrayList<MxRecord>()));
    }

    @Override
    public List<MxRecord> records() {
        if (((RecordSetInner)this.inner()).mxRecords() != null) {
            return Collections.unmodifiableList(((RecordSetInner)this.inner()).mxRecords());
        }
        return Collections.unmodifiableList(new ArrayList());
    }

    @Override
    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        if (((RecordSetInner)this.inner()).mxRecords() != null && ((RecordSetInner)this.inner()).mxRecords().size() > 0) {
            if (resource.mxRecords() == null) {
                resource.withMxRecords(new ArrayList<MxRecord>());
            }
            resource.mxRecords().addAll(((RecordSetInner)this.inner()).mxRecords());
            ((RecordSetInner)this.inner()).mxRecords().clear();
        }
        if (this.recordSetRemoveInfo.mxRecords().size() > 0) {
            if (resource.mxRecords() != null) {
                block0: for (MxRecord recordToRemove : this.recordSetRemoveInfo.mxRecords()) {
                    for (MxRecord record : resource.mxRecords()) {
                        if (!record.exchange().equalsIgnoreCase(recordToRemove.exchange()) || record.preference() == null || !record.preference().equals(recordToRemove.preference())) continue;
                        resource.mxRecords().remove(record);
                        continue block0;
                    }
                }
            }
            this.recordSetRemoveInfo.mxRecords().clear();
        }
        return resource;
    }
}

