/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.NetworkWatcher;
import com.microsoft.azure.management.network.SecurityGroupNetworkInterface;
import com.microsoft.azure.management.network.SecurityGroupView;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkWatcherImpl;
import com.microsoft.azure.management.network.implementation.SecurityGroupViewResultInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class SecurityGroupViewImpl
extends RefreshableWrapperImpl<SecurityGroupViewResultInner, SecurityGroupView>
implements SecurityGroupView {
    private Map<String, SecurityGroupNetworkInterface> networkInterfaces;
    private final NetworkWatcherImpl parent;
    private final String vmId;

    SecurityGroupViewImpl(NetworkWatcherImpl parent, SecurityGroupViewResultInner innerObject, String vmId) {
        super((Object)innerObject);
        this.parent = parent;
        this.vmId = vmId;
        this.initializeFromInner();
    }

    private void initializeFromInner() {
        this.networkInterfaces = new TreeMap<String, SecurityGroupNetworkInterface>();
        List<SecurityGroupNetworkInterface> securityGroupNetworkInterfaces = ((SecurityGroupViewResultInner)this.inner()).networkInterfaces();
        if (securityGroupNetworkInterfaces != null) {
            for (SecurityGroupNetworkInterface networkInterface : securityGroupNetworkInterfaces) {
                this.networkInterfaces.put(networkInterface.id(), networkInterface);
            }
        }
    }

    @Override
    public Map<String, SecurityGroupNetworkInterface> networkInterfaces() {
        return Collections.unmodifiableMap(this.networkInterfaces);
    }

    @Override
    public String vmId() {
        return this.vmId;
    }

    public NetworkWatcher parent() {
        return this.parent;
    }

    public Observable<SecurityGroupView> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<SecurityGroupView, SecurityGroupView>(){

            public SecurityGroupView call(SecurityGroupView securityGroupView) {
                SecurityGroupViewImpl impl = (SecurityGroupViewImpl)securityGroupView;
                impl.initializeFromInner();
                return impl;
            }
        });
    }

    protected Observable<SecurityGroupViewResultInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)((Object)this.parent().manager())).inner())).networkWatchers().getVMSecurityRulesAsync(this.parent.resourceGroupName(), this.parent.name(), this.vmId);
    }
}

