/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.LoadBalancingRuleInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class LoadBalancerLoadBalancingRulesInner {
    private LoadBalancerLoadBalancingRulesService service;
    private NetworkManagementClientImpl client;

    public LoadBalancerLoadBalancingRulesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (LoadBalancerLoadBalancingRulesService)retrofit.create(LoadBalancerLoadBalancingRulesService.class);
        this.client = client;
    }

    public PagedList<LoadBalancingRuleInner> list(String resourceGroupName, String loadBalancerName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, loadBalancerName).toBlocking().single();
        return new PagedList<LoadBalancingRuleInner>((Page)response.body()){

            public Page<LoadBalancingRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancerLoadBalancingRulesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<LoadBalancingRuleInner>> listAsync(String resourceGroupName, String loadBalancerName, ListOperationCallback<LoadBalancingRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, loadBalancerName), (Func1)new Func1<String, Observable<ServiceResponse<Page<LoadBalancingRuleInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancingRuleInner>>> call(String nextPageLink) {
                return LoadBalancerLoadBalancingRulesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<LoadBalancingRuleInner>> listAsync(String resourceGroupName, String loadBalancerName) {
        return this.listWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<Page<LoadBalancingRuleInner>>, Page<LoadBalancingRuleInner>>(){

            public Page<LoadBalancingRuleInner> call(ServiceResponse<Page<LoadBalancingRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancingRuleInner>>> listWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        return this.listSinglePageAsync(resourceGroupName, loadBalancerName).concatMap((Func1)new Func1<ServiceResponse<Page<LoadBalancingRuleInner>>, Observable<ServiceResponse<Page<LoadBalancingRuleInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancingRuleInner>>> call(ServiceResponse<Page<LoadBalancingRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancerLoadBalancingRulesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancingRuleInner>>> listSinglePageAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.list(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<LoadBalancingRuleInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancingRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancerLoadBalancingRulesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LoadBalancingRuleInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<LoadBalancingRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public LoadBalancingRuleInner get(String resourceGroupName, String loadBalancerName, String loadBalancingRuleName) {
        return (LoadBalancingRuleInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, loadBalancingRuleName).toBlocking().single()).body());
    }

    public ServiceFuture<LoadBalancingRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String loadBalancingRuleName, ServiceCallback<LoadBalancingRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, loadBalancingRuleName), serviceCallback);
    }

    public Observable<LoadBalancingRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String loadBalancingRuleName) {
        return this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, loadBalancingRuleName).map((Func1)new Func1<ServiceResponse<LoadBalancingRuleInner>, LoadBalancingRuleInner>(){

            public LoadBalancingRuleInner call(ServiceResponse<LoadBalancingRuleInner> response) {
                return (LoadBalancingRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancingRuleInner>> getWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String loadBalancingRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (loadBalancingRuleName == null) {
            throw new IllegalArgumentException("Parameter loadBalancingRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.get(resourceGroupName, loadBalancerName, loadBalancingRuleName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LoadBalancingRuleInner>>>(){

            public Observable<ServiceResponse<LoadBalancingRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancerLoadBalancingRulesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LoadBalancingRuleInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LoadBalancingRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<LoadBalancingRuleInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<LoadBalancingRuleInner>((Page)response.body()){

            public Page<LoadBalancingRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancerLoadBalancingRulesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<LoadBalancingRuleInner>> listNextAsync(String nextPageLink, ServiceFuture<List<LoadBalancingRuleInner>> serviceFuture, ListOperationCallback<LoadBalancingRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<LoadBalancingRuleInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancingRuleInner>>> call(String nextPageLink) {
                return LoadBalancerLoadBalancingRulesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<LoadBalancingRuleInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<LoadBalancingRuleInner>>, Page<LoadBalancingRuleInner>>(){

            public Page<LoadBalancingRuleInner> call(ServiceResponse<Page<LoadBalancingRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancingRuleInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<LoadBalancingRuleInner>>, Observable<ServiceResponse<Page<LoadBalancingRuleInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancingRuleInner>>> call(ServiceResponse<Page<LoadBalancingRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancerLoadBalancingRulesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancingRuleInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<LoadBalancingRuleInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancingRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancerLoadBalancingRulesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LoadBalancingRuleInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<LoadBalancingRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LoadBalancerLoadBalancingRulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerLoadBalancingRules list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/loadBalancingRules")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerLoadBalancingRules get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/loadBalancingRules/{loadBalancingRuleName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="loadBalancingRuleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerLoadBalancingRules listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

