/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.BaseHttpClusterStateProvider;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;

public class HttpClusterStateProvider
extends BaseHttpClusterStateProvider {
    private final HttpClient httpClient;
    private final boolean clientIsInternal;

    public HttpClusterStateProvider(List<String> solrUrls, HttpClient httpClient) throws Exception {
        this.httpClient = httpClient == null ? HttpClientUtil.createClient(null) : httpClient;
        this.clientIsInternal = httpClient == null;
        this.init(solrUrls);
    }

    @Override
    protected SolrClient getSolrClient(String baseUrl) {
        return ((HttpSolrClient.Builder)new HttpSolrClient.Builder().withBaseSolrUrl(baseUrl).withHttpClient(this.httpClient)).build();
    }

    @Override
    public void close() throws IOException {
        if (this.clientIsInternal && this.httpClient != null) {
            HttpClientUtil.close(this.httpClient);
        }
    }
}

