/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.utils;

import java.util.Random;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ResourceNamer {
    private final String randName;
    private static final Random RANDOM = new Random();

    public ResourceNamer(String name) {
        this.randName = name.toLowerCase() + UUID.randomUUID().toString().replace("-", "").substring(0, 3).toLowerCase();
    }

    public String randomName(String prefix, int maxLen) {
        prefix = prefix.toLowerCase();
        int minRandomnessLength = 5;
        if (maxLen <= minRandomnessLength) {
            return this.randomString(maxLen);
        }
        if (maxLen < prefix.length() + minRandomnessLength) {
            return this.randomString(maxLen);
        }
        String minRandomString = String.format("%05d", Math.abs(RANDOM.nextInt() % 100000));
        if (maxLen <= prefix.length() + this.randName.length() + minRandomnessLength) {
            String str = prefix + minRandomString;
            return str + this.randomString((maxLen - str.length()) / 2);
        }
        String str = prefix + this.randName + minRandomString;
        return str + this.randomString((maxLen - str.length()) / 2);
    }

    public String randomUuid() {
        return UUID.randomUUID().toString();
    }

    public DateTime dateTimeNow() {
        return DateTime.now((DateTimeZone)DateTimeZone.UTC);
    }

    private String randomString(int length) {
        StringBuilder str = new StringBuilder();
        while (str.length() < length) {
            str.append(UUID.randomUUID().toString().replace("-", "").substring(0, Math.min(32, length)).toLowerCase());
        }
        return str.toString();
    }
}

