/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerregistry.ReplicationUpdateParameters;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.PageImpl;
import com.microsoft.azure.management.containerregistry.implementation.ReplicationInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ReplicationsInner {
    private ReplicationsService service;
    private ContainerRegistryManagementClientImpl client;

    public ReplicationsInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = (ReplicationsService)retrofit.create(ReplicationsService.class);
        this.client = client;
    }

    public ReplicationInner get(String resourceGroupName, String registryName, String replicationName) {
        return (ReplicationInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, registryName, replicationName).toBlocking().single()).body());
    }

    public ServiceFuture<ReplicationInner> getAsync(String resourceGroupName, String registryName, String replicationName, ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, registryName, replicationName), serviceCallback);
    }

    public Observable<ReplicationInner> getAsync(String resourceGroupName, String registryName, String replicationName) {
        return this.getWithServiceResponseAsync(resourceGroupName, registryName, replicationName).map((Func1)new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>(){

            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return (ReplicationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ReplicationInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ReplicationInner>>>(){

            public Observable<ServiceResponse<ReplicationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ReplicationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ReplicationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ReplicationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ReplicationInner create(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        return (ReplicationInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, registryName, replicationName, replication).toBlocking().last()).body());
    }

    public ServiceFuture<ReplicationInner> createAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication, ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, registryName, replicationName, replication), serviceCallback);
    }

    public Observable<ReplicationInner> createAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        return this.createWithServiceResponseAsync(resourceGroupName, registryName, replicationName, replication).map((Func1)new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>(){

            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return (ReplicationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ReplicationInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        if (replication == null) {
            throw new IllegalArgumentException("Parameter replication is required and cannot be null.");
        }
        Validator.validate((Object)((Object)replication));
        String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = this.service.create(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, "2017-10-01", replication, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ReplicationInner>(){}.getType());
    }

    public ReplicationInner beginCreate(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        return (ReplicationInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, replication).toBlocking().single()).body());
    }

    public ServiceFuture<ReplicationInner> beginCreateAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication, ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, replication), serviceCallback);
    }

    public Observable<ReplicationInner> beginCreateAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, replication).map((Func1)new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>(){

            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return (ReplicationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ReplicationInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        if (replication == null) {
            throw new IllegalArgumentException("Parameter replication is required and cannot be null.");
        }
        Validator.validate((Object)((Object)replication));
        String apiVersion = "2017-10-01";
        return this.service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, "2017-10-01", replication, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ReplicationInner>>>(){

            public Observable<ServiceResponse<ReplicationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ReplicationsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ReplicationInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ReplicationInner>(){}.getType()).register(201, new TypeToken<ReplicationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String registryName, String replicationName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, registryName, replicationName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, String replicationName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, registryName, replicationName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String registryName, String replicationName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, registryName, replicationName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String registryName, String replicationName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, replicationName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String registryName, String replicationName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, replicationName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String registryName, String replicationName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, replicationName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ReplicationsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ReplicationInner update(String resourceGroupName, String registryName, String replicationName) {
        return (ReplicationInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, registryName, replicationName).toBlocking().last()).body());
    }

    public ServiceFuture<ReplicationInner> updateAsync(String resourceGroupName, String registryName, String replicationName, ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, registryName, replicationName), serviceCallback);
    }

    public Observable<ReplicationInner> updateAsync(String resourceGroupName, String registryName, String replicationName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, registryName, replicationName).map((Func1)new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>(){

            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return (ReplicationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ReplicationInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        Object tags = null;
        ReplicationUpdateParameters replicationUpdateParameters = new ReplicationUpdateParameters();
        replicationUpdateParameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, "2017-10-01", this.client.acceptLanguage(), replicationUpdateParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ReplicationInner>(){}.getType());
    }

    public ReplicationInner update(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        return (ReplicationInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<ReplicationInner> updateAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags, ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, tags), serviceCallback);
    }

    public Observable<ReplicationInner> updateAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        return this.updateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, tags).map((Func1)new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>(){

            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return (ReplicationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ReplicationInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2017-10-01";
        ReplicationUpdateParameters replicationUpdateParameters = new ReplicationUpdateParameters();
        replicationUpdateParameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, "2017-10-01", this.client.acceptLanguage(), replicationUpdateParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ReplicationInner>(){}.getType());
    }

    public ReplicationInner beginUpdate(String resourceGroupName, String registryName, String replicationName) {
        return (ReplicationInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, replicationName).toBlocking().single()).body());
    }

    public ServiceFuture<ReplicationInner> beginUpdateAsync(String resourceGroupName, String registryName, String replicationName, ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, replicationName), serviceCallback);
    }

    public Observable<ReplicationInner> beginUpdateAsync(String resourceGroupName, String registryName, String replicationName) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, replicationName).map((Func1)new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>(){

            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return (ReplicationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ReplicationInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        Object tags = null;
        ReplicationUpdateParameters replicationUpdateParameters = new ReplicationUpdateParameters();
        replicationUpdateParameters.withTags(null);
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, "2017-10-01", this.client.acceptLanguage(), replicationUpdateParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ReplicationInner>>>(){

            public Observable<ServiceResponse<ReplicationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ReplicationsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ReplicationInner beginUpdate(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        return (ReplicationInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<ReplicationInner> beginUpdateAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags, ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, tags), serviceCallback);
    }

    public Observable<ReplicationInner> beginUpdateAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, tags).map((Func1)new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>(){

            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return (ReplicationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ReplicationInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2017-10-01";
        ReplicationUpdateParameters replicationUpdateParameters = new ReplicationUpdateParameters();
        replicationUpdateParameters.withTags(tags);
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, "2017-10-01", this.client.acceptLanguage(), replicationUpdateParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ReplicationInner>>>(){

            public Observable<ServiceResponse<ReplicationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ReplicationsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ReplicationInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ReplicationInner>(){}.getType()).register(201, new TypeToken<ReplicationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ReplicationInner> list(String resourceGroupName, String registryName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, registryName).toBlocking().single();
        return new PagedList<ReplicationInner>((Page)response.body()){

            public Page<ReplicationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ReplicationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ReplicationInner>> listAsync(String resourceGroupName, String registryName, ListOperationCallback<ReplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, registryName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ReplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ReplicationInner>>> call(String nextPageLink) {
                return ReplicationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ReplicationInner>> listAsync(String resourceGroupName, String registryName) {
        return this.listWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<Page<ReplicationInner>>, Page<ReplicationInner>>(){

            public Page<ReplicationInner> call(ServiceResponse<Page<ReplicationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ReplicationInner>>> listWithServiceResponseAsync(String resourceGroupName, String registryName) {
        return this.listSinglePageAsync(resourceGroupName, registryName).concatMap((Func1)new Func1<ServiceResponse<Page<ReplicationInner>>, Observable<ServiceResponse<Page<ReplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ReplicationInner>>> call(ServiceResponse<Page<ReplicationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ReplicationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ReplicationInner>>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ReplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ReplicationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ReplicationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ReplicationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ReplicationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ReplicationInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ReplicationInner>((Page)response.body()){

            public Page<ReplicationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ReplicationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ReplicationInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ReplicationInner>> serviceFuture, ListOperationCallback<ReplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ReplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ReplicationInner>>> call(String nextPageLink) {
                return ReplicationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ReplicationInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ReplicationInner>>, Page<ReplicationInner>>(){

            public Page<ReplicationInner> call(ServiceResponse<Page<ReplicationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ReplicationInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ReplicationInner>>, Observable<ServiceResponse<Page<ReplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ReplicationInner>>> call(ServiceResponse<Page<ReplicationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ReplicationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ReplicationInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ReplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ReplicationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ReplicationsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ReplicationInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ReplicationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ReplicationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="replicationName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        public Observable<Response<ResponseBody>> create(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="replicationName") String var4, @Query(value="api-version") String var5, @Body ReplicationInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="replicationName") String var4, @Query(value="api-version") String var5, @Body ReplicationInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="replicationName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="replicationName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="replicationName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ReplicationUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="replicationName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ReplicationUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

