/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.storage.BlobContainer;
import com.microsoft.azure.management.storage.ImmutabilityPolicyProperties;
import com.microsoft.azure.management.storage.LeaseDuration;
import com.microsoft.azure.management.storage.LeaseState;
import com.microsoft.azure.management.storage.LeaseStatus;
import com.microsoft.azure.management.storage.LegalHoldProperties;
import com.microsoft.azure.management.storage.PublicAccess;
import com.microsoft.azure.management.storage.implementation.BlobContainerInner;
import com.microsoft.azure.management.storage.implementation.BlobContainersInner;
import com.microsoft.azure.management.storage.implementation.IdParsingUtils;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import rx.Observable;

@LangDefinition
class BlobContainerImpl
extends CreatableUpdatableImpl<BlobContainer, BlobContainerInner, BlobContainerImpl>
implements BlobContainer,
BlobContainer.Definition,
BlobContainer.Update {
    private final StorageManager manager;
    private String resourceGroupName;
    private String accountName;
    private String containerName;
    private PublicAccess cpublicAccess;
    private Map<String, String> cmetadata;
    private PublicAccess upublicAccess;
    private Map<String, String> umetadata;

    BlobContainerImpl(String name, StorageManager manager) {
        super(name, (Object)new BlobContainerInner());
        this.manager = manager;
        this.containerName = name;
    }

    BlobContainerImpl(BlobContainerInner inner, StorageManager manager) {
        super(inner.name(), (Object)inner);
        this.manager = manager;
        this.containerName = inner.name();
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroups");
        this.accountName = IdParsingUtils.getValueFromIdByName(inner.id(), "storageAccounts");
        this.containerName = IdParsingUtils.getValueFromIdByName(inner.id(), "containers");
    }

    public StorageManager manager() {
        return this.manager;
    }

    public Observable<BlobContainer> createResourceAsync() {
        BlobContainersInner client = ((StorageManagementClientImpl)((Object)this.manager().inner())).blobContainers();
        return client.createAsync(this.resourceGroupName, this.accountName, this.containerName, this.cpublicAccess, this.cmetadata).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Observable<BlobContainer> updateResourceAsync() {
        BlobContainersInner client = ((StorageManagementClientImpl)((Object)this.manager().inner())).blobContainers();
        return client.updateAsync(this.resourceGroupName, this.accountName, this.containerName, this.upublicAccess, this.umetadata).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<BlobContainerInner> getInnerAsync() {
        BlobContainersInner client = ((StorageManagementClientImpl)((Object)this.manager().inner())).blobContainers();
        return null;
    }

    public boolean isInCreateMode() {
        return ((BlobContainerInner)((Object)this.inner())).id() == null;
    }

    @Override
    public String etag() {
        return ((BlobContainerInner)((Object)this.inner())).etag();
    }

    @Override
    public Boolean hasImmutabilityPolicy() {
        return ((BlobContainerInner)((Object)this.inner())).hasImmutabilityPolicy();
    }

    @Override
    public Boolean hasLegalHold() {
        return ((BlobContainerInner)((Object)this.inner())).hasLegalHold();
    }

    @Override
    public String id() {
        return ((BlobContainerInner)((Object)this.inner())).id();
    }

    @Override
    public ImmutabilityPolicyProperties immutabilityPolicy() {
        return ((BlobContainerInner)((Object)this.inner())).immutabilityPolicy();
    }

    @Override
    public DateTime lastModifiedTime() {
        return ((BlobContainerInner)((Object)this.inner())).lastModifiedTime();
    }

    @Override
    public LeaseDuration leaseDuration() {
        return ((BlobContainerInner)((Object)this.inner())).leaseDuration();
    }

    @Override
    public LeaseState leaseState() {
        return ((BlobContainerInner)((Object)this.inner())).leaseState();
    }

    @Override
    public LeaseStatus leaseStatus() {
        return ((BlobContainerInner)((Object)this.inner())).leaseStatus();
    }

    @Override
    public LegalHoldProperties legalHold() {
        return ((BlobContainerInner)((Object)this.inner())).legalHold();
    }

    @Override
    public Map<String, String> metadata() {
        return ((BlobContainerInner)((Object)this.inner())).metadata();
    }

    @Override
    public String name() {
        return ((BlobContainerInner)((Object)this.inner())).name();
    }

    @Override
    public PublicAccess publicAccess() {
        return ((BlobContainerInner)((Object)this.inner())).publicAccess();
    }

    @Override
    public String type() {
        return ((BlobContainerInner)((Object)this.inner())).type();
    }

    @Override
    public BlobContainerImpl withExistingBlobService(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public BlobContainerImpl withPublicAccess(PublicAccess publicAccess) {
        if (this.isInCreateMode()) {
            this.cpublicAccess = publicAccess;
        } else {
            this.upublicAccess = publicAccess;
        }
        return this;
    }

    @Override
    public BlobContainerImpl withMetadata(Map<String, String> metadata) {
        if (this.isInCreateMode()) {
            this.cmetadata = metadata;
        } else {
            this.umetadata = metadata;
        }
        return this;
    }

    @Override
    public BlobContainerImpl withMetadata(String name, String value) {
        if (this.isInCreateMode()) {
            if (this.cmetadata == null) {
                this.cmetadata = new HashMap<String, String>();
            }
            this.cmetadata.put(name, value);
        } else {
            if (this.umetadata == null) {
                this.umetadata = new HashMap<String, String>();
            }
            this.umetadata.put(name, value);
        }
        return this;
    }
}

