/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.examples.sampleclient;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.ranger.RangerClient;
import org.apache.ranger.RangerServiceException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerServiceTags;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleClient {
    private static final Logger LOG = LoggerFactory.getLogger(SampleClient.class);

    public static void main(String[] args) throws RangerServiceException {
        CommandLine cmd;
        Gson gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").setPrettyPrinting().create();
        Options options = new Options();
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)"host");
        OptionBuilder.withDescription((String)"hostname");
        Option host = OptionBuilder.create((char)'h');
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)"authType");
        OptionBuilder.withDescription((String)"Authentication Type");
        Option auth = OptionBuilder.create((char)'k');
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)"user");
        OptionBuilder.withDescription((String)"username");
        Option user = OptionBuilder.create((char)'u');
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)"pass");
        OptionBuilder.withDescription((String)"password");
        Option pass = OptionBuilder.create((char)'p');
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"configuration");
        Option conf = OptionBuilder.create((char)'c');
        options.addOption(host);
        options.addOption(auth);
        options.addOption(user);
        options.addOption(pass);
        options.addOption(conf);
        BasicParser parser = new BasicParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        String hostName = cmd.getOptionValue('h');
        String userName = cmd.getOptionValue('u');
        String password = cmd.getOptionValue('p');
        String cfg = cmd.getOptionValue('c');
        String authType = cmd.getOptionValue('k');
        RangerClient rangerClient = new RangerClient(hostName, authType, userName, password, cfg);
        String serviceDefName = "sampleServiceDef";
        String serviceName = "sampleService";
        String policyName = "samplePolicy";
        String zoneName = null;
        String roleName = "sampleRole";
        Map filter = Collections.emptyMap();
        RangerServiceDef.RangerServiceConfigDef config = new RangerServiceDef.RangerServiceConfigDef();
        config.setItemId(Long.valueOf(1L));
        config.setName("sampleConfig");
        config.setType("string");
        List<RangerServiceDef.RangerServiceConfigDef> configs = Collections.singletonList(config);
        RangerServiceDef.RangerAccessTypeDef accessType = new RangerServiceDef.RangerAccessTypeDef();
        accessType.setItemId(Long.valueOf(1L));
        accessType.setName("sampleAccess");
        List<RangerServiceDef.RangerAccessTypeDef> accessTypes = Collections.singletonList(accessType);
        RangerServiceDef.RangerResourceDef resourceDef = new RangerServiceDef.RangerResourceDef();
        resourceDef.setItemId(Long.valueOf(1L));
        resourceDef.setName("root");
        resourceDef.setType("string");
        List<RangerServiceDef.RangerResourceDef> resourceDefs = Collections.singletonList(resourceDef);
        RangerServiceDef serviceDef = new RangerServiceDef();
        serviceDef.setName(serviceDefName);
        serviceDef.setConfigs(configs);
        serviceDef.setAccessTypes(accessTypes);
        serviceDef.setResources(resourceDefs);
        RangerServiceDef createdServiceDef = rangerClient.createServiceDef(serviceDef);
        LOG.info("New Service Definition created successfully {}", (Object)gsonBuilder.toJson((Object)createdServiceDef));
        RangerService service = new RangerService();
        service.setType(serviceDefName);
        service.setName(serviceName);
        RangerService createdService = rangerClient.createService(service);
        LOG.info("New Service created successfully {}", (Object)gsonBuilder.toJson((Object)createdService));
        List services = rangerClient.findServices(filter);
        String allServiceNames = "";
        for (RangerService svc : services) {
            allServiceNames = allServiceNames.concat(svc.getName() + " ");
        }
        LOG.info("List of Services : {}", (Object)allServiceNames);
        Map<String, RangerPolicy.RangerPolicyResource> resource = Collections.singletonMap("root", new RangerPolicy.RangerPolicyResource(Collections.singletonList("/path/to/sample/resource"), Boolean.valueOf(false), Boolean.valueOf(false)));
        RangerPolicy policy = new RangerPolicy();
        policy.setService(serviceName);
        policy.setZoneName(zoneName);
        policy.setName(policyName);
        policy.setResources(resource);
        RangerPolicy createdPolicy = rangerClient.createPolicy(policy);
        LOG.info("Created policy {} in zone {}: {}", new Object[]{policyName, zoneName, gsonBuilder.toJson((Object)createdPolicy)});
        RangerPolicy fetchedPolicy = rangerClient.getPolicyByNameAndZone(serviceName, policyName, zoneName);
        LOG.info("Fetched policy {} in zone {}: {}", new Object[]{policyName, zoneName, gsonBuilder.toJson((Object)fetchedPolicy)});
        RangerPolicy updatedPolicy = rangerClient.updatePolicyByNameAndZone(serviceName, policyName, zoneName, fetchedPolicy);
        LOG.info("Updated policy {} in zone {}: {}", new Object[]{policyName, zoneName, gsonBuilder.toJson((Object)updatedPolicy)});
        rangerClient.deletePolicyByNameAndZone(serviceName, policyName, zoneName);
        LOG.info("Deleted policy {} in zone {}", (Object)policyName, zoneName);
        RangerTagDef tagDefTest1 = new RangerTagDef("test1");
        RangerTagDef tagDefTest2 = new RangerTagDef("test2");
        tagDefTest1.setAttributeDefs(Arrays.asList(new RangerTagDef.RangerTagAttributeDef("attr1", "string")));
        RangerTag tagTest1Val1 = new RangerTag(tagDefTest1.getName(), Collections.singletonMap("attr1", "val1"));
        RangerTag tagTest1Val2 = new RangerTag(tagDefTest1.getName(), Collections.singletonMap("attr1", "val2"));
        RangerTag tagTest2 = new RangerTag(tagDefTest2.getName(), Collections.emptyMap());
        RangerServiceResource db1 = new RangerServiceResource(serviceName, Collections.singletonMap("database", new RangerPolicy.RangerPolicyResource("db1")));
        RangerServiceResource db2 = new RangerServiceResource(serviceName, Collections.singletonMap("database", new RangerPolicy.RangerPolicyResource("db2")));
        db1.setId(Long.valueOf(1L));
        db2.setId(Long.valueOf(2L));
        RangerServiceTags serviceTags = new RangerServiceTags();
        serviceTags.setOp("set");
        serviceTags.getTagDefinitions().put(0L, tagDefTest1);
        serviceTags.getTagDefinitions().put(1L, tagDefTest2);
        serviceTags.getTags().put(0L, tagTest1Val1);
        serviceTags.getTags().put(1L, tagTest1Val2);
        serviceTags.getTags().put(2L, tagTest2);
        serviceTags.getServiceResources().add(db1);
        serviceTags.getServiceResources().add(db2);
        serviceTags.getResourceToTagIds().put(db1.getId(), Arrays.asList(0L, 2L));
        serviceTags.getResourceToTagIds().put(db2.getId(), Arrays.asList(1L, 2L));
        LOG.info("Importing tags: {}", (Object)serviceTags);
        rangerClient.importServiceTags(serviceName, serviceTags);
        RangerServiceTags serviceTags2 = rangerClient.getServiceTags(serviceName);
        LOG.info("Imported tags: {}", (Object)serviceTags2);
        serviceTags.setOp("delete");
        serviceTags.setTagDefinitions(Collections.emptyMap());
        serviceTags.setTags(Collections.emptyMap());
        serviceTags.setResourceToTagIds(Collections.emptyMap());
        LOG.info("Deleting tags: {}" + serviceTags);
        rangerClient.importServiceTags(serviceName, serviceTags);
        serviceTags2 = rangerClient.getServiceTags(serviceName);
        LOG.info("Service tags after delete: {}", (Object)serviceTags2);
        rangerClient.deleteService(serviceName);
        LOG.info("Service {} successfully deleted", (Object)serviceName);
        rangerClient.deleteServiceDef(serviceDefName);
        LOG.info("Service Definition {} successfully deleted", (Object)serviceDefName);
        RangerRole sampleRole = new RangerRole();
        sampleRole.setName(roleName);
        sampleRole.setDescription("Sample Role");
        sampleRole.setUsers(Collections.singletonList(new RangerRole.RoleMember(null, true)));
        sampleRole = rangerClient.createRole(serviceName, sampleRole);
        LOG.info("New Role successfully created {}", (Object)gsonBuilder.toJson((Object)sampleRole));
        sampleRole.setDescription("Updated Sample Role");
        RangerRole updatedRole = rangerClient.updateRole(sampleRole.getId().longValue(), sampleRole);
        LOG.info("Role {} successfully updated {}", (Object)roleName, (Object)gsonBuilder.toJson((Object)updatedRole));
        List allRoles = rangerClient.findRoles(filter);
        LOG.info("List of Roles {}", (Object)gsonBuilder.toJson((Object)allRoles));
        String allRoleNames = "";
        for (RangerRole role : allRoles) {
            allRoleNames = allRoleNames.concat(role.getName() + " ");
        }
        LOG.info("List of Roles : {}", (Object)allRoleNames);
        rangerClient.deleteRole(roleName, userName, serviceName);
        LOG.info("Role {} successfully deleted", (Object)roleName);
    }
}

