/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.qpid.protonj2.test.driver.matchers.messaging;

import static org.hamcrest.CoreMatchers.equalTo;

import java.util.HashMap;

import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedByte;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.hamcrest.Matcher;

/**
 * Generated by generate-message-section-matchers.xsl, which resides in this
 * package.
 */
public class HeaderMatcher extends AbstractListSectionMatcher<HeaderMatcher> {

    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:header:list");
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(0x0000000000000070L);

    /**
     * Note that the ordinal of the Field enumeration match the order specified in
     * the AMQP specification
     */
    public enum Field {
        DURABLE,
        PRIORITY,
        TTL,
        FIRST_ACQUIRER,
        DELIVERY_COUNT
    }

    public HeaderMatcher(boolean expectTrailingBytes) {
        super(DESCRIPTOR_CODE, DESCRIPTOR_SYMBOL, new HashMap<Object, Matcher<?>>(), expectTrailingBytes);
    }

    //----- Type specific with methods that perform simple equals checks

    public HeaderMatcher withDurable(boolean durable) {
        return withDurable(equalTo(durable));
    }

    public HeaderMatcher withDurable(Boolean durable) {
        return withDurable(equalTo(durable));
    }

    public HeaderMatcher withPriority(byte priority) {
        return withPriority(equalTo(UnsignedByte.valueOf(priority)));
    }

    public HeaderMatcher withPriority(UnsignedByte priority) {
        return withPriority(equalTo(priority));
    }

    public HeaderMatcher withTtl(int timeToLive) {
        return withTtl(equalTo(UnsignedInteger.valueOf(timeToLive)));
    }

    public HeaderMatcher withTtl(long timeToLive) {
        return withTtl(equalTo(UnsignedInteger.valueOf(timeToLive)));
    }

    public HeaderMatcher withTtl(UnsignedInteger timeToLive) {
        return withTtl(equalTo(timeToLive));
    }

    public HeaderMatcher withFirstAcquirer(boolean durable) {
        return withFirstAcquirer(equalTo(durable));
    }

    public HeaderMatcher withFirstAcquirer(Boolean durable) {
        return withFirstAcquirer(equalTo(durable));
    }

    public HeaderMatcher withDeliveryCount(int deliveryCount) {
        return withDeliveryCount(equalTo(UnsignedInteger.valueOf(deliveryCount)));
    }

    public HeaderMatcher withDeliveryCount(long deliveryCount) {
        return withDeliveryCount(equalTo(UnsignedInteger.valueOf(deliveryCount)));
    }

    public HeaderMatcher withDeliveryCount(UnsignedInteger deliveryCount) {
        return withDeliveryCount(equalTo(deliveryCount));
    }

    //----- Matcher based with methods for more complex validation

    public HeaderMatcher withDurable(Matcher<?> m) {
        getMatchers().put(Field.DURABLE, m);
        return this;
    }

    public HeaderMatcher withPriority(Matcher<?> m) {
        getMatchers().put(Field.PRIORITY, m);
        return this;
    }

    public HeaderMatcher withTtl(Matcher<?> m) {
        getMatchers().put(Field.TTL, m);
        return this;
    }

    public HeaderMatcher withFirstAcquirer(Matcher<?> m) {
        getMatchers().put(Field.FIRST_ACQUIRER, m);
        return this;
    }

    public HeaderMatcher withDeliveryCount(Matcher<?> m) {
        getMatchers().put(Field.DELIVERY_COUNT, m);
        return this;
    }

    public Object getReceivedDurable() {
        return getReceivedFields().get(Field.DURABLE);
    }

    public Object getReceivedPriority() {
        return getReceivedFields().get(Field.PRIORITY);
    }

    public Object getReceivedTtl() {
        return getReceivedFields().get(Field.TTL);
    }

    public Object getReceivedFirstAcquirer() {
        return getReceivedFields().get(Field.FIRST_ACQUIRER);
    }

    public Object getReceivedDeliveryCount() {
        return getReceivedFields().get(Field.DELIVERY_COUNT);
    }

    @Override
    protected Enum<?> getField(int fieldIndex) {
        return Field.values()[fieldIndex];
    }
}
