/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.EncodingCodes;
import org.apache.qpid.protonj2.codec.StreamDecoder;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.PrimitiveTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamDecoderState;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import org.apache.qpid.protonj2.codec.decoders.UnknownDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Array32TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Array8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Binary32TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Binary8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.BooleanFalseTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.BooleanTrueTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.BooleanTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ByteTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.CharacterTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Decimal128TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Decimal32TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Decimal64TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.DoubleTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.FloatTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Integer32TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Integer8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.List0TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.List32TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.List8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Long8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.LongTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Map32TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Map8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.NullTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ShortTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.String32TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.String8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Symbol32TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.Symbol8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.TimestampTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.UUIDTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.UnsignedByteTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.UnsignedInteger0TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.UnsignedInteger32TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.UnsignedInteger8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.UnsignedLong0TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.UnsignedLong64TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.UnsignedLong8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.UnsignedShortTypeDecoder;
import org.apache.qpid.protonj2.types.Binary;
import org.apache.qpid.protonj2.types.Decimal128;
import org.apache.qpid.protonj2.types.Decimal32;
import org.apache.qpid.protonj2.types.Decimal64;
import org.apache.qpid.protonj2.types.DeliveryTag;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedByte;
import org.apache.qpid.protonj2.types.UnsignedInteger;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.UnsignedShort;

public final class ProtonStreamDecoder
implements StreamDecoder {
    private static final int STREAM_PEEK_MARK_LIMIT = 64;
    private static final PrimitiveTypeDecoder<?>[] primitiveDecoders = new PrimitiveTypeDecoder[256];
    private Map<Object, StreamDescribedTypeDecoder<?>> describedTypeDecoders = new HashMap();
    private final StreamDescribedTypeDecoder<?>[] amqpTypeDecoders = new StreamDescribedTypeDecoder[256];
    private ProtonStreamDecoderState singleThreadedState;
    private static final Symbol8TypeDecoder symbol8Decoder;
    private static final Symbol32TypeDecoder symbol32Decoder;
    private static final Binary8TypeDecoder binary8Decoder;
    private static final Binary32TypeDecoder binary32Decoder;
    private static final List8TypeDecoder list8Decoder;
    private static final List32TypeDecoder list32Decoder;
    private static final Map8TypeDecoder map8Decoder;
    private static final Map32TypeDecoder map32Decoder;
    private static final String8TypeDecoder string8Decoder;
    private static final String32TypeDecoder string32Decoder;

    @Override
    public ProtonStreamDecoderState newDecoderState() {
        return new ProtonStreamDecoderState(this);
    }

    @Override
    public ProtonStreamDecoderState getCachedDecoderState() {
        ProtonStreamDecoderState state = this.singleThreadedState;
        if (state == null) {
            this.singleThreadedState = state = this.newDecoderState();
        }
        return state.reset();
    }

    @Override
    public Object readObject(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = this.readNextTypeDecoder(stream, state);
        if (decoder == null) {
            throw new DecodeException("Unknown type constructor in encoded bytes");
        }
        return decoder.readValue(stream, state);
    }

    @Override
    public <T> T readObject(InputStream stream, StreamDecoderState state, Class<T> clazz) throws DecodeException {
        Object result = this.readObject(stream, state);
        if (result == null) {
            return null;
        }
        if (clazz.isAssignableFrom(result.getClass())) {
            return (T)result;
        }
        throw this.signalUnexpectedType(result, clazz);
    }

    @Override
    public <T> T[] readMultiple(InputStream stream, StreamDecoderState state, Class<T> clazz) throws DecodeException {
        Object val = this.readObject(stream, state);
        if (val == null) {
            return null;
        }
        if (val.getClass().isArray()) {
            if (clazz.isAssignableFrom(val.getClass().getComponentType())) {
                return (Object[])val;
            }
            throw this.signalUnexpectedType(val, Array.newInstance(clazz, 0).getClass());
        }
        if (clazz.isAssignableFrom(val.getClass())) {
            Object[] array = (Object[])Array.newInstance(clazz, 1);
            array[0] = val;
            return array;
        }
        throw this.signalUnexpectedType(val, Array.newInstance(clazz, 0).getClass());
    }

    @Override
    public StreamTypeDecoder<?> readNextTypeDecoder(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        if (encodingCode == 0) {
            if (stream.markSupported()) {
                stream.mark(64);
                try {
                    long result = this.readUnsignedLong(stream, state, this.amqpTypeDecoders.length);
                    if (result > 0L && result < (long)this.amqpTypeDecoders.length && this.amqpTypeDecoders[(int)result] != null) {
                        return this.amqpTypeDecoders[(int)result];
                    }
                    ProtonStreamUtils.reset(stream);
                    return this.slowReadNextTypeDecoder(stream, state);
                }
                catch (Exception e) {
                    ProtonStreamUtils.reset(stream);
                    return this.slowReadNextTypeDecoder(stream, state);
                }
            }
            return this.slowReadNextTypeDecoder(stream, state);
        }
        return primitiveDecoders[encodingCode & 0xFF];
    }

    private StreamTypeDecoder<?> slowReadNextTypeDecoder(InputStream stream, StreamDecoderState state) throws DecodeException {
        Comparable<UnsignedLong> descriptor;
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 83: {
                descriptor = UnsignedLong.valueOf((long)ProtonStreamUtils.readByte(stream) & 0xFFL);
                break;
            }
            case -128: {
                descriptor = UnsignedLong.valueOf(ProtonStreamUtils.readLong(stream));
                break;
            }
            case -93: {
                descriptor = symbol8Decoder.readValue(stream, state);
                break;
            }
            case -77: {
                descriptor = symbol32Decoder.readValue(stream, state);
                break;
            }
            default: {
                throw new DecodeException("Expected Descriptor type but found encoding: " + EncodingCodes.toString(encodingCode));
            }
        }
        StreamTypeDecoder<?> streamTypeDecoder = (StreamTypeDecoder<?>)this.describedTypeDecoders.get(descriptor);
        if (streamTypeDecoder == null) {
            streamTypeDecoder = this.handleUnknownDescribedType(descriptor);
        }
        return streamTypeDecoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamTypeDecoder<?> peekNextTypeDecoder(InputStream stream, StreamDecoderState state) throws DecodeException {
        if (stream.markSupported()) {
            stream.mark(64);
            try {
                StreamTypeDecoder<?> streamTypeDecoder = this.readNextTypeDecoder(stream, state);
                return streamTypeDecoder;
            }
            finally {
                try {
                    stream.reset();
                }
                catch (IOException e) {
                    throw new DecodeException("Error while resetting marked stream", e);
                }
            }
        }
        throw new UnsupportedOperationException("The provided stream doesn't support stream marks");
    }

    @Override
    public <V> ProtonStreamDecoder registerDescribedTypeDecoder(StreamDescribedTypeDecoder<V> decoder) {
        StreamDescribedTypeDecoder<V> describedTypeDecoder = decoder;
        if (decoder.getDescriptorCode().compareTo(this.amqpTypeDecoders.length) < 0) {
            this.amqpTypeDecoders[decoder.getDescriptorCode().intValue()] = decoder;
        }
        this.describedTypeDecoders.put(describedTypeDecoder.getDescriptorCode(), describedTypeDecoder);
        this.describedTypeDecoders.put(describedTypeDecoder.getDescriptorSymbol(), describedTypeDecoder);
        return this;
    }

    @Override
    public Boolean readBoolean(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 65: {
                return Boolean.TRUE;
            }
            case 66: {
                return Boolean.FALSE;
            }
            case 86: {
                return ProtonStreamUtils.readByte(stream) == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Boolean type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public boolean readBoolean(InputStream stream, StreamDecoderState state, boolean defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 65: {
                return true;
            }
            case 66: {
                return false;
            }
            case 86: {
                return ProtonStreamUtils.readByte(stream) != 0;
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Boolean type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Byte readByte(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 81: {
                return ProtonStreamUtils.readByte(stream);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Byte type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public byte readByte(InputStream stream, StreamDecoderState state, byte defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 81: {
                return ProtonStreamUtils.readByte(stream);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Byte type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public UnsignedByte readUnsignedByte(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 80: {
                return UnsignedByte.valueOf(ProtonStreamUtils.readByte(stream));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Unsigned Byte type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public byte readUnsignedByte(InputStream stream, StreamDecoderState state, byte defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 80: {
                return ProtonStreamUtils.readByte(stream);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Byte type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Character readCharacter(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 115: {
                return Character.valueOf((char)(ProtonStreamUtils.readInt(stream) & 0xFFFF));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Character type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public char readCharacter(InputStream stream, StreamDecoderState state, char defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 115: {
                return (char)(ProtonStreamUtils.readInt(stream) & 0xFFFF);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Character type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Decimal32 readDecimal32(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 116: {
                return new Decimal32(ProtonStreamUtils.readInt(stream));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Decimal32 type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Decimal64 readDecimal64(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -124: {
                return new Decimal64(ProtonStreamUtils.readLong(stream));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Decimal64 type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Decimal128 readDecimal128(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -108: {
                return new Decimal128(ProtonStreamUtils.readLong(stream), ProtonStreamUtils.readLong(stream));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Decimal128 type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Short readShort(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 97: {
                return ProtonStreamUtils.readShort(stream);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Short type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public short readShort(InputStream stream, StreamDecoderState state, short defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 97: {
                return ProtonStreamUtils.readShort(stream);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Short type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public UnsignedShort readUnsignedShort(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 96: {
                return UnsignedShort.valueOf(ProtonStreamUtils.readShort(stream));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Unsigned Short type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public short readUnsignedShort(InputStream stream, StreamDecoderState state, short defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 96: {
                return ProtonStreamUtils.readShort(stream);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Short type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public int readUnsignedShort(InputStream stream, StreamDecoderState state, int defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 96: {
                return ProtonStreamUtils.readShort(stream) & 0xFFFF;
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Short type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Integer readInteger(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 84: {
                return ProtonStreamUtils.readByte(stream);
            }
            case 113: {
                return ProtonStreamUtils.readInt(stream);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Integer type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public int readInteger(InputStream stream, StreamDecoderState state, int defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 84: {
                return ProtonStreamUtils.readByte(stream);
            }
            case 113: {
                return ProtonStreamUtils.readInt(stream);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Integer type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public UnsignedInteger readUnsignedInteger(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 67: {
                return UnsignedInteger.ZERO;
            }
            case 82: {
                return UnsignedInteger.valueOf(ProtonStreamUtils.readByte(stream) & 0xFF);
            }
            case 112: {
                return UnsignedInteger.valueOf(ProtonStreamUtils.readInt(stream));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Unsigned Integer type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public int readUnsignedInteger(InputStream stream, StreamDecoderState state, int defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 67: {
                return 0;
            }
            case 82: {
                return ProtonStreamUtils.readByte(stream) & 0xFF;
            }
            case 112: {
                return ProtonStreamUtils.readInt(stream);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Integer type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public long readUnsignedInteger(InputStream stream, StreamDecoderState state, long defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 67: {
                return 0L;
            }
            case 82: {
                return (long)ProtonStreamUtils.readByte(stream) & 0xFFL;
            }
            case 112: {
                return (long)ProtonStreamUtils.readInt(stream) & 0xFFFFFFFFL;
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Integer type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Long readLong(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 85: {
                return ProtonStreamUtils.readByte(stream);
            }
            case -127: {
                return ProtonStreamUtils.readLong(stream);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Long type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public long readLong(InputStream stream, StreamDecoderState state, long defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 85: {
                return ProtonStreamUtils.readByte(stream);
            }
            case -127: {
                return ProtonStreamUtils.readLong(stream);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Long type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public UnsignedLong readUnsignedLong(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 68: {
                return UnsignedLong.ZERO;
            }
            case 83: {
                return UnsignedLong.valueOf((long)ProtonStreamUtils.readByte(stream) & 0xFFL);
            }
            case -128: {
                return UnsignedLong.valueOf(ProtonStreamUtils.readLong(stream));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Unsigned Long type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public long readUnsignedLong(InputStream stream, StreamDecoderState state, long defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 68: {
                return 0L;
            }
            case 83: {
                return (long)ProtonStreamUtils.readByte(stream) & 0xFFL;
            }
            case -128: {
                return ProtonStreamUtils.readLong(stream);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Long type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Float readFloat(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 114: {
                return Float.valueOf(Float.intBitsToFloat(ProtonStreamUtils.readInt(stream)));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Float type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public float readFloat(InputStream stream, StreamDecoderState state, float defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 114: {
                return Float.intBitsToFloat(ProtonStreamUtils.readInt(stream));
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Float type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Double readDouble(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -126: {
                return Double.longBitsToDouble(ProtonStreamUtils.readLong(stream));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Double type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public double readDouble(InputStream stream, StreamDecoderState state, double defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -126: {
                return Double.longBitsToDouble(ProtonStreamUtils.readLong(stream));
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Double type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Binary readBinary(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -96: {
                return binary8Decoder.readValue(stream, state);
            }
            case -80: {
                return binary32Decoder.readValue(stream, state);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Binary type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public ProtonBuffer readBinaryAsBuffer(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -96: {
                return binary8Decoder.readValueAsBuffer(stream, state);
            }
            case -80: {
                return binary32Decoder.readValueAsBuffer(stream, state);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Binary type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public DeliveryTag readDeliveryTag(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -96: {
                return new DeliveryTag.ProtonDeliveryTag(binary8Decoder.readValueAsArray(stream, state));
            }
            case -80: {
                return new DeliveryTag.ProtonDeliveryTag(binary32Decoder.readValueAsArray(stream, state));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Binary type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public String readString(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -95: {
                return string8Decoder.readValue(stream, state);
            }
            case -79: {
                return string32Decoder.readValue(stream, state);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected String type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Symbol readSymbol(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -93: {
                return symbol8Decoder.readValue(stream, state);
            }
            case -77: {
                return symbol32Decoder.readValue(stream, state);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Symbol type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public String readSymbol(InputStream stream, StreamDecoderState state, String defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -93: {
                return symbol8Decoder.readString(stream, state);
            }
            case -77: {
                return symbol32Decoder.readString(stream, state);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Symbol type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Long readTimestamp(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -125: {
                return ProtonStreamUtils.readLong(stream);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Timestamp type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public long readTimestamp(InputStream stream, StreamDecoderState state, long defaultValue) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -125: {
                return ProtonStreamUtils.readLong(stream);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Timestamp type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public UUID readUUID(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -104: {
                return new UUID(ProtonStreamUtils.readLong(stream), ProtonStreamUtils.readLong(stream));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected UUID type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public <K, V> Map<K, V> readMap(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case -63: {
                return map8Decoder.readValue(stream, state);
            }
            case -47: {
                return map32Decoder.readValue(stream, state);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Map type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public <V> List<V> readList(InputStream stream, StreamDecoderState state) throws DecodeException {
        byte encodingCode = ProtonStreamUtils.readEncodingCode(stream);
        switch (encodingCode) {
            case 69: {
                return Collections.emptyList();
            }
            case -64: {
                return list8Decoder.readValue(stream, state);
            }
            case -48: {
                return list32Decoder.readValue(stream, state);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected List type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    private ClassCastException signalUnexpectedType(Object val, Class<?> clazz) {
        return new ClassCastException("Unexpected type " + val.getClass().getName() + ". Expected " + clazz.getName() + ".");
    }

    private StreamTypeDecoder<?> handleUnknownDescribedType(final Object descriptor) {
        UnknownDescribedTypeDecoder streamTypeDecoder = new UnknownDescribedTypeDecoder(){

            @Override
            public Object getDescriptor() {
                return descriptor;
            }
        };
        this.describedTypeDecoders.put(descriptor, streamTypeDecoder);
        return streamTypeDecoder;
    }

    static {
        ProtonStreamDecoder.primitiveDecoders[86] = new BooleanTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[65] = new BooleanTrueTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[66] = new BooleanFalseTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[160] = new Binary8TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[176] = new Binary32TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[81] = new ByteTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[115] = new CharacterTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[116] = new Decimal32TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[132] = new Decimal64TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[148] = new Decimal128TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[130] = new DoubleTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[114] = new FloatTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[64] = new NullTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[97] = new ShortTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[84] = new Integer8TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[113] = new Integer32TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[85] = new Long8TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[129] = new LongTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[80] = new UnsignedByteTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[96] = new UnsignedShortTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[67] = new UnsignedInteger0TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[82] = new UnsignedInteger8TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[112] = new UnsignedInteger32TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[68] = new UnsignedLong0TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[83] = new UnsignedLong8TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[128] = new UnsignedLong64TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[161] = new String8TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[177] = new String32TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[163] = new Symbol8TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[179] = new Symbol32TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[152] = new UUIDTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[131] = new TimestampTypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[69] = new List0TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[192] = new List8TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[208] = new List32TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[193] = new Map8TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[209] = new Map32TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[224] = new Array8TypeDecoder();
        ProtonStreamDecoder.primitiveDecoders[240] = new Array32TypeDecoder();
        symbol8Decoder = (Symbol8TypeDecoder)primitiveDecoders[163];
        symbol32Decoder = (Symbol32TypeDecoder)primitiveDecoders[179];
        binary8Decoder = (Binary8TypeDecoder)primitiveDecoders[160];
        binary32Decoder = (Binary32TypeDecoder)primitiveDecoders[176];
        list8Decoder = (List8TypeDecoder)primitiveDecoders[192];
        list32Decoder = (List32TypeDecoder)primitiveDecoders[208];
        map8Decoder = (Map8TypeDecoder)primitiveDecoders[193];
        map32Decoder = (Map32TypeDecoder)primitiveDecoders[209];
        string32Decoder = (String32TypeDecoder)primitiveDecoders[177];
        string8Decoder = (String8TypeDecoder)primitiveDecoders[161];
    }
}

