/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.QpidServiceLoader;

public class MessageConverterRegistry {
    private static final Map<Class<? extends ServerMessage>, Map<Class<? extends ServerMessage>, MessageConverter>> CONVERTERS = new HashMap<Class<? extends ServerMessage>, Map<Class<? extends ServerMessage>, MessageConverter>>();

    public static <M extends ServerMessage, N extends ServerMessage> MessageConverter<M, N> getConverter(Class<M> from, Class<N> to) {
        Map<Class<? extends ServerMessage>, MessageConverter> map = CONVERTERS.get(from);
        if (map == null) {
            map = CONVERTERS.get(ServerMessage.class);
        }
        return map == null ? null : map.get(to);
    }

    static {
        for (MessageConverter converter : new QpidServiceLoader().instancesOf(MessageConverter.class)) {
            Map<Class<? extends ServerMessage>, MessageConverter> map = CONVERTERS.get(converter.getInputClass());
            if (map == null) {
                map = new HashMap<Class<? extends ServerMessage>, MessageConverter>();
                CONVERTERS.put(converter.getInputClass(), map);
            }
            map.put(converter.getOutputClass(), converter);
        }
    }
}

