/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.filter.AMQPFilterTypes;
import org.apache.qpid.server.filter.SelectorParsingException;
import org.apache.qpid.server.filter.selector.ParseException;
import org.apache.qpid.server.filter.selector.TokenMgrError;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.NotFoundException;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.StandardSendingDestination;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Accepted;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ExactSubjectFilter;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Filter;
import org.apache.qpid.server.protocol.v1_0.type.messaging.JMSSelectorFilter;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MatchingSubjectFilter;
import org.apache.qpid.server.protocol.v1_0.type.messaging.NoLocalFilter;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Rejected;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusExpiryPolicy;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

public class ExchangeSendingDestination
extends StandardSendingDestination {
    private static final Accepted ACCEPTED = new Accepted();
    private static final Rejected REJECTED = new Rejected();
    private static final Outcome[] OUTCOMES = new Outcome[]{ACCEPTED, REJECTED};
    public static final Symbol TOPIC_CAPABILITY = Symbol.getSymbol("topic");
    private final Exchange<?> _exchange;
    private final Symbol[] _capabilities;
    private final Map<Symbol, Filter> _filters;

    ExchangeSendingDestination(Exchange<?> exchange, String linkName, String bindingKey, String remoteContainerId, Source source) throws AmqpErrorException {
        this(exchange, bindingKey, source, ExchangeSendingDestination.getMangledSubscriptionName(linkName, remoteContainerId, source));
    }

    private ExchangeSendingDestination(Exchange<?> exchange, String bindingKey, Source source, String subscriptionName) throws AmqpErrorException {
        this(exchange, source, subscriptionName, ExchangeSendingDestination.createBindingInfo(exchange, subscriptionName, bindingKey, source));
    }

    private ExchangeSendingDestination(Exchange<?> exchange, Source source, String subscriptionName, BindingInfo bindingInfo) throws AmqpErrorException {
        this(exchange, ExchangeSendingDestination.getQueue(exchange, source, subscriptionName, bindingInfo), bindingInfo, source.getCapabilities());
    }

    private ExchangeSendingDestination(Exchange<?> exchange, Queue<?> queue, BindingInfo bindingInfo, Symbol[] capabilities) {
        super((MessageSource)queue);
        this._exchange = exchange;
        this._filters = bindingInfo.getActualFilters().isEmpty() ? null : bindingInfo.getActualFilters();
        ArrayList<Symbol> sourceCapabilities = new ArrayList<Symbol>();
        if (ExchangeSendingDestination.hasCapability(capabilities, Session_1_0.GLOBAL_CAPABILITY)) {
            sourceCapabilities.add(Session_1_0.GLOBAL_CAPABILITY);
        }
        if (ExchangeSendingDestination.hasCapability(capabilities, Session_1_0.SHARED_CAPABILITY)) {
            sourceCapabilities.add(Session_1_0.SHARED_CAPABILITY);
        }
        sourceCapabilities.add(TOPIC_CAPABILITY);
        this._capabilities = sourceCapabilities.toArray(new Symbol[sourceCapabilities.size()]);
    }

    private static BindingInfo createBindingInfo(Exchange<?> exchange, String subscriptionName, String bindingKey, Source source) throws AmqpErrorException {
        return new BindingInfo(exchange, subscriptionName, bindingKey, source.getFilter());
    }

    private static String getMangledSubscriptionName(String linkName, String remoteContainerId, Source source) {
        boolean isDurable = source.getExpiryPolicy() == TerminusExpiryPolicy.NEVER;
        boolean isShared = ExchangeSendingDestination.hasCapability(source.getCapabilities(), Session_1_0.SHARED_CAPABILITY);
        boolean isGlobal = ExchangeSendingDestination.hasCapability(source.getCapabilities(), Session_1_0.GLOBAL_CAPABILITY);
        return ExchangeSendingDestination.getMangledSubscriptionName(linkName, isDurable, isShared, isGlobal, remoteContainerId);
    }

    private static Queue<?> getQueue(Exchange<?> exchange, Source source, String subscriptionName, BindingInfo bindingInfo) throws AmqpErrorException {
        Queue queue;
        boolean isDurable = source.getExpiryPolicy() == TerminusExpiryPolicy.NEVER;
        boolean isShared = ExchangeSendingDestination.hasCapability(source.getCapabilities(), Session_1_0.SHARED_CAPABILITY);
        if (!(exchange.getAddressSpace() instanceof QueueManagingVirtualHost)) {
            throw new AmqpErrorException(new Error(AmqpError.INTERNAL_ERROR, "Address space of unexpected type"));
        }
        QueueManagingVirtualHost virtualHost = (QueueManagingVirtualHost)exchange.getAddressSpace();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        ExclusivityPolicy exclusivityPolicy = isShared ? ExclusivityPolicy.SHARED_SUBSCRIPTION : ExclusivityPolicy.LINK;
        LifetimePolicy lifetimePolicy = ExchangeSendingDestination.getLifetimePolicy(source.getExpiryPolicy());
        attributes.put("id", UUID.randomUUID());
        attributes.put("name", subscriptionName);
        attributes.put("lifetimePolicy", lifetimePolicy);
        attributes.put("exclusive", exclusivityPolicy);
        attributes.put("durable", isDurable);
        Map<String, Map<String, Object>> bindings = bindingInfo.getBindings();
        try {
            queue = virtualHost.getSubscriptionQueue(exchange.getName(), attributes, bindings);
        }
        catch (NotFoundException e) {
            throw new AmqpErrorException(new Error(AmqpError.NOT_FOUND, e.getMessage()));
        }
        catch (IllegalStateException e) {
            throw new AmqpErrorException(new Error(AmqpError.RESOURCE_LOCKED, "Subscription is already in use"));
        }
        return queue;
    }

    private static boolean hasCapability(Symbol[] capabilities, Symbol expectedCapability) {
        return capabilities != null && Arrays.asList(capabilities).contains(expectedCapability);
    }

    private static LifetimePolicy getLifetimePolicy(TerminusExpiryPolicy expiryPolicy) throws AmqpErrorException {
        LifetimePolicy lifetimePolicy;
        if (expiryPolicy == null || expiryPolicy == TerminusExpiryPolicy.SESSION_END) {
            lifetimePolicy = LifetimePolicy.DELETE_ON_SESSION_END;
        } else if (expiryPolicy == TerminusExpiryPolicy.LINK_DETACH) {
            lifetimePolicy = LifetimePolicy.DELETE_ON_NO_OUTBOUND_LINKS;
        } else if (expiryPolicy == TerminusExpiryPolicy.CONNECTION_CLOSE) {
            lifetimePolicy = LifetimePolicy.DELETE_ON_CONNECTION_CLOSE;
        } else if (expiryPolicy == TerminusExpiryPolicy.NEVER) {
            lifetimePolicy = LifetimePolicy.PERMANENT;
        } else {
            Error error = new Error(AmqpError.NOT_IMPLEMENTED, String.format("unknown ExpiryPolicy '%s'", expiryPolicy.getValue()));
            throw new AmqpErrorException(error);
        }
        return lifetimePolicy;
    }

    private static String getMangledSubscriptionName(String linkName, boolean isDurable, boolean isShared, boolean isGlobal, String remoteContainerId) {
        String subscriptionName;
        remoteContainerId = isGlobal ? "_global_" : ExchangeSendingDestination.sanitizeName(remoteContainerId);
        if (!isDurable && !isShared) {
            subscriptionName = UUID.randomUUID().toString();
        } else {
            int separator;
            subscriptionName = linkName;
            if (isShared && (separator = subscriptionName.indexOf("|")) > 0) {
                subscriptionName = subscriptionName.substring(0, separator);
            }
            subscriptionName = ExchangeSendingDestination.sanitizeName(subscriptionName);
        }
        return "qpidsub_/" + remoteContainerId + "_/" + subscriptionName + "_/" + (isDurable ? "durable" : "nondurable");
    }

    private static String sanitizeName(String name) {
        return name.replace("_", "__").replace(".", "_:").replace("(", "_O").replace(")", "_C").replace("<", "_L").replace(">", "_R");
    }

    @Override
    public Outcome[] getOutcomes() {
        return OUTCOMES;
    }

    public Exchange<?> getExchange() {
        return this._exchange;
    }

    Map<Symbol, Filter> getFilters() {
        return this._filters == null ? null : Collections.unmodifiableMap(this._filters);
    }

    @Override
    public Symbol[] getCapabilities() {
        return this._capabilities;
    }

    public Queue<?> getQueue() {
        return (Queue)this.getMessageSource();
    }

    private static final class BindingInfo {
        private final Map<Symbol, Filter> _actualFilters = new HashMap<Symbol, Filter>();
        private final Map<String, Map<String, Object>> _bindings = new HashMap<String, Map<String, Object>>();

        BindingInfo(Exchange<?> exchange, String queueName, String bindingKey, Map<Symbol, Filter> filters) throws AmqpErrorException {
            String binding = null;
            HashMap<String, Object> arguments = new HashMap<String, Object>();
            if (filters != null && !filters.isEmpty()) {
                boolean hasBindingFilter = false;
                boolean hasMessageFilter = false;
                for (Map.Entry<Symbol, Filter> entry : filters.entrySet()) {
                    Filter filter;
                    if (!hasBindingFilter && entry.getValue() instanceof ExactSubjectFilter && exchange.getType().equals("direct")) {
                        filter = (ExactSubjectFilter)entry.getValue();
                        binding = ((ExactSubjectFilter)filter).getValue();
                        this._actualFilters.put(entry.getKey(), filter);
                        hasBindingFilter = true;
                        continue;
                    }
                    if (!hasBindingFilter && entry.getValue() instanceof MatchingSubjectFilter && exchange.getType().equals("topic")) {
                        filter = (MatchingSubjectFilter)entry.getValue();
                        binding = ((MatchingSubjectFilter)filter).getValue();
                        this._actualFilters.put(entry.getKey(), filter);
                        hasBindingFilter = true;
                        continue;
                    }
                    if (entry.getValue() instanceof NoLocalFilter) {
                        this._actualFilters.put(entry.getKey(), entry.getValue());
                        arguments.put(AMQPFilterTypes.NO_LOCAL.toString(), true);
                        continue;
                    }
                    if (hasMessageFilter || !(entry.getValue() instanceof JMSSelectorFilter)) continue;
                    JMSSelectorFilter selectorFilter = (JMSSelectorFilter)entry.getValue();
                    try {
                        new org.apache.qpid.server.filter.JMSSelectorFilter(selectorFilter.getValue());
                    }
                    catch (SelectorParsingException | ParseException | TokenMgrError e) {
                        Error error = new Error();
                        error.setCondition(AmqpError.INVALID_FIELD);
                        error.setDescription("Invalid JMS Selector: " + selectorFilter.getValue());
                        error.setInfo(Collections.singletonMap(Symbol.valueOf("field"), Symbol.valueOf("filter")));
                        throw new AmqpErrorException(error);
                    }
                    arguments.put(AMQPFilterTypes.JMS_SELECTOR.toString(), selectorFilter.getValue());
                    this._actualFilters.put(entry.getKey(), selectorFilter);
                    hasMessageFilter = true;
                }
            }
            if (binding != null) {
                this._bindings.put(binding, arguments);
            }
            if (bindingKey != null) {
                this._bindings.put(bindingKey, arguments);
            }
            if (binding == null && bindingKey == null && exchange.getType().equals("fanout")) {
                this._bindings.put(queueName, arguments);
            } else if (binding == null && bindingKey == null && exchange.getType().equals("topic")) {
                this._bindings.put("#", arguments);
            }
        }

        Map<Symbol, Filter> getActualFilters() {
            return this._actualFilters;
        }

        Map<String, Map<String, Object>> getBindings() {
            return this._bindings;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BindingInfo that = (BindingInfo)o;
            return this._actualFilters.equals(that._actualFilters) && this._bindings.equals(that._bindings);
        }

        public int hashCode() {
            int result = this._actualFilters.hashCode();
            result = 31 * result + this._bindings.hashCode();
            return result;
        }
    }
}

