/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.WriteOptions;
import com.sleepycat.je.dbi.TTL;
import java.util.concurrent.TimeUnit;

public class ExpirationInfo {
    public static final ExpirationInfo DEFAULT = new ExpirationInfo(0, false, false);
    public final int expiration;
    public final boolean expirationInHours;
    public final boolean updateExpiration;
    private boolean expirationUpdated = false;
    private long oldExpirationTime = 0L;

    public ExpirationInfo(int expiration, boolean expirationInHours, boolean updateExpiration) {
        this.expiration = expiration;
        this.expirationInHours = expirationInHours;
        this.updateExpiration = updateExpiration;
    }

    public static ExpirationInfo getInfo(WriteOptions options) {
        if (options.getTTL() == 0 && !options.getUpdateTTL()) {
            return null;
        }
        return new ExpirationInfo(TTL.ttlToExpiration(options.getTTL(), options.getTTLUnit()), options.getTTLUnit() == TimeUnit.HOURS, options.getUpdateTTL());
    }

    public void setExpirationUpdated(boolean val) {
        this.expirationUpdated = val;
    }

    public boolean getExpirationUpdated() {
        return this.expirationUpdated;
    }

    public void setOldExpirationTime(long val) {
        this.oldExpirationTime = val;
    }

    public long getOldExpirationTime() {
        return this.oldExpirationTime;
    }
}

