# PIP-177: Add the classLoader field for SchemaDefinition

Mailing list thread: https://lists.apache.org/thread/ydslz3h8ymjjwm5ng02kwszmc5j5hy30

## Motivation

Now, don‘t register logical type conversions when use `SchemaDefinition.<T>builder().withJsonDef()` to create the schema, beacase it without classLoader param. (e.g: https://github.com/apache/pulsar/issues/15899)

See: https://github.com/apache/pulsar/blob/04aa9e8e51869d1621a7e25402a656084eebfc09/pulsar-client/src/main/java/org/apache/pulsar/client/impl/schema/reader/AvroReader.java#L58-L68

We can add the classLoader field for SchemaDefinition, user can manually pass a classLoader to register logical type conversions

## Goal

This proposes to add the classLoader field for SchemaDefinition. When using `SchemaDefinition.<T>builder().withJsonDef()` to create the schema it must manually specify a classLoader otherwise, the converter will not work.

The priority of the classLoader field will be higher than by the `pojoClass.getClassLoader()`.

## API Changes

```java
public class SchemaDefinitionBuilder {
    //....

    /**
     * Set schema of pojo classLoader.
     *
     * @param classLoader pojo classLoader
     *
     * @return schema definition builder
     */
    SchemaDefinitionBuilder<T> withClassLoader(ClassLoader classLoader);
}
```

```java
public class SchemaDefinition {
    //....

    /**
     * Get pojo classLoader.
     *
     * @return pojo schema
     */
    ClassLoader getClassLoader();
}
```

## Implementation

Add the classloader field for SchemaDefinition.
