/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.protocol;

import io.grpc.Metadata;
import org.apache.bookkeeper.common.grpc.netty.IdentityBinaryMarshaller;
import org.apache.bookkeeper.common.grpc.netty.LongBinaryMarshaller;
import org.apache.bookkeeper.stream.proto.FixedRangeSplitPolicy;
import org.apache.bookkeeper.stream.proto.RangeKeyType;
import org.apache.bookkeeper.stream.proto.RetentionPolicy;
import org.apache.bookkeeper.stream.proto.SegmentRollingPolicy;
import org.apache.bookkeeper.stream.proto.SizeBasedSegmentRollingPolicy;
import org.apache.bookkeeper.stream.proto.SplitPolicy;
import org.apache.bookkeeper.stream.proto.StreamConfiguration;
import org.apache.bookkeeper.stream.proto.TimeBasedRetentionPolicy;

public final class ProtocolConstants {
    public static final String SCHEME = "stream";
    public static final long ROOT_STORAGE_CONTAINER_ID = 0L;
    public static final long ROOT_STREAM_ID = 0L;
    public static final long ROOT_RANGE_ID = 0L;
    public static final long CONTAINER_META_STREAM_ID = 1L;
    public static final long CONTAINER_META_RANGE_ID = 0L;
    public static final int DEFAULT_NUM_STORAGE_CONTAINERS = 1024;
    public static final long INVALID_STORAGE_CONTAINER_ID = -1L;
    public static final long INVALID_NAMESPACE_ID = -1L;
    public static final long INVALID_STREAM_ID = -1L;
    public static final long INVALID_RANGE_ID = -1L;
    public static final long MIN_DATA_RANGE_ID = 1024L;
    public static final long MIN_DATA_STREAM_ID = 1024L;
    public static final SplitPolicy DEFAULT_SPLIT_POLICY = SplitPolicy.newBuilder().setFixedRangePolicy(FixedRangeSplitPolicy.newBuilder().setNumRanges(2)).build();
    public static final SegmentRollingPolicy DEFAULT_SEGMENT_ROLLING_POLICY = SegmentRollingPolicy.newBuilder().setSizePolicy(SizeBasedSegmentRollingPolicy.newBuilder().setMaxSegmentSize(0x8000000L)).build();
    public static final RetentionPolicy DEFAULT_RETENTION_POLICY = RetentionPolicy.newBuilder().setTimePolicy(TimeBasedRetentionPolicy.newBuilder().setRetentionMinutes(-1L)).build();
    public static final int INIT_NUM_RANGES = 24;
    public static final int MIN_NUM_RANGES = 24;
    public static final StreamConfiguration DEFAULT_STREAM_CONF = StreamConfiguration.newBuilder().setKeyType(RangeKeyType.HASH).setInitialNumRanges(24).setMinNumRanges(24).setRetentionPolicy(DEFAULT_RETENTION_POLICY).setRollingPolicy(DEFAULT_SEGMENT_ROLLING_POLICY).setSplitPolicy(DEFAULT_SPLIT_POLICY).build();
    public static final String SC_ID_KEY = "bk-rt-sc-id-bin";
    public static final String ROUTING_KEY = "bk-rt-key-bin";
    public static final String STREAM_ID_KEY = "bk-rt-sid-bin";
    public static final String RANGE_ID_KEY = "bk-rt-rid-bin";
    public static final Metadata.Key<Long> SCID_METADATA_KEY = Metadata.Key.of((String)"bk-rt-sc-id-bin", (Metadata.BinaryMarshaller)LongBinaryMarshaller.of());
    public static final Metadata.Key<Long> RID_METADATA_KEY = Metadata.Key.of((String)"bk-rt-rid-bin", (Metadata.BinaryMarshaller)LongBinaryMarshaller.of());
    public static final Metadata.Key<Long> SID_METADATA_KEY = Metadata.Key.of((String)"bk-rt-sid-bin", (Metadata.BinaryMarshaller)LongBinaryMarshaller.of());
    public static final Metadata.Key<byte[]> RK_METADATA_KEY = Metadata.Key.of((String)"bk-rt-key-bin", (Metadata.BinaryMarshaller)IdentityBinaryMarshaller.of());

    private ProtocolConstants() {
    }
}

