/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.EventLoop;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderResult;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.EmptyHttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObject;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import java.util.function.Supplier;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Vertx;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.buffer.Buffer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpHeaders;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpMethod;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpServerOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpServerRequest;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.ServerWebSocket;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.Http1xConnectionBase;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.Http1xServerRequest;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpChunkContentCompressor;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpServerConnection;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpUtils;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.ServerWebSocketImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.future.PromiseInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.Logger;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.LoggerFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.NetSocket;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.NetSocketImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.SslChannelProvider;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.VertxHandler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.metrics.HttpServerMetrics;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.metrics.Metrics;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.tracing.VertxTracer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.tracing.TracingPolicy;

public class Http1xServerConnection
extends Http1xConnectionBase<ServerWebSocketImpl>
implements HttpServerConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerConnection.class);
    private final String serverOrigin;
    private final Supplier<ContextInternal> streamContextSupplier;
    private final SslChannelProvider sslChannelProvider;
    private final TracingPolicy tracingPolicy;
    private boolean requestFailed;
    private Http1xServerRequest requestInProgress;
    private Http1xServerRequest responseInProgress;
    private boolean keepAlive;
    private boolean channelPaused;
    private boolean writable;
    private Handler<HttpServerRequest> requestHandler;
    private Handler<HttpServerRequest> invalidRequestHandler;
    final HttpServerMetrics metrics;
    final boolean handle100ContinueAutomatically;
    final HttpServerOptions options;

    public Http1xServerConnection(Supplier<ContextInternal> streamContextSupplier, SslChannelProvider sslChannelProvider, HttpServerOptions options, ChannelHandlerContext chctx, ContextInternal context, String serverOrigin, HttpServerMetrics metrics) {
        super(context, chctx);
        this.serverOrigin = serverOrigin;
        this.streamContextSupplier = streamContextSupplier;
        this.options = options;
        this.sslChannelProvider = sslChannelProvider;
        this.metrics = metrics;
        this.handle100ContinueAutomatically = options.isHandle100ContinueAutomatically();
        this.tracingPolicy = options.getTracingPolicy();
        this.writable = true;
        this.keepAlive = true;
    }

    TracingPolicy tracingPolicy() {
        return this.tracingPolicy;
    }

    @Override
    public HttpServerConnection handler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
        return this;
    }

    @Override
    public HttpServerConnection invalidRequestHandler(Handler<HttpServerRequest> handler) {
        this.invalidRequestHandler = handler;
        return this;
    }

    @Override
    public HttpServerMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void handleMessage(Object msg) {
        assert (msg != null);
        if (this.requestInProgress == null && !this.keepAlive && this.webSocket == null) {
            return;
        }
        if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            this.onEnd();
        } else if (msg instanceof DefaultHttpRequest) {
            Http1xServerRequest req;
            DefaultHttpRequest request = (DefaultHttpRequest)msg;
            ContextInternal requestCtx = this.streamContextSupplier.get();
            this.requestInProgress = req = new Http1xServerRequest(this, (HttpRequest)request, requestCtx);
            if (this.responseInProgress != null) {
                this.enqueueRequest(req);
                return;
            }
            this.responseInProgress = this.requestInProgress;
            this.keepAlive = HttpUtils.isKeepAlive((HttpRequest)request);
            req.handleBegin(this.writable, this.keepAlive);
            Handler<HttpServerRequest> handler = request.decoderResult().isSuccess() ? this.requestHandler : this.invalidRequestHandler;
            req.context.emit(req, handler);
        } else {
            this.handleOther(msg);
        }
    }

    private void enqueueRequest(Http1xServerRequest req) {
        this.responseInProgress.enqueue(req);
        req.pause();
    }

    private void handleOther(Object msg) {
        if (msg instanceof DefaultHttpContent || msg instanceof HttpContent) {
            this.onContent(msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWsFrame((WebSocketFrame)msg);
        }
    }

    private void onContent(Object msg) {
        HttpContent content = (HttpContent)msg;
        if (!content.decoderResult().isSuccess()) {
            this.handleError((HttpObject)content);
            return;
        }
        Buffer buffer = Buffer.buffer(VertxHandler.safeBuffer(content.content()));
        Http1xServerRequest request = this.requestInProgress;
        request.context.execute(buffer, request::handleContent);
        if (content instanceof LastHttpContent) {
            this.onEnd();
        }
    }

    private void onEnd() {
        Http1xServerRequest request = this.requestInProgress;
        this.requestInProgress = null;
        boolean close = !this.keepAlive && this.responseInProgress == null;
        request.context.execute(request, Http1xServerRequest::handleEnd);
        if (close) {
            this.flushAndClose();
        }
    }

    private void flushAndClose() {
        ChannelPromise channelFuture = this.channelFuture();
        this.writeToChannel((Object)Unpooled.EMPTY_BUFFER, channelFuture);
        channelFuture.addListener(fut -> this.close());
    }

    void responseComplete() {
        EventLoop eventLoop = this.context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            if (Metrics.METRICS_ENABLED) {
                this.reportResponseComplete();
            }
            Http1xServerRequest request = this.responseInProgress;
            this.responseInProgress = null;
            DecoderResult result = request.decoderResult();
            if (result.isSuccess()) {
                if (this.keepAlive) {
                    Http1xServerRequest next = request.next();
                    if (next != null) {
                        this.handleNext(next);
                    }
                } else if (this.requestInProgress != request && this.webSocket == null) {
                    this.flushAndClose();
                }
            } else {
                ChannelPromise channelFuture = this.channelFuture();
                this.writeToChannel((Object)Unpooled.EMPTY_BUFFER, channelFuture);
                channelFuture.addListener(fut -> this.fail(result.cause()));
            }
        } else {
            eventLoop.execute(this::responseComplete);
        }
    }

    private void handleNext(Http1xServerRequest next) {
        this.responseInProgress = next;
        this.keepAlive = HttpUtils.isKeepAlive(next.nettyRequest());
        next.handleBegin(this.writable, this.keepAlive);
        next.context.emit(next, next_ -> {
            next_.resume();
            Handler<HttpServerRequest> handler = next_.nettyRequest().decoderResult().isSuccess() ? this.requestHandler : this.invalidRequestHandler;
            handler.handle((HttpServerRequest)next_);
        });
    }

    @Override
    public void doPause() {
        if (!this.channelPaused) {
            this.channelPaused = true;
            super.doPause();
        }
    }

    @Override
    public void doResume() {
        if (this.channelPaused) {
            this.channelPaused = false;
            super.doResume();
        }
    }

    private void reportResponseComplete() {
        Http1xServerRequest request = this.responseInProgress;
        if (this.metrics != null) {
            this.flushBytesWritten();
            if (this.requestFailed) {
                this.metrics.requestReset(request.metric());
                this.requestFailed = false;
            } else {
                this.metrics.responseEnd(request.metric(), request.response(), request.response().bytesWritten());
            }
        }
        VertxTracer tracer = this.context.tracer();
        Object trace = request.trace();
        if (tracer != null && trace != null) {
            tracer.sendResponse(request.context, request.response(), trace, null, HttpUtils.SERVER_RESPONSE_TAG_EXTRACTOR);
        }
    }

    String getServerOrigin() {
        return this.serverOrigin;
    }

    Vertx vertx() {
        return this.vertx;
    }

    void createWebSocket(Http1xServerRequest request, PromiseInternal<ServerWebSocket> promise) {
        this.context.execute(() -> {
            if (request != this.responseInProgress) {
                promise.fail("Invalid request");
            } else if (this.webSocket != null) {
                promise.complete((ServerWebSocket)((Object)this.webSocket));
            } else if (!(request.nettyRequest() instanceof FullHttpRequest)) {
                promise.fail(new IllegalStateException());
            } else {
                WebSocketServerHandshaker handshaker;
                try {
                    handshaker = this.createHandshaker(request);
                }
                catch (WebSocketHandshakeException e) {
                    promise.fail(e);
                    return;
                }
                this.webSocket = new ServerWebSocketImpl(promise.context(), this, handshaker.version() != WebSocketVersion.V00, this.options.getWebSocketClosingTimeout(), request, handshaker, this.options.getMaxWebSocketFrameSize(), this.options.getMaxWebSocketMessageSize(), this.options.isRegisterWebSocketWriteHandlers());
                if (Metrics.METRICS_ENABLED && this.metrics != null) {
                    ((ServerWebSocketImpl)this.webSocket).setMetric(this.metrics.connected(this.metric(), request.metric(), (ServerWebSocket)((Object)this.webSocket)));
                }
                promise.complete((ServerWebSocket)((Object)this.webSocket));
            }
        });
    }

    private WebSocketServerHandshaker createHandshaker(Http1xServerRequest request) throws WebSocketHandshakeException {
        WebSocketDecoderConfig config;
        WebSocketServerHandshakerFactory factory;
        WebSocketServerHandshaker shake;
        String wsURL;
        String connectionHeader = request.getHeader(HttpHeaders.CONNECTION);
        if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("\"Connection\" header must be \"Upgrade\".");
            throw new WebSocketHandshakeException("Invalid connection header");
        }
        if (request.method() != HttpMethod.GET) {
            request.response().setStatusCode(HttpResponseStatus.METHOD_NOT_ALLOWED.code()).end();
            throw new WebSocketHandshakeException("Invalid HTTP method");
        }
        try {
            wsURL = HttpUtils.getWebSocketLocation(request, this.isSsl());
        }
        catch (Exception e) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Invalid request URI");
            throw new WebSocketHandshakeException("Invalid WebSocket location", (Throwable)e);
        }
        String subProtocols = null;
        if (this.options.getWebSocketSubProtocols() != null) {
            subProtocols = String.join((CharSequence)",", this.options.getWebSocketSubProtocols());
        }
        if ((shake = (factory = new WebSocketServerHandshakerFactory(wsURL, subProtocols, config = WebSocketDecoderConfig.newBuilder().allowExtensions(this.options.getPerMessageWebSocketCompressionSupported() || this.options.getPerFrameWebSocketCompressionSupported()).maxFramePayloadLength(this.options.getMaxWebSocketFrameSize()).allowMaskMismatch(this.options.isAcceptUnmaskedFrames()).closeOnProtocolViolation(false).build())).newHandshaker(request.nettyRequest())) != null) {
            return shake;
        }
        request.response().putHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (CharSequence)WebSocketVersion.V13.toHttpHeaderValue()).setStatusCode(HttpResponseStatus.UPGRADE_REQUIRED.code()).end();
        throw new WebSocketHandshakeException("Invalid WebSocket version");
    }

    public void netSocket(Handler<AsyncResult<NetSocket>> handler) {
        Future<NetSocket> fut = this.netSocket();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public Future<NetSocket> netSocket() {
        PromiseInternal<NetSocket> promise = this.context.promise();
        this.netSocket((Promise<NetSocket>)promise);
        return promise.future();
    }

    void netSocket(Promise<NetSocket> promise) {
        this.context.execute(() -> {
            this.flush();
            ChannelPipeline pipeline = this.chctx.pipeline();
            ChannelHandler compressor = pipeline.get(HttpChunkContentCompressor.class);
            if (compressor != null) {
                pipeline.remove(compressor);
            }
            pipeline.remove("httpDecoder");
            if (pipeline.get("chunkedWriter") != null) {
                pipeline.remove("chunkedWriter");
            }
            pipeline.replace("handler", "handler", VertxHandler.create(ctx -> {
                NetSocketImpl socket = new NetSocketImpl(this.context, (ChannelHandlerContext)ctx, this.sslChannelProvider, this.metrics, false){

                    @Override
                    protected void handleClosed() {
                        if (Http1xServerConnection.this.metrics != null) {
                            Http1xServerRequest request = Http1xServerConnection.this.responseInProgress;
                            Http1xServerConnection.this.metrics.responseEnd(request.metric(), request.response(), request.response().bytesWritten());
                        }
                        super.handleClosed();
                    }

                    @Override
                    public synchronized void handleMessage(Object msg) {
                        if (msg instanceof HttpContent) {
                            ReferenceCountUtil.release((Object)msg);
                            return;
                        }
                        super.handleMessage(msg);
                    }
                };
                socket.metric(this.metric());
                return socket;
            }));
            pipeline.remove("httpEncoder");
            VertxHandler handler = (VertxHandler)pipeline.get("handler");
            promise.complete((NetSocket)handler.getConnection());
        });
    }

    @Override
    public void handleInterestedOpsChanged() {
        Handler<Boolean> handler;
        ContextInternal context;
        boolean bl = this.writable = !this.isNotWritable();
        if (this.responseInProgress != null) {
            context = this.responseInProgress.context;
            handler = this.responseInProgress.response()::handleWritabilityChanged;
        } else if (this.webSocket != null) {
            context = ((ServerWebSocketImpl)this.webSocket).context;
            handler = ((ServerWebSocketImpl)this.webSocket)::handleWritabilityChanged;
        } else {
            return;
        }
        context.execute(this.writable, handler);
    }

    void write100Continue() {
        this.chctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
    }

    void write103EarlyHints(io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders headers, PromiseInternal<Void> promise) {
        this.chctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EARLY_HINTS, Unpooled.buffer((int)0), headers, (io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE)).addListener(promise);
    }

    @Override
    protected void handleClosed() {
        Http1xServerRequest responseInProgress = this.responseInProgress;
        Http1xServerRequest requestInProgress = this.requestInProgress;
        ServerWebSocketImpl webSocket = (ServerWebSocketImpl)this.webSocket;
        if (requestInProgress != null) {
            requestInProgress.context.execute(v -> requestInProgress.handleException(HttpUtils.CONNECTION_CLOSED_EXCEPTION));
        }
        if (responseInProgress != null && responseInProgress != requestInProgress) {
            responseInProgress.context.execute(v -> responseInProgress.handleException(HttpUtils.CONNECTION_CLOSED_EXCEPTION));
        }
        if (webSocket != null) {
            webSocket.context.execute(v -> webSocket.handleConnectionClosed());
        }
        super.handleClosed();
    }

    @Override
    public void handleException(Throwable t) {
        super.handleException(t);
        if (Metrics.METRICS_ENABLED && this.metrics != null) {
            this.requestFailed = true;
        }
        if (this.requestInProgress != null) {
            this.requestInProgress.handleException(t);
        }
        if (this.responseInProgress != null && this.responseInProgress != this.requestInProgress) {
            this.responseInProgress.handleException(t);
        }
    }

    @Override
    protected boolean supportsFileRegion() {
        return super.supportsFileRegion() && this.chctx.pipeline().get(HttpChunkContentCompressor.class) == null;
    }

    private void handleError(HttpObject obj) {
        DecoderResult result = obj.decoderResult();
        ReferenceCountUtil.release((Object)obj);
        this.fail(result.cause());
    }
}

