/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.common.protocol.FrameDecoderUtil;
import org.apache.pulsar.common.protocol.OptionalProxyProtocolDecoder;
import org.apache.pulsar.common.util.PulsarSslConfiguration;
import org.apache.pulsar.common.util.PulsarSslFactory;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyConnection;
import org.apache.pulsar.proxy.server.ProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(ServiceChannelInitializer.class);
    public static final String TLS_HANDLER = "tls";
    private final ProxyService proxyService;
    private final boolean enableTls;
    private final boolean tlsEnabledWithKeyStore;
    private final int brokerProxyReadTimeoutMs;
    private final int maxMessageSize;
    private PulsarSslFactory sslFactory;

    public ServiceChannelInitializer(ProxyService proxyService, ProxyConfiguration serviceConfig, boolean enableTls, ScheduledExecutorService sslContextRefresher) throws Exception {
        this.proxyService = proxyService;
        this.enableTls = enableTls;
        this.tlsEnabledWithKeyStore = serviceConfig.isTlsEnabledWithKeyStore();
        this.brokerProxyReadTimeoutMs = serviceConfig.getBrokerProxyReadTimeoutMs();
        this.maxMessageSize = serviceConfig.getMaxMessageSize();
        if (enableTls) {
            PulsarSslConfiguration sslConfiguration = this.buildSslConfiguration(serviceConfig);
            this.sslFactory = (PulsarSslFactory)Class.forName(serviceConfig.getSslFactoryPlugin()).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.sslFactory.initialize(sslConfiguration);
            this.sslFactory.createInternalSslContext();
            if (serviceConfig.getTlsCertRefreshCheckDurationSec() > 0L) {
                sslContextRefresher.scheduleWithFixedDelay(this::refreshSslContext, serviceConfig.getTlsCertRefreshCheckDurationSec(), serviceConfig.getTlsCertRefreshCheckDurationSec(), TimeUnit.SECONDS);
            }
        }
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ch.pipeline().addLast("consolidation", (ChannelHandler)new FlushConsolidationHandler(1024, true));
        if (this.enableTls) {
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)new SslHandler(this.sslFactory.createServerSslEngine(ch.alloc())));
        }
        if (this.brokerProxyReadTimeoutMs > 0) {
            ch.pipeline().addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler((long)this.brokerProxyReadTimeoutMs, TimeUnit.MILLISECONDS));
        }
        if (this.proxyService.getConfiguration().isHaProxyProtocolEnabled()) {
            ch.pipeline().addLast("optional-proxy-protocol-decoder", (ChannelHandler)new OptionalProxyProtocolDecoder());
        }
        FrameDecoderUtil.addFrameDecoder((ChannelPipeline)ch.pipeline(), (int)this.maxMessageSize);
        ch.pipeline().addLast("handler", (ChannelHandler)new ProxyConnection(this.proxyService, this.proxyService.getDnsAddressResolverGroup()));
    }

    protected PulsarSslConfiguration buildSslConfiguration(ProxyConfiguration config) {
        return PulsarSslConfiguration.builder().tlsProvider(config.getTlsProvider()).tlsKeyStoreType(config.getTlsKeyStoreType()).tlsKeyStorePath(config.getTlsKeyStore()).tlsKeyStorePassword(config.getTlsKeyStorePassword()).tlsTrustStoreType(config.getTlsTrustStoreType()).tlsTrustStorePath(config.getTlsTrustStore()).tlsTrustStorePassword(config.getTlsTrustStorePassword()).tlsCiphers(config.getTlsCiphers()).tlsProtocols(config.getTlsProtocols()).tlsTrustCertsFilePath(config.getTlsTrustCertsFilePath()).tlsCertificateFilePath(config.getTlsCertificateFilePath()).tlsKeyFilePath(config.getTlsKeyFilePath()).allowInsecureConnection(config.isTlsAllowInsecureConnection()).requireTrustedClientCertOnConnect(config.isTlsRequireTrustedClientCertOnConnect()).tlsEnabledWithKeystore(config.isTlsEnabledWithKeyStore()).tlsCustomParams(config.getSslFactoryPluginParams()).authData(null).serverMode(true).build();
    }

    protected void refreshSslContext() {
        try {
            this.sslFactory.update();
        }
        catch (Exception e) {
            log.error("Failed to refresh SSL context", (Throwable)e);
        }
    }
}

