/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.TreeMap;
import org.apache.bookkeeper.clients.exceptions.ClientException;
import org.apache.bookkeeper.clients.exceptions.InternalServerException;
import org.apache.bookkeeper.clients.exceptions.InvalidNamespaceNameException;
import org.apache.bookkeeper.clients.exceptions.InvalidStreamNameException;
import org.apache.bookkeeper.clients.exceptions.NamespaceExistsException;
import org.apache.bookkeeper.clients.exceptions.NamespaceNotFoundException;
import org.apache.bookkeeper.clients.exceptions.StorageContainerException;
import org.apache.bookkeeper.clients.exceptions.StreamExistsException;
import org.apache.bookkeeper.clients.exceptions.StreamNotFoundException;
import org.apache.bookkeeper.clients.impl.internal.api.HashStreamRanges;
import org.apache.bookkeeper.common.util.ExceptionalFunction;
import org.apache.bookkeeper.stream.proto.RangeKeyType;
import org.apache.bookkeeper.stream.proto.RangeProperties;
import org.apache.bookkeeper.stream.proto.storage.GetActiveRangesResponse;
import org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.RelatedRanges;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;

public final class ProtocolInternalUtils {
    static final ExceptionalFunction<GetStorageContainerEndpointResponse, List<OneStorageContainerEndpointResponse>> GetStorageContainerEndpointsFunction = response -> {
        if (StatusCode.SUCCESS == response.getStatusCode()) {
            return response.getResponsesList();
        }
        throw new StorageContainerException(response.getStatusCode(), "Fail to get storage container endpoints");
    };

    private ProtocolInternalUtils() {
    }

    public static HashStreamRanges createActiveRanges(GetActiveRangesResponse response) {
        TreeMap ranges = Maps.newTreeMap();
        long lastEndKey = Long.MIN_VALUE;
        for (RelatedRanges rr : response.getRangesList()) {
            RangeProperties range = rr.getProps();
            long startKey = range.getStartHashKey();
            long endKey = range.getEndHashKey();
            Preconditions.checkState((lastEndKey == startKey ? 1 : 0) != 0, (String)"Invalid range key found : expected = %s, actual = %s", (long)lastEndKey, (long)startKey);
            ranges.put(startKey, range);
            lastEndKey = endKey;
        }
        Preconditions.checkState((Long.MAX_VALUE == lastEndKey ? 1 : 0) != 0, (String)"Missing key range [%s - %s)", (long)lastEndKey, (long)Long.MAX_VALUE);
        Preconditions.checkState((ranges.size() > 0 ? 1 : 0) != 0, (Object)"No active range found");
        return HashStreamRanges.ofHash(RangeKeyType.HASH, ranges);
    }

    public static Throwable createRootRangeException(String streamName, StatusCode statusCode) {
        switch (statusCode) {
            case INVALID_NAMESPACE_NAME: {
                return new InvalidNamespaceNameException(streamName);
            }
            case NAMESPACE_EXISTS: {
                return new NamespaceExistsException(streamName);
            }
            case NAMESPACE_NOT_FOUND: {
                return new NamespaceNotFoundException(streamName);
            }
            case INVALID_STREAM_NAME: {
                return new InvalidStreamNameException(streamName);
            }
            case STREAM_EXISTS: {
                return new StreamExistsException(streamName);
            }
            case STREAM_NOT_FOUND: {
                return new StreamNotFoundException(streamName);
            }
        }
        return new ClientException("fail to access its root range : code = " + statusCode);
    }

    public static Exception createMetaRangeException(String name, StatusCode statusCode) {
        switch (statusCode) {
            case STREAM_EXISTS: {
                return new StreamExistsException(name);
            }
            case STREAM_NOT_FOUND: {
                return new StreamNotFoundException(name);
            }
        }
        return new InternalServerException("Encountered internal server exception on stream " + name + " : code = " + statusCode);
    }
}

